/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.dialogs;

import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ast.ws.policyset.ui.dialogs.BindingConfigurationDialog;
import com.ibm.ast.ws.was7.policyset.ui.common.LTPATokenComposite;
import com.ibm.ast.ws.was7.policyset.ui.common.TokenComposite;
import com.ibm.ast.ws.was7.policyset.ui.dialogs.EncryptionInboundConfigurationComposite;
import com.ibm.ast.ws.was7.policyset.ui.dialogs.EncryptionOutboundConfigurationComposite;
import com.ibm.ast.ws.was7.policyset.ui.dialogs.SignatureInboundConfigurationComposite;
import com.ibm.ast.ws.was7.policyset.ui.dialogs.SignatureOutboundConfigurationComposite;
import com.ibm.ast.ws.was7.policyset.ui.dialogs.SymmetricInboundConfigurationComposite;
import com.ibm.ast.ws.was7.policyset.ui.dialogs.SymmetricOutboundConfigurationComposite;
import com.ibm.ast.ws.was7.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was7.policyset.ui.tokens.LTPAAuthenticationToken;
import com.ibm.ast.ws.was7.policyset.ui.types.PolicyType;
import com.ibm.ast.ws.was7.policyset.ui.types.WSSecurityPolicy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class WSSecurityBindingConfigurationDialog
extends BindingConfigurationDialog {
    private TabFolder tabFolder;
    private TabItem SymmetricTab;
    private TabItem digitalSignature;
    private TabItem xmlEncryption;
    private TabItem authentication;
    private String INFOPOP_WS_SECURITY_DIALOG = "WSS0007";
    private Button onlySignEntireHeadersAndBody;
    private Button onlySignEntireHeadersAndBodySymm;
    private SymmetricOutboundConfigurationComposite symmetricOut;
    private SymmetricInboundConfigurationComposite symmetricIn;
    private SignatureOutboundConfigurationComposite signOut;
    private SignatureInboundConfigurationComposite signIn;
    private EncryptionOutboundConfigurationComposite encryptionOut;
    private EncryptionInboundConfigurationComposite encryptionIn;
    private boolean bootstrap;
    private TokenComposite auth;
    private WSSecurityPolicy policyType;
    private String INFOPOP_WSS_MSG_EXP_CHECK = "WSS0013";
    private Button enableMessageExp;
    private String INFOPOP_WSS_MSG_EXP_TEXT = "WSS0014";
    private Text messageExpirationTime;

    public WSSecurityBindingConfigurationDialog(Shell parent, PolicyType type) {
        super(parent);
        this.policyType = (WSSecurityPolicy)type;
    }

    protected Control createDialogArea(Composite parent) {
        String tabTitle;
        Composite parent_ = (Composite)super.createDialogArea(parent);
        this.setTitle(this.getMessage("CONFIGURE_WSSECURITY_DIALOG_TITLE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent_, "com.ibm.ast.ws.was7.policyset.ui." + this.INFOPOP_WS_SECURITY_DIALOG);
        new Label(parent_, 256);
        new Label(parent_, 256);
        this.tabFolder = new TabFolder(parent_, 0);
        GridData gd = new GridData(1808);
        this.tabFolder.setLayoutData((Object)gd);
        if (this.policyType.getGeneratorSymmetricObject() != null) {
            this.SymmetricTab = new TabItem(this.tabFolder, 0);
            this.SymmetricTab.setText(Activator.getMessage("SYMMETRIC_CONFIG"));
            this.SymmetricTab.setControl(this.createSymmetricConfigPage((Composite)this.tabFolder));
        }
        boolean bl = this.bootstrap = this.policyType.getGeneratorSymmetricObject() != null;
        if (this.policyType.getSignInbound() != null || this.policyType.getSignOutbound() != null) {
            this.digitalSignature = new TabItem(this.tabFolder, 0);
            tabTitle = this.bootstrap ? Activator.getMessage("BOOTSTRAP_DIGITAL_SIGNATURE") : Activator.getMessage("DIGITAL_SIGNATURE_CONFIG");
            this.digitalSignature.setText(tabTitle);
            this.digitalSignature.setControl(this.createDigitalSignatureConfigPage((Composite)this.tabFolder));
        }
        if (this.policyType.getEncInbound() != null || this.policyType.getEncOutbound() != null) {
            this.xmlEncryption = new TabItem(this.tabFolder, 0);
            tabTitle = this.bootstrap ? Activator.getMessage("BOOTSTRAP_XML_ENCRYPTION") : Activator.getMessage("XML_ENCRYPTION_CONFIG");
            this.xmlEncryption.setText(tabTitle);
            this.xmlEncryption.setControl(this.createXMLEncryptionConfigPage((Composite)this.tabFolder));
        }
        if (this.policyType.getAuthenticationToken() != null) {
            this.authentication = new TabItem(this.tabFolder, 0);
            this.authentication.setText(this.getMessage("AUTHENTICATION_CONFIG_TAB"));
            this.authentication.setControl(this.createAuthenticationConfigPage((Composite)this.tabFolder));
        }
        Composite messageExpiry = this.uiUtils.createComposite(parent_, 1);
        this.enableMessageExp = this.uiUtils.createCheckbox(messageExpiry, this.getMessage("CHECKBOX_ENABLE_MESSAGE_EXP"), this.getMessage("TOOLTIP_MESSAGE_EXPIRATION"), this.INFOPOP_WSS_MSG_EXP_CHECK);
        this.enableMessageExp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSSecurityBindingConfigurationDialog.this.messageExpirationTime.setEnabled(WSSecurityBindingConfigurationDialog.this.enableMessageExp.getSelection());
                WSSecurityBindingConfigurationDialog.this.getStatusListener().handleEvent(null);
            }
        });
        Composite messageExpiryInterval = this.uiUtils.createComposite(parent_, 6);
        this.messageExpirationTime = this.uiUtils.createText(messageExpiryInterval, this.getMessage("LABEL_MESSAGE_EXP_INTERVAL"), this.getMessage("TOOLTIP_MESSAGE_EXPIRATION"), this.INFOPOP_WSS_MSG_EXP_TEXT, 2048);
        this.uiUtils.createText(messageExpiryInterval, this.getMessage("LABEL_MESSAGE_EXP_MINUTES"), null, null, 8);
        String expTime = this.policyType.getMessageExpiryTime();
        if (expTime != null) {
            this.enableMessageExp.setSelection(true);
            this.messageExpirationTime.setEnabled(true);
            this.messageExpirationTime.setText(expTime);
        } else {
            this.enableMessageExp.setSelection(false);
            this.messageExpirationTime.setEnabled(false);
        }
        this.messageExpirationTime.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WSSecurityBindingConfigurationDialog.this.getStatusListener().handleEvent(null);
            }
        });
        this.tabFolder.addListener(13, this.getStatusListener());
        return parent;
    }

    private Control createDigitalSignatureConfigPage(Composite parent) {
        ScrolledComposite scomp = new ScrolledComposite(parent, 768);
        Composite signatureGroup = this.uiUtils.createComposite((Composite)scomp, 1);
        new Label(signatureGroup, 0);
        this.onlySignEntireHeadersAndBody = this.uiUtils.createCheckbox(signatureGroup, Activator.getMessage("CHECKBOX_ONLY_SIGN_ENTIRE_HEAD_AND_BODY"), null, null);
        if (this.policyType.getSignOutbound() != null) {
            this.signOut = new SignatureOutboundConfigurationComposite();
            this.signOut.addControls(signatureGroup, this.getStatusListener());
            this.signOut.init(this.policyType);
        }
        if (this.policyType.getSignInbound() != null) {
            this.signIn = new SignatureInboundConfigurationComposite();
            this.signIn.addControls(signatureGroup, this.getStatusListener());
            this.signIn.init(this.policyType);
        }
        this.onlySignEntireHeadersAndBody.setSelection(this.bootstrap ? this.policyType.isOnlySignEntireHeadersAndBodyBoot() : this.policyType.isOnlySignEntireHeadersAndBodyApp());
        scomp.setExpandHorizontal(true);
        scomp.setExpandVertical(true);
        scomp.setContent((Control)signatureGroup);
        scomp.setMinSize(signatureGroup.computeSize(-1, -1));
        return scomp;
    }

    private Control createSymmetricConfigPage(Composite parent) {
        ScrolledComposite scomp = new ScrolledComposite(parent, 768);
        Composite symmetricGroup = this.uiUtils.createComposite((Composite)scomp, 1);
        new Label(symmetricGroup, 0);
        this.onlySignEntireHeadersAndBodySymm = this.uiUtils.createCheckbox(symmetricGroup, Activator.getMessage("CHECKBOX_ONLY_SIGN_ENTIRE_HEAD_AND_BODY"), null, null);
        this.symmetricOut = new SymmetricOutboundConfigurationComposite();
        this.symmetricOut.addControls(symmetricGroup, this.getStatusListener());
        this.symmetricOut.init(this.policyType);
        this.symmetricIn = new SymmetricInboundConfigurationComposite();
        this.symmetricIn.addControls(symmetricGroup, this.getStatusListener());
        this.symmetricIn.init(this.policyType);
        this.onlySignEntireHeadersAndBodySymm.setSelection(this.policyType.isOnlySignEntireHeadersAndBodyApp());
        scomp.setExpandHorizontal(true);
        scomp.setExpandVertical(true);
        scomp.setContent((Control)symmetricGroup);
        scomp.setMinSize(symmetricGroup.computeSize(-1, -1));
        return scomp;
    }

    private Control createXMLEncryptionConfigPage(Composite parent) {
        ScrolledComposite scomp = new ScrolledComposite(parent, 768);
        Composite encryptionGroup = this.uiUtils.createComposite((Composite)scomp, 1);
        if (this.policyType.getEncOutbound() != null) {
            this.encryptionOut = new EncryptionOutboundConfigurationComposite();
            this.encryptionOut.addControls(encryptionGroup, this.getStatusListener());
            this.encryptionOut.init(this.policyType);
        }
        if (this.policyType.getEncInbound() != null) {
            this.encryptionIn = new EncryptionInboundConfigurationComposite();
            this.encryptionIn.addControls(encryptionGroup, this.getStatusListener());
            this.encryptionIn.init(this.policyType);
        }
        scomp.setExpandHorizontal(true);
        scomp.setExpandVertical(true);
        scomp.setContent((Control)encryptionGroup);
        scomp.setMinSize(encryptionGroup.computeSize(-1, -1));
        return scomp;
    }

    private Control createAuthenticationConfigPage(Composite parent) {
        ScrolledComposite scomp = new ScrolledComposite(parent, 768);
        Composite authGroup = this.uiUtils.createComposite((Composite)scomp, 2);
        new Label(authGroup, 256);
        new Label(authGroup, 256);
        this.auth = this.policyType.getAuthenticationToken() instanceof LTPAAuthenticationToken ? new LTPATokenComposite() : new TokenComposite();
        this.auth.addControls(authGroup, this.getStatusListener());
        this.auth.setToken(this.policyType.getAuthenticationToken());
        scomp.setExpandHorizontal(true);
        scomp.setExpandVertical(true);
        scomp.setContent((Control)authGroup);
        scomp.setMinSize(authGroup.computeSize(-1, -1));
        return scomp;
    }

    protected void okPressed() {
        if (this.enableMessageExp.getSelection()) {
            this.policyType.setMessageExpiryTime(this.messageExpirationTime.getText().trim());
        } else {
            this.policyType.setMessageExpiryTime(null);
        }
        if (this.digitalSignature != null) {
            if (this.signOut != null) {
                this.signOut.getSecurityObject(this.policyType);
            }
            if (this.signIn != null) {
                this.signIn.getSecurityObject(this.policyType);
            }
            if (this.bootstrap) {
                this.policyType.setOnlySignEntireHeadersAndBodyBoot(this.onlySignEntireHeadersAndBody.getSelection());
            } else {
                this.policyType.setOnlySignEntireHeadersAndBodyApp(this.onlySignEntireHeadersAndBody.getSelection());
            }
        }
        if (this.xmlEncryption != null) {
            if (this.encryptionOut != null) {
                this.encryptionOut.getSecurityObject(this.policyType);
            }
            if (this.encryptionIn != null) {
                this.encryptionIn.getSecurityObject(this.policyType);
            }
        }
        if (this.auth != null) {
            this.auth.getToken(this.policyType.getAuthenticationToken());
        }
        if (this.SymmetricTab != null) {
            this.symmetricOut.getSecurityObject(this.policyType);
            this.symmetricIn.getSecurityObject(this.policyType);
            this.policyType.setOnlySignEntireHeadersAndBodyApp(this.onlySignEntireHeadersAndBodySymm.getSelection());
        }
        super.okPressed();
    }

    protected IStatus getStatus() {
        MultiStatus status = new MultiStatus("com.ibm.ast.ws.was7.policyset.ui", 0, "", null);
        if (this.enableMessageExp.getSelection()) {
            try {
                Integer timeDouble = new Integer(this.messageExpirationTime.getText());
                if (timeDouble <= 0) {
                    status.add(StatusUtils.errorStatus((String)Activator.getMessage("ERROR_INVALID_MESSAGE_EXP")));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.add(StatusUtils.errorStatus((String)Activator.getMessage("ERROR_INVALID_MESSAGE_EXP")));
            }
        }
        if (this.digitalSignature != null && this.tabFolder.getSelectionIndex() == this.tabFolder.indexOf(this.digitalSignature)) {
            boolean imageStatus = true;
            if (this.signOut != null) {
                this.signOut.getStatus(status);
            }
            if (this.signIn != null) {
                this.signIn.getStatus(status);
            }
            if (status.getSeverity() != 0) {
                imageStatus = false;
            }
            this.digitalSignature.setImage(imageStatus ? null : JFaceResources.getImage((String)"dialog_message_error_image"));
        }
        if (this.xmlEncryption != null && this.tabFolder.getSelectionIndex() == this.tabFolder.indexOf(this.xmlEncryption)) {
            boolean imageStatus = true;
            if (this.encryptionOut != null) {
                this.encryptionOut.getStatus(status);
            }
            if (this.encryptionIn != null) {
                this.encryptionIn.getStatus(status);
            }
            if (status.getSeverity() != 0) {
                imageStatus = false;
            }
            this.xmlEncryption.setImage(imageStatus ? null : JFaceResources.getImage((String)"dialog_message_error_image"));
        }
        if (this.SymmetricTab != null && this.tabFolder.getSelectionIndex() == this.tabFolder.indexOf(this.SymmetricTab)) {
            boolean imageStatus = true;
            this.symmetricOut.getStatus(status);
            this.symmetricIn.getStatus(status);
            if (status.getSeverity() != 0) {
                imageStatus = false;
            }
            this.SymmetricTab.setImage(imageStatus ? null : JFaceResources.getImage((String)"dialog_message_error_image"));
        }
        if (this.authentication != null && this.tabFolder.getSelectionIndex() == this.tabFolder.indexOf(this.authentication)) {
            boolean imageStatus = true;
            if (this.auth.getStatus() != Status.OK_STATUS) {
                status.add(StatusUtils.errorStatus((String)Activator.getMessage(this.auth.getStatus().getMessage(), new String[]{Activator.getMessage("AUTHENTICATION_CONFIG")})));
            }
            if (status.getSeverity() != 0) {
                imageStatus = false;
            }
            this.authentication.setImage(imageStatus ? null : JFaceResources.getImage((String)"dialog_message_error_image"));
        }
        return status;
    }
}

