/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.dialogs;

import com.ibm.ast.ws.service.policy.ui.NamedBindingstUtils;
import com.ibm.ast.ws.service.policy.ui.PolicySetUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.BindingObject;
import com.ibm.ast.ws.was7.policyset.ui.common.WSPolicyClientControlReferenceObject;
import com.ibm.ast.ws.was7.policyset.ui.common.WSPolicyControlReferenceObject;
import com.ibm.ast.ws.was7.policyset.ui.common.WSPolicyServiceControlReferenceObject;
import com.ibm.ast.ws.was7.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was7.policyset.ui.types.WSAddressingPolicy;
import com.ibm.ast.ws.wsi.validation.WSIValidationUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseStatusHandler;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSMetadataExchangeComposite
extends SimpleWidgetDataContributor {
    private String INFOPOP_TRANSPORT_ONLY_RADIO = "PSD0001";
    private Button transportOnlyRadio;
    private String INFOPOP_TRANSPORT_N_MESSAGE_RADIO = "PSD0002";
    private Button transportNPolicySetRadio;
    private String INFOPOP_POLICYSET_COMBO = "PSD0003";
    private Combo policySetCombo;
    private String INFOPOP_BINDING_COMBO = "PSD0004";
    private Combo bindingCombo;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = Activator.getUiUtils();
        Composite indentedComposite = uiUtils.createComposite(parent, 1);
        GridData gd = new GridData(1808);
        gd.horizontalIndent = 20;
        indentedComposite.setLayoutData((Object)gd);
        this.transportOnlyRadio = uiUtils.createRadioButton(indentedComposite, Activator.getMessage("WS_MEX_APPLICATION_SECURITY"), null, this.INFOPOP_TRANSPORT_ONLY_RADIO);
        this.transportNPolicySetRadio = uiUtils.createRadioButton(indentedComposite, Activator.getMessage("WS_MEX_POLICY_SET"), null, this.INFOPOP_TRANSPORT_N_MESSAGE_RADIO);
        Composite secondIndentedComposite = uiUtils.createComposite(indentedComposite, 2);
        secondIndentedComposite.setLayoutData((Object)gd);
        this.policySetCombo = uiUtils.createCombo(secondIndentedComposite, Activator.getMessage("LABEL_POLICYSET"), null, this.INFOPOP_POLICYSET_COMBO, 2056);
        this.bindingCombo = uiUtils.createCombo(secondIndentedComposite, Activator.getMessage("LABEL_BINDING"), null, this.INFOPOP_BINDING_COMBO, 2056);
        this.transportOnlyRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSMetadataExchangeComposite.this.enableCombos(true);
            }
        });
        this.transportNPolicySetRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSMetadataExchangeComposite.this.enableCombos(true);
            }
        });
        this.enableCombos(false);
        return this;
    }

    private void enableCombos(boolean enable) {
        boolean enabled = enable && this.transportNPolicySetRadio.getSelection();
        this.policySetCombo.setEnabled(enabled);
        this.bindingCombo.setEnabled(enabled);
    }

    public void setEnabled(boolean enabled) {
        this.transportOnlyRadio.setEnabled(enabled);
        this.transportNPolicySetRadio.setEnabled(enabled);
        this.enableCombos(enabled);
    }

    public void setBindings(Map<String, BindingObject> bindings) {
        this.bindingCombo.removeAll();
        for (String binding : bindings.keySet()) {
            this.bindingCombo.add(binding);
        }
        this.bindingCombo.select(0);
    }

    private void setPolicySets() {
        this.policySetCombo.removeAll();
        List mexPolicySets = PolicySetUtils.getPolicySets((String)"com.ibm.ast.ws.service.policy.ui.policyset.category70.sys");
        for (IServicePolicy policySet : mexPolicySets) {
            this.policySetCombo.add(policySet.getDescriptor().getLongName());
        }
    }

    public boolean getWSPolicyControlReference(WSPolicyControlReferenceObject clientWSPolicyControlReference) {
        int severity = WSIValidationUtils.getWSISeverity((String)WSIValidationUtils.getProjectWSICompliance(null, (String)"org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsissbp"));
        if (severity != 1) {
            HashMap<String, IServicePolicy> policySetInstances = new HashMap<String, IServicePolicy>();
            List PolicySets = PolicySetUtils.getPolicySets((String)"com.ibm.ast.ws.service.policy.ui.policyset.category70.sys");
            for (IServicePolicy policyS : PolicySets) {
                policySetInstances.put(policyS.getDescriptor().getShortName(), policyS);
            }
            Vector<Status> statusList = new Vector<Status>();
            List policies = PolicySetUtils.getPolicies((IServicePolicy)((IServicePolicy)policySetInstances.get(this.policySetCombo.getText())));
            for (IServicePolicy policy : policies) {
                String policyTypeName = policy.getDescriptor().getShortName();
                if (!policyTypeName.equals(WSAddressingPolicy.PolicyTypeName)) continue;
                statusList.add(new Status(severity, "ClientSidePolicySharingConfigDialog", 0, Activator.getMessage("ERROR_WSI_BP10_WSADDRESSING"), null));
            }
            Status[] statuses = statusList.toArray(new Status[statusList.size()]);
            if (statuses.length != 0 && !WSIValidationUtils.checkWSICompliance((IStatusHandler)new EclipseStatusHandler(), (Status[])statuses, null, (int)severity, (String)(severity == 4 ? Activator.getMessage("WSI_BP10_ERROR") : Activator.getMessage("WSI_BP10_WARNING")), (String)"org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsissbp")) {
                return false;
            }
        }
        if (this.transportOnlyRadio.getSelection()) {
            clientWSPolicyControlReference.setWsMexPolicySetBinding(null);
            clientWSPolicyControlReference.setWsMexPolicySetName(null);
        } else {
            String binding = this.bindingCombo.getText().equals(Activator.getMessage("USE_CLIENT_DEFAULT_DEFAULT_BINDING")) ? null : this.bindingCombo.getText();
            clientWSPolicyControlReference.setWsMexPolicySetBinding(binding);
            clientWSPolicyControlReference.setWsMexPolicySetName(this.policySetCombo.getText());
        }
        return true;
    }

    public void setWSPolicyControlReference(WSPolicyControlReferenceObject wsPolicyControlReference) {
        this.setPolicySets();
        if (wsPolicyControlReference.getWsMexPolicySetName() != null) {
            this.policySetCombo.setText(wsPolicyControlReference.getWsMexPolicySetName());
            if (wsPolicyControlReference.getWsMexPolicySetBinding() != null) {
                this.bindingCombo.setText(wsPolicyControlReference.getWsMexPolicySetBinding());
            } else {
                this.bindingCombo.setText(Activator.getMessage("USE_CLIENT_DEFAULT_DEFAULT_BINDING"));
            }
        } else {
            this.policySetCombo.setText(PolicySetUtils.getDefaultPolicySet(null, (String)"com.ibm.ast.ws.service.policy.ui.policyset.category70.sys").getDescriptor().getLongName());
            if (wsPolicyControlReference instanceof WSPolicyClientControlReferenceObject) {
                this.bindingCombo.setText(NamedBindingstUtils.getDefaultClientNamedBinding(null).getDescriptor().getLongName());
            } else if (wsPolicyControlReference instanceof WSPolicyServiceControlReferenceObject) {
                this.bindingCombo.setText(NamedBindingstUtils.getDefaultProviderNamedBinding(null).getDescriptor().getLongName());
            }
        }
        this.transportOnlyRadio.setSelection(wsPolicyControlReference.isWSMexSecuredByTransportOnly());
        this.transportNPolicySetRadio.setSelection(!wsPolicyControlReference.isWSMexSecuredByTransportOnly());
    }
}

