/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.dialogs;

import com.ibm.ast.ws.was7.policyset.ui.common.BindingObject;
import com.ibm.ast.ws.was7.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was7.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was7.policyset.ui.types.WSReliableMessagingPolicy;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigureEndpointDialog
extends TitleAreaDialog {
    protected String title_;
    private String INFOPOP_END_SERVICE_TEXT = "END0001";
    protected Control serviceName;
    private String INFOPOP_END_PORT_TEXT = "END0002";
    protected Control portType;
    private String INFOPOP_END_OPERATION_TEXT = "END0003";
    protected Control operation;
    private String INFOPOP_END_POLICYSET_COMBO = "END0004";
    protected Combo policySetCombo;
    private String INFOPOP_END_BINDING_COMBO = "END0005";
    private String INFOPOP_END_APPLICATION_GROUP = "END0006";
    protected EndPointObject endPointObject;
    protected Combo bindingCombo;
    protected int bindingStyle;
    protected Listener statusListener;
    protected Map<String, IServicePolicy> policySetInstances;
    protected Map<String, BindingObject> bindingInstances;
    protected Combo[] stackedBindingCombos = new Combo[2];
    protected final StackLayout layout = new StackLayout();
    protected final int USE_PROVIDER_POLICY = 0;
    protected final int USE_CLIENT_POLICY_ONLY = 1;
    private boolean isEditMode = false;
    private Image titleImage;

    protected abstract String getImageFile();

    public ConfigureEndpointDialog(Shell parent) {
        super(parent);
        this.title_ = Activator.getMessage("DEFINE_APPLICATION_ENDPOINT_DIALOG_TITLE");
        this.setShellStyle(0x10870 | ConfigureEndpointDialog.getDefaultOrientation());
        this.endPointObject = null;
        this.isEditMode = false;
    }

    public ConfigureEndpointDialog(Shell parent, EndPointObject endpointObject) {
        this(parent);
        this.endPointObject = endpointObject;
        if (endpointObject != null) {
            this.isEditMode = true;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.titleImage = Activator.imageDescriptorFromPlugin((String)"com.ibm.ast.ws.was7.policyset.ui", (String)this.getImageFile()).createImage();
        this.setTitleImage(this.titleImage);
        newShell.setText(this.title_);
    }

    protected Control createDialogArea(Composite parent1) {
        Composite parent = (Composite)super.createDialogArea(parent1);
        UIUtils uiUtils = Activator.getUiUtils();
        GridData gd = new GridData(768);
        gd.widthHint = 400;
        parent.setLayoutData((Object)gd);
        Group applicationGroup = uiUtils.createGroup(parent, Activator.getMessage("LABEL_APPLICATION"), Activator.getMessage("TOOLTIP_END_APPLICATION_GROUP"), this.INFOPOP_END_APPLICATION_GROUP, 2, -1, -1);
        if (this.isEditMode) {
            this.serviceName = uiUtils.createText((Composite)applicationGroup, Activator.getMessage("LABEL_SERVICE_NAME"), Activator.getMessage("TOOLTIP_END_SERVICE_TEXT"), this.INFOPOP_END_SERVICE_TEXT, 2056);
            this.portType = uiUtils.createText((Composite)applicationGroup, Activator.getMessage("LABEL_ENDPOINT"), Activator.getMessage("TOOLTIP_END_PORT_TEXT"), this.INFOPOP_END_PORT_TEXT, 2056);
            this.operation = uiUtils.createText((Composite)applicationGroup, Activator.getMessage("LABEL_OPERATION"), Activator.getMessage("TOOLTIP_END_OPERATION_TEXT"), this.INFOPOP_END_OPERATION_TEXT, 2056);
        } else {
            this.serviceName = uiUtils.createCombo((Composite)applicationGroup, Activator.getMessage("LABEL_SERVICE_NAME"), Activator.getMessage("TOOLTIP_END_SERVICE_TEXT"), this.INFOPOP_END_SERVICE_TEXT, 2056);
            this.portType = uiUtils.createCombo((Composite)applicationGroup, Activator.getMessage("LABEL_ENDPOINT"), Activator.getMessage("TOOLTIP_END_PORT_TEXT"), this.INFOPOP_END_PORT_TEXT, 2056);
            this.operation = uiUtils.createCombo((Composite)applicationGroup, Activator.getMessage("LABEL_OPERATION"), Activator.getMessage("TOOLTIP_END_OPERATION_TEXT"), this.INFOPOP_END_OPERATION_TEXT, 2056);
        }
        new Label(parent, 256);
        Composite config = uiUtils.createComposite(parent, 2);
        this.policySetCombo = uiUtils.createCombo(config, Activator.getMessage("LABEL_POLICYSET"), Activator.getMessage("TOOLTIP_END_POLICYSET_COMBO"), this.INFOPOP_END_POLICYSET_COMBO, 2056);
        Label label = new Label(config, 64);
        label.setText(Activator.getMessage("LABEL_BINDING"));
        label.setToolTipText(Activator.getMessage("TOOLTIP_END_BINDING_COMBO"));
        Composite bindingComboComposite = uiUtils.createComposite(config, 1);
        bindingComboComposite.setLayout((Layout)this.layout);
        this.stackedBindingCombos[0] = new Combo(bindingComboComposite, 2048);
        GridData griddata = new GridData(768);
        this.stackedBindingCombos[0].setLayoutData((Object)griddata);
        this.stackedBindingCombos[0].setToolTipText(Activator.getMessage("TOOLTIP_END_BINDING_COMBO"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.stackedBindingCombos[0], "com.ibm.ast.ws.was7.policyset.ui." + this.INFOPOP_END_BINDING_COMBO);
        this.stackedBindingCombos[1] = new Combo(bindingComboComposite, 2048);
        this.stackedBindingCombos[1].setLayoutData((Object)griddata);
        this.stackedBindingCombos[1].setToolTipText(Activator.getMessage("TOOLTIP_END_BINDING_COMBO"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.stackedBindingCombos[1], "com.ibm.ast.ws.was7.policyset.ui." + this.INFOPOP_END_BINDING_COMBO);
        this.layout.topControl = this.stackedBindingCombos[0];
        bindingComboComposite.layout();
        this.bindingCombo = (Combo)this.layout.topControl;
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getStatusListener().handleEvent(null);
        return control;
    }

    public EndPointObject getEndPoint() {
        return this.endPointObject;
    }

    protected IStatus getStatus() {
        return Status.OK_STATUS;
    }

    protected Listener getStatusListener() {
        if (this.statusListener == null) {
            this.statusListener = new Listener(){

                public void handleEvent(Event event) {
                    IStatus status = ConfigureEndpointDialog.this.getStatus();
                    if (status.getSeverity() == 4) {
                        ConfigureEndpointDialog.this.setMessage(status.getMessage(), 3);
                        ConfigureEndpointDialog.this.getButton(0).setEnabled(false);
                    } else if (status.getSeverity() == 2) {
                        ConfigureEndpointDialog.this.setMessage(status.getMessage(), 2);
                        ConfigureEndpointDialog.this.getButton(0).setEnabled(true);
                    } else {
                        ConfigureEndpointDialog.this.setMessage(null);
                        ConfigureEndpointDialog.this.getButton(0).setEnabled(true);
                    }
                }
            };
        }
        return this.statusListener;
    }

    public Map<String, IServicePolicy> getPolicySets() {
        return this.policySetInstances;
    }

    public void setPolicySets(Map<String, IServicePolicy> instances) {
        this.policySetInstances = instances;
    }

    public Map<String, BindingObject> getBindings() {
        return this.bindingInstances;
    }

    public void setBindings(Map<String, BindingObject> bindingInstances) {
        this.bindingInstances = bindingInstances;
    }

    protected void refreshPolicySets() {
        boolean endPontLevelNotDefined;
        String policySetValue = this.policySetCombo.getText();
        this.policySetCombo.removeAll();
        String endPoint = null;
        endPoint = this.portType instanceof Combo ? ((Combo)this.portType).getText() : ((Text)this.portType).getText();
        boolean bl = endPontLevelNotDefined = endPoint.equals(Activator.getMessage("LABEL_ALL_ENDPOINTS")) || endPoint.equals("");
        if (endPontLevelNotDefined) {
            for (IServicePolicy policySet : this.policySetInstances.values()) {
                this.policySetCombo.add(policySet.getDescriptor().getLongName());
            }
        } else {
            for (IServicePolicy policySet : this.policySetInstances.values()) {
                boolean WSRM = false;
                for (IServicePolicy policy : policySet.getChildren()) {
                    if (!policy.getDescriptor().getShortName().equals(WSReliableMessagingPolicy.PolicyTypeName)) continue;
                    WSRM = true;
                }
                if (WSRM) continue;
                this.policySetCombo.add(policySet.getDescriptor().getLongName());
            }
        }
        if (this.policySetCombo.indexOf(policySetValue) == -1) {
            this.policySetCombo.select(0);
        } else {
            this.policySetCombo.setText(policySetValue);
        }
    }

    protected void enableControls() {
        boolean enablePortAndOp = !((Combo)this.serviceName).getText().equals(Activator.getMessage("LABEL_ALL_SERVICES"));
        this.portType.setEnabled(enablePortAndOp);
        this.operation.setEnabled(enablePortAndOp);
        if (!enablePortAndOp) {
            ((Combo)this.portType).setText(Activator.getMessage("LABEL_ALL_ENDPOINTS"));
            ((Combo)this.operation).setText(Activator.getMessage("LABEL_ALL_OPERATIONS"));
            return;
        }
        if (((Combo)this.portType).getText().equals(Activator.getMessage("LABEL_ALL_ENDPOINTS"))) {
            this.operation.setEnabled(false);
            ((Combo)this.operation).setText(Activator.getMessage("LABEL_ALL_OPERATIONS"));
        } else {
            this.operation.setEnabled(true);
        }
    }

    protected void replaceBlankWithAll() {
        boolean blankSelected = ((Combo)this.portType).getText().equals("");
        if (((Combo)this.portType).indexOf("") != -1) {
            ((Combo)this.portType).remove("");
            if (((Combo)this.portType).indexOf(Activator.getMessage("LABEL_ALL_ENDPOINTS")) == -1) {
                ((Combo)this.portType).add(Activator.getMessage("LABEL_ALL_ENDPOINTS"), 0);
            }
        }
        if (!this.isEditMode && ((Combo)this.portType).indexOf(Activator.getMessage("LABEL_ALL_ENDPOINTS")) == -1) {
            ((Combo)this.portType).add(Activator.getMessage("LABEL_ALL_ENDPOINTS"), 0);
        }
        if (blankSelected) {
            ((Combo)this.portType).setText(Activator.getMessage("LABEL_ALL_ENDPOINTS"));
        }
        this.replaceBlankInOpWithAll();
    }

    protected void replaceBlankInOpWithAll() {
        boolean blankSelected = ((Combo)this.operation).getText().equals("");
        if (((Combo)this.operation).indexOf("") != -1) {
            ((Combo)this.operation).remove("");
            if (((Combo)this.operation).indexOf(Activator.getMessage("LABEL_ALL_OPERATIONS")) == -1) {
                ((Combo)this.operation).add(Activator.getMessage("LABEL_ALL_OPERATIONS"), 0);
            }
        }
        if (!this.isEditMode && ((Combo)this.operation).indexOf(Activator.getMessage("LABEL_ALL_OPERATIONS")) == -1) {
            ((Combo)this.operation).add(Activator.getMessage("LABEL_ALL_OPERATIONS"), 0);
        }
        if (blankSelected) {
            ((Combo)this.operation).setText(Activator.getMessage("LABEL_ALL_OPERATIONS"));
        }
    }

    protected boolean isEditMode() {
        return this.isEditMode;
    }

    public boolean close() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        return super.close();
    }
}

