/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.common;

import com.ibm.ast.ws.jaxws.emitter.collector.ClientData;
import com.ibm.ast.ws.jaxws.emitter.collector.ServiceData;
import com.ibm.ast.ws.jaxws.emitter.util.ProjectDescriptionRegistry;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.service.policy.ui.PolicySetUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.BindingObject;
import com.ibm.ast.ws.was7.policyset.ui.common.ClientEndPointObject;
import com.ibm.ast.ws.was7.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was7.policyset.ui.common.ServiceEndPointObject;
import com.ibm.ast.ws.was7.policyset.ui.plugin.Activator;
import com.ibm.ws.ast.facets.core.IFacetConstants;
import com.ibm.ws.ast.st.common.core.internal.config.WASConfigModelCommonHelper;
import com.ibm.ws.ast.st.core.WASRuntimeLocator;
import com.ibm.ws.ast.st.v7.core.internal.jmx.WASConfigModelHelper;
import com.ibm.wsspi.profile.registry.Profile;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyUtils {
    private static IPath cellLevelLocation = null;

    public static String expandURL(String url) {
        String newURL = url;
        newURL = url.startsWith("local:") ? url.replaceFirst("local:", PolicySetUtils.getLocalRootPath()) : String.valueOf(PolicyUtils.getCellLevelLocation().toString()) + url;
        return newURL;
    }

    public static List<EndPointObject> readClientPolicyAttachments(IProject application, Map<String, IServicePolicy> policySets, Map<String, BindingObject> bindings) {
        PolicySetAttachment policySet = PolicyUtils.readPolicyAttachments(application, "clientPolicyAttachments.xml");
        if (policySet != null && policySets != null) {
            return PolicyUtils.getPolicySetAttachments(policySet, application, policySets, bindings, false);
        }
        return new Vector<EndPointObject>();
    }

    public static List<EndPointObject> readServerPolicyAttachments(IProject application, Map<String, IServicePolicy> policySets, Map<String, BindingObject> bindings) {
        PolicySetAttachment policySet = PolicyUtils.readPolicyAttachments(application, "policyAttachments.xml");
        if (policySet != null && policySets != null) {
            return PolicyUtils.getPolicySetAttachments(policySet, application, policySets, bindings, true);
        }
        return new Vector<EndPointObject>();
    }

    public static Map<String, IServicePolicy> getSupportedPolicySets(IProject project, Map<String, IServicePolicy> existingPolicySets) {
        if (!ProjectDescriptionRegistry.getInstance().isUnmanagedProject(project)) {
            return existingPolicySets;
        }
        String[] supportedTypes = ProjectDescriptionRegistry.getInstance().getSupportedPolicyTypes(project);
        HashMap<String, IServicePolicy> newList = new HashMap<String, IServicePolicy>();
        for (IServicePolicy policySet : existingPolicySets.values()) {
            boolean isSupportedSet = true;
            for (IServicePolicy policyType : policySet.getChildren()) {
                boolean isSupportedType = false;
                String type = policyType.getDescriptor().getLongName();
                String[] stringArray = supportedTypes;
                int n = supportedTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String supportedType = stringArray[n2];
                    if (type.equals(supportedType)) {
                        isSupportedType = true;
                        break;
                    }
                    ++n2;
                }
                if (isSupportedType) continue;
                isSupportedSet = false;
                break;
            }
            if (!isSupportedSet) continue;
            newList.put(policySet.getDescriptor().getLongName(), policySet);
        }
        return newList;
    }

    private static PolicySetAttachment readPolicyAttachments(IProject application, String filename) {
        return PolicyUtils.readExistingPolicySetAttachment(CommonPolicyUtils.getOutputFolder((IProject)application, (boolean)true).getLocation().addTrailingSeparator().append(filename));
    }

    public static IPath getCellLevelLocation() {
        if (cellLevelLocation == null) {
            IPath wasInstallPath;
            Path path = null;
            ServerUtil.getModules((String)"");
            IPath stubLocation = WASRuntimeLocator.getRuntimeStubLocation((byte)37);
            if (stubLocation != null) {
                cellLevelLocation = PolicyUtils.getDevProfileCellLocation(stubLocation);
            }
            if (cellLevelLocation == null && (wasInstallPath = WASRuntimeLocator.getRuntimeLocation((byte)35)) != null) {
                Profile[] profileArray = WASConfigModelHelper.getProfiles((String)wasInstallPath.toString());
                int n = profileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Profile profile = profileArray[n2];
                    path = new Path(WASConfigModelCommonHelper.getCellLevelLocation((String)profile.getPath().toString()));
                    if (path.append("PolicySets").toFile().exists()) {
                        cellLevelLocation = path;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return cellLevelLocation;
    }

    private static IPath getDevProfileCellLocation(IPath path) {
        if (path == null) {
            return null;
        }
        try {
            IPath profilePath = path.append("profiles");
            profilePath = profilePath.append("dev_profile");
            profilePath = profilePath.append("config");
            profilePath = profilePath.append("cells");
            profilePath = profilePath.append("localhostNode01Cell");
            if (profilePath.append("PolicySets").toFile().exists()) {
                return profilePath;
            }
            throw new Exception();
        }
        catch (Exception exception) {
            Activator.getDefault().getLog().log(StatusUtils.warningStatus((String)("PolicyUtils.getDevProfileCellLocation(): The development profile could not be found for the given runtime stub: path=" + path.toString())));
            return null;
        }
    }

    private static PolicySetAttachment readExistingPolicySetAttachment(IPath fileLocation) {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200605.policysetattachment");
            Unmarshaller u = jc.createUnmarshaller();
            return (PolicySetAttachment)u.unmarshal((InputStream)new FileInputStream(fileLocation.toFile()));
        }
        catch (JAXBException exc) {
            exc.printStackTrace();
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private static List<EndPointObject> getPolicySetAttachments(PolicySetAttachment policySetAttachment, IProject application, Map<String, IServicePolicy> policySets, Map<String, BindingObject> bindings, boolean isServerSide) {
        Vector<EndPointObject> attachments = new Vector<EndPointObject>();
        for (PolicySetReference reference : policySetAttachment.getPolicySetReference()) {
            String policySetName = reference.getName();
            IServicePolicy policySet = policySets.get(policySetName);
            if (bindings == null) continue;
            String bindingName = reference.getPolicySetBinding() == null ? Activator.getMessage("USE_CLIENT_DEFAULT_DEFAULT_BINDING") : reference.getPolicySetBinding().getName();
            BindingObject binding = bindings.get(bindingName);
            if (binding == null) {
                binding = new BindingObject(bindingName);
                bindings.put(binding.getBindingName(), binding);
            }
            for (Resource resource : reference.getResource()) {
                EndPointObject endPointReference = isServerSide ? new ServiceEndPointObject(resource.getPattern()) : new ClientEndPointObject(resource.getPattern());
                endPointReference.attachPolicySetAndBinding(application, policySet, binding);
                endPointReference.setPolicySetAttachedName(policySetName);
                attachments.add(endPointReference);
            }
        }
        return attachments;
    }

    public static Object readExistingBindingConfiguration(IPath bindingLocation, String policyType, String context) throws Exception {
        if (bindingLocation == null) {
            return null;
        }
        IPath path = bindingLocation.append("PolicyTypes").append(policyType).append("bindings.xml");
        if (path.toFile().exists()) {
            JAXBContext jc = JAXBContext.newInstance((String)context);
            Unmarshaller u = jc.createUnmarshaller();
            return u.unmarshal((InputStream)new FileInputStream(path.toFile()));
        }
        return null;
    }

    public static boolean isSupportedServiceData(ServiceData serviceData) {
        return PolicyUtils.isSupportedServiceProject(serviceData.getProject(), false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSupportedServiceProject(IProject project, boolean referencedByEAR) {
        if (ProjectDescriptionRegistry.getInstance().isSupportedServiceProject(project)) {
            return true;
        }
        if (!referencedByEAR && J2EEUtils.getReferencingEARComponents((IProject)project).length == 0) {
            return false;
        }
        boolean websphereExtendedFacet = false;
        boolean websphereCoexistenceFacet = false;
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject == null) return websphereExtendedFacet && websphereCoexistenceFacet;
            for (IProjectFacetVersion pfv : facetedProject.getProjectFacets()) {
                String id = pfv.getProjectFacet().getId();
                String version = pfv.getVersionString();
                if (id.equals(IFacetConstants.EJB_EXTENDED_FACET_ID) && version.equals("7.0")) {
                    return true;
                }
                if (id.equals(IFacetConstants.WEB_EXTENDED_FACET_ID) && version.equals("7.0")) {
                    websphereExtendedFacet = true;
                }
                if (!id.equals(IFacetConstants.WEB_COEXISTENCE_FACET_ID) || !version.equals("7.0")) continue;
                websphereCoexistenceFacet = true;
            }
            return websphereExtendedFacet && websphereCoexistenceFacet;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return websphereExtendedFacet && websphereCoexistenceFacet;
    }

    public static boolean isSupportedClientData(ClientData clientData) {
        return PolicyUtils.isSupportedClientProject(clientData.getProject());
    }

    public static boolean isSupportedClientProject(IProject project) {
        return PolicyUtils.isSupportedClientProject(project, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isSupportedClientProject(IProject project, IVirtualComponent[] referencingEARs) {
        boolean websphereCoexistenceFacet;
        boolean websphereExtendedFacet;
        block10: {
            websphereExtendedFacet = false;
            websphereCoexistenceFacet = false;
            try {
                if (ProjectDescriptionRegistry.getInstance().isSupportedClientProject(project)) {
                    return true;
                }
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject != null) {
                    boolean hasJavaFacet = false;
                    for (IProjectFacetVersion pfv : facetedProject.getProjectFacets()) {
                        String id = pfv.getProjectFacet().getId();
                        String version = pfv.getVersionString();
                        if (id.equals(IFacetConstants.EJB_EXTENDED_FACET_ID) && version.equals("7.0")) {
                            return true;
                        }
                        if (id.equals("jst.utility")) {
                            return false;
                        }
                        if ((id.equals(IFacetConstants.WEB_EXTENDED_FACET_ID) || id.equals(IFacetConstants.APPCLIENT_EXTENDED_FACET_ID) || id.equals(IFacetConstants.EAR_EXTENDED_FACET_ID)) && version.equals("7.0")) {
                            websphereExtendedFacet = true;
                        }
                        if ((id.equals(IFacetConstants.WEB_COEXISTENCE_FACET_ID) || id.equals(IFacetConstants.APPCLIENT_COEXISTENCE_FACET_ID) || id.equals(IFacetConstants.EAR_COEXISTENCE_FACET_ID)) && version.equals("7.0")) {
                            websphereCoexistenceFacet = true;
                        }
                        if (!id.equals("jst.java")) continue;
                        hasJavaFacet = true;
                    }
                    if (hasJavaFacet && CommonPolicyUtils.checkJavaProjectTargetRuntime((IProject)project, (String)"WAS_V7JAXWS_WEBSERVICES_THINCLIENT")) {
                        return true;
                    }
                    break block10;
                }
                return FacetUtils.isJavaProject((IProject)project) && CommonPolicyUtils.checkJavaProjectTargetRuntime((IProject)project, (String)"WAS_V7JAXWS_WEBSERVICES_THINCLIENT");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return websphereExtendedFacet && websphereCoexistenceFacet;
    }

    public static boolean containsPolicy(IServicePolicy policySet, String policyTypeName) {
        for (IServicePolicy policy : policySet.getChildren()) {
            if (!policy.getDescriptor().getShortName().equals(policyTypeName)) continue;
            return true;
        }
        return false;
    }
}

