/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.common;

import com.ibm.ast.ws.jaxws.emitter.collector.ClientData;
import com.ibm.ast.ws.jaxws.emitter.collector.ServiceData;
import com.ibm.ast.ws.jaxws.emitter.util.ProjectDescriptionRegistry;
import com.ibm.ast.ws.was7.policyset.ui.common.BindingObject;
import com.ibm.ast.ws.was7.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was7.policyset.ui.types.PolicyType;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EndPointObject {
    protected String displayName;
    protected IServicePolicy policySetAttached;
    protected String policySetAttachedName;
    protected BindingObject bindingAttached;
    protected String serviceName = "";
    protected String endPoint = "";
    protected String operation = "";
    protected Map<String, PolicyType> bindingConfigObjects;
    protected String nameSpace;
    protected String moduleName = null;
    protected boolean providerPolicyEnabled = false;
    protected static final String SERVICE_ENDPOINT = "WebService:/";
    protected static final String STRING_SEPERATOR = "/";
    protected static final char CHAR_SEPERATOR = '/';
    protected static final String OPEN_BRAKET = "{";
    protected static final String CLOSE_BRAKET = "}";
    protected static final String COLON = ":";

    public EndPointObject(String serviceName, String endPoint, String operation) {
        this.serviceName = serviceName.equals(Activator.getMessage("LABEL_ALL_SERVICES")) ? "" : serviceName;
        this.endPoint = endPoint;
        this.operation = operation;
        this.displayName = this.findDisplayName();
    }

    public EndPointObject(String name) {
        String string = this.displayName = name.equals(Activator.getMessage("LABEL_ALL_SERVICES")) ? "" : name;
        if (this.displayName.startsWith(SERVICE_ENDPOINT)) {
            this.displayName = this.displayName.substring(SERVICE_ENDPOINT.length());
        }
        this.findServiceEndPointOperation();
    }

    public void updateEndPointObject(String serviceName, String endPoint, String operation) {
        this.serviceName = serviceName.equals(Activator.getMessage("LABEL_ALL_SERVICES")) ? "" : serviceName;
        this.endPoint = endPoint;
        this.operation = operation;
        this.displayName = this.findDisplayName();
    }

    public String getPattern() {
        return SERVICE_ENDPOINT + this.displayName;
    }

    protected abstract void findServiceEndPointOperation();

    protected String findDisplayName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.serviceName);
        if (this.endPoint == null || this.endPoint.length() == 0) {
            return buffer.toString();
        }
        buffer.append(STRING_SEPERATOR + this.endPoint);
        if (this.operation == null || this.operation.length() == 0) {
            return buffer.toString();
        }
        buffer.append(STRING_SEPERATOR + this.operation);
        return buffer.toString();
    }

    public String getDisplayName() {
        if (this.displayName == null || this.displayName.length() == 0) {
            return Activator.getMessage("LABEL_ALL_SERVICES");
        }
        return this.displayName;
    }

    public BindingObject getAttachedBinding() {
        return this.bindingAttached;
    }

    public IServicePolicy getAttachedPolicySet() {
        return this.policySetAttached;
    }

    public abstract void attachPolicySetAndBinding(IProject var1, IServicePolicy var2, BindingObject var3);

    public String getEndPoint() {
        return this.endPoint;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getQualifiedServiceName() {
        StringBuffer buffer = new StringBuffer();
        if (this.nameSpace != null && this.nameSpace.length() > 0) {
            buffer.append(OPEN_BRAKET).append(this.nameSpace).append(CLOSE_BRAKET);
        }
        buffer.append(this.serviceName);
        return buffer.toString();
    }

    public static String getQualifiedServiceName(ServiceData service, IProject earProject) {
        IProject module = service.getProject();
        String uri = "";
        if (!ProjectDescriptionRegistry.getInstance().isUnmanagedProject(module)) {
            String moduleName = module.getName();
            EARArtifactEdit earArtifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earProject);
            uri = earArtifactEdit.getModuleURI(J2EEProjectUtilities.getModule((IVirtualComponent)earArtifactEdit.getComponent(), (String)moduleName));
        }
        return EndPointObject.getQualifiedServiceName(uri, service.getTargetNamespace(), service.getServiceName());
    }

    public static String getQualifiedServiceName(ClientData client) {
        return EndPointObject.getQualifiedServiceName(null, client.getTargetNamespace(), client.getName());
    }

    public static String getQualifiedServiceName(String moduleName, String nameSpace, String serviceName) {
        StringBuffer buffer = new StringBuffer();
        if (moduleName != null && moduleName.length() > 0) {
            buffer.append(moduleName).append(COLON);
        }
        if (nameSpace != null && nameSpace.length() > 0) {
            buffer.append(OPEN_BRAKET).append(nameSpace).append(CLOSE_BRAKET);
        }
        buffer.append(serviceName);
        return buffer.toString();
    }

    public Map<String, PolicyType> getBindingConfigObjects() {
        return this.bindingConfigObjects;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public boolean isProviderPolicyEnabled() {
        return this.providerPolicyEnabled;
    }

    public void setProviderPolicyEnabled(boolean providerPolicyEnabled) {
        this.providerPolicyEnabled = providerPolicyEnabled;
    }

    public String getPolicySetAttachedName() {
        return this.policySetAttachedName;
    }

    public void setPolicySetAttachedName(String policySetAttachedName) {
        this.policySetAttachedName = policySetAttachedName;
    }
}

