/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.common;

import com.ibm.ast.ws.jaxws.emitter.collector.ClientData;
import com.ibm.ast.ws.jaxws.emitter.collector.ServiceData;
import com.ibm.ast.ws.was7.policyset.ui.common.PolicyUtils;
import com.ibm.ccl.ws.finder.core.FinderCore;
import com.ibm.ccl.ws.finder.core.WSInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.ws.internal.common.J2EEUtils;

public class CollectorUtils {
    public static ClientData[] getClientDataFromProject(IProject clientProject) {
        Vector<ClientData> clients = new Vector<ClientData>();
        if (J2EEUtils.isEARComponent((IProject)clientProject)) {
            try {
                List<IProject> projects = Arrays.asList(clientProject.getReferencedProjects());
                List infos = FinderCore.getWebServiceRegistry().getWebServices("jaxws.client");
                for (WSInfo info : infos) {
                    IProject project = info.getProject();
                    if (!projects.contains(project) || !PolicyUtils.isSupportedClientProject(project)) continue;
                    clients.add((ClientData)info.getContent(null));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (PolicyUtils.isSupportedClientProject(clientProject)) {
            List infos = FinderCore.getWebServiceRegistry().getWebServices("jaxws.client");
            for (WSInfo info : infos) {
                if (!clientProject.equals((Object)info.getProject())) continue;
                clients.add((ClientData)info.getContent(null));
            }
        }
        return clients.toArray(new ClientData[0]);
    }

    public static ServiceData[] getServiceDataFromProject(IProject serviceProject) {
        Vector<ServiceData> services = new Vector<ServiceData>();
        if (J2EEUtils.isEARComponent((IProject)serviceProject)) {
            try {
                List<IProject> projects = Arrays.asList(serviceProject.getReferencedProjects());
                List infos = FinderCore.getWebServiceRegistry().getWebServices("jaxws.service");
                for (WSInfo info : infos) {
                    IProject project = info.getProject();
                    if (!projects.contains(project) || !PolicyUtils.isSupportedServiceProject(project, true)) continue;
                    services.add((ServiceData)info.getContent(null));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (PolicyUtils.isSupportedServiceProject(serviceProject, false)) {
            List infos = FinderCore.getWebServiceRegistry().getWebServices("jaxws.service");
            for (WSInfo info : infos) {
                if (!serviceProject.equals((Object)info.getProject())) continue;
                services.add((ServiceData)info.getContent(null));
            }
        }
        return services.toArray(new ServiceData[0]);
    }
}

