/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.common;

import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.service.policy.ui.PolicySetUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.BindingObject;
import com.ibm.ast.ws.was7.policyset.ui.common.DefaultBindingObject;
import com.ibm.ast.ws.was7.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was7.policyset.ui.types.PolicyType;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

public class ClientEndPointObject
extends EndPointObject {
    public ClientEndPointObject(String serviceName, String endPoint, String operation) {
        super(serviceName, endPoint, operation);
    }

    public ClientEndPointObject(String name) {
        super(name);
    }

    public void attachPolicySetAndBinding(IProject root, IServicePolicy policySet, BindingObject binding) {
        this.policySetAttached = policySet;
        this.bindingAttached = binding;
        this.bindingConfigObjects = new Hashtable();
        try {
            if (binding != null) {
                if (!(binding instanceof DefaultBindingObject) && binding.getNamedBinding() == null) {
                    IFolder folder = CommonPolicyUtils.createIFolder((IContainer)CommonPolicyUtils.getOutputFolder((IProject)root, (boolean)true), (String)binding.getBindingName());
                    binding.setBindingPath(folder.getLocation());
                }
                if (policySet != null) {
                    List policies = PolicySetUtils.getPolicies((IServicePolicy)policySet);
                    for (IServicePolicy policy : policies) {
                        String policyTypeName = policy.getDescriptor().getShortName();
                        PolicyType type = PolicyType.getType(policyTypeName);
                        type.setServicePolicy(policy);
                        if (binding.getNamedBinding() == null) {
                            type.readBindingConfiguration(binding.getBindingPath());
                        }
                        this.bindingConfigObjects.put(policyTypeName, type);
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void findServiceEndPointOperation() {
        int index;
        if (this.displayName == null || this.displayName.length() == 0) {
            return;
        }
        String buffer = this.displayName;
        int startNameSpace = buffer.indexOf("{");
        if (startNameSpace != 0 && (index = buffer.indexOf(":")) != -1) {
            this.moduleName = buffer.substring(0, index + 1);
            this.displayName = buffer = buffer.substring(index + 1);
            this.moduleName = null;
        }
        if (buffer.startsWith("{")) {
            index = buffer.indexOf("}");
            this.nameSpace = buffer.substring(0, index + 1);
            buffer = buffer.substring(index + 1);
        }
        if (buffer.indexOf(47) == -1) {
            this.serviceName = String.valueOf(this.nameSpace == null ? "" : this.nameSpace) + buffer;
            return;
        }
        this.serviceName = String.valueOf(this.nameSpace == null ? "" : this.nameSpace) + buffer.substring(0, buffer.indexOf(47));
        if ((buffer = buffer.substring(buffer.indexOf(47) + 1)).indexOf(47) == -1) {
            this.endPoint = buffer;
            return;
        }
        this.endPoint = buffer.substring(0, buffer.indexOf(47));
        this.operation = buffer = buffer.substring(buffer.indexOf(47) + 1);
    }
}

