/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.command;

import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.WSPolicyControlReferenceObject;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelper;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelperFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPolicyServiceControlOutputCommand
extends AbstractDataModelOperation {
    private Map<String, WSPolicyControlReferenceObject> serviceWSPolicyControlReferences = new HashMap<String, WSPolicyControlReferenceObject>();
    protected IFolder controlFileFolder;
    private boolean hasPolicysets;

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        String serviceControlFilePath = String.valueOf(this.controlFileFolder.getLocation().toOSString()) + File.separator + "wsPolicyServiceControl.xml";
        String servicePolicyAttachmentFilePath = String.valueOf(this.controlFileFolder.getLocation().toOSString()) + File.separator + "policyAttachments.xml";
        try {
            WSPolicyServiceControlHelper helper = WSPolicyServiceControlHelperFactory.createHelper((String)serviceControlFilePath, (String)servicePolicyAttachmentFilePath);
            File controlFile = new File(serviceControlFilePath);
            for (WSPolicyControlReferenceObject refObject : this.serviceWSPolicyControlReferences.values()) {
                if (controlFile.exists()) {
                    helper.removeWSPolicyServiceControlReference(refObject.getResource());
                }
                if (!this.hasPolicysets) {
                    return Status.OK_STATUS;
                }
                if (!refObject.isWSPolicyEnabled() || refObject.isIgnored()) continue;
                if (!controlFile.exists()) {
                    helper.createWSPolicyServiceControl();
                }
                helper.addWSPolicyServiceControlReference(refObject.getResource(), refObject.isExportPolicyInWSDL(), refObject.isWsMexSupported(), refObject.getWsMexPolicySetName(), refObject.getWsMexPolicySetBinding());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    public void setProject(IProject project) {
        this.controlFileFolder = CommonPolicyUtils.getOutputFolder((IProject)project, (boolean)true);
    }

    public void setHasPolicysets(boolean hasPolicysets) {
        this.hasPolicysets = hasPolicysets;
    }

    public void setServiceWSPolicyControlReferences(Map<String, WSPolicyControlReferenceObject> serviceWSPolicyControlReferences) {
        this.serviceWSPolicyControlReferences = serviceWSPolicyControlReferences;
    }
}

