/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.command;

import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.WSPolicyControlReferenceObject;
import com.ibm.ws.wspolicy.admin.client.WSPolicyClientControlHelper;
import com.ibm.ws.wspolicy.admin.client.WSPolicyClientControlHelperFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPolicyClientControlOutputCommand
extends AbstractDataModelOperation {
    protected Map<String, WSPolicyControlReferenceObject> clientWSPolicyControlReferences;
    protected IPath outputTempPath;
    protected IFolder controlFileFolder;

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        String clientControlFilePath = String.valueOf(this.controlFileFolder.getLocation().toOSString()) + File.separator + "wsPolicyClientControl.xml";
        String clientPolicyAttachmentFilePath = String.valueOf(this.controlFileFolder.getLocation().toOSString()) + File.separator + "clientPolicyAttachments.xml";
        try {
            WSPolicyClientControlHelper helper = WSPolicyClientControlHelperFactory.createHelper((String)clientControlFilePath, (String)clientPolicyAttachmentFilePath);
            File controlFile = new File(clientControlFilePath);
            if (!controlFile.exists()) {
                helper.createWSPolicyClientControl();
            }
            for (WSPolicyControlReferenceObject reference : this.clientWSPolicyControlReferences.values()) {
                if (reference.getResource() == null) continue;
                try {
                    if (helper.isProviderPolicyEnabled(reference.getResource())) {
                        helper.removeWSPolicyClientControlReference(reference.getResource());
                    }
                }
                catch (Exception exception) {}
                if (reference.isExportPolicyInWSDL()) {
                    helper.addWSPolicyClientControlReferenceHTTPGET(reference.getResource(), reference.getServiceEndpointURI(), true);
                }
                if (!reference.isWsMexSupported()) continue;
                helper.addWSPolicyClientControlReferenceWSMex11(reference.getResource(), reference.getWsMexPolicySetName(), reference.getWsMexPolicySetBinding(), true);
            }
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    public void setProject(IProject project) {
        this.controlFileFolder = CommonPolicyUtils.getOutputFolder((IProject)project, (boolean)true);
    }

    public void setClientWSPolicyControlReferences(Map<String, WSPolicyControlReferenceObject> clientWSPolicyControlReferences) {
        this.clientWSPolicyControlReferences = clientWSPolicyControlReferences;
    }
}

