/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.command;

import com.ibm.ast.ws.binding.config.ui.templates.BindinConfigurationTemplate;
import com.ibm.ast.ws.binding.config.ui.templates.SkeletonBindingConfigurationTemplate;
import com.ibm.ast.ws.policyset.ui.command.CopyGeneratedFilesCommand;
import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.command.PolicySetAttachmentOutputCommand;
import com.ibm.ast.ws.was7.policyset.ui.common.EditorUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was7.policyset.ui.types.PolicyType;
import java.io.File;
import java.util.Hashtable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ServiceSidePolicyAttachmentOutputCommand
extends PolicySetAttachmentOutputCommand {
    protected String policySetAttachmentFileName() {
        return "policyAttachments.xml";
    }

    public void setProject(IProject project) {
        this.setAttachmentFileLocation(CommonPolicyUtils.getOutputFolder((IProject)project, (boolean)true));
    }

    protected void createCustomBindings(EndPointObject endPoint) throws Exception {
        String bindingName = endPoint.getAttachedBinding().getBindingName();
        SkeletonBindingConfigurationTemplate template = new SkeletonBindingConfigurationTemplate();
        Hashtable map = new Hashtable();
        template.getTemplates(map, "provider");
        File bindingFolder = CommonPolicyUtils.createIFolder((File)this.attachmentFileLocation.getLocation().toFile(), (String)bindingName);
        PolicyType.saveBindingDefinition(bindingFolder, "custom binding", "provider", "global", "7.0.0.0");
        IFolder policyTypesFolder = CommonPolicyUtils.createIFolder((IContainer)this.attachmentFileLocation.getFolder(bindingName), (String)"PolicyTypes");
        for (BindinConfigurationTemplate skeleton : map.values()) {
            IPath sourcePath = new Path(skeleton.getBindingURL()).append("PolicyTypes");
            for (PolicyType policy : endPoint.getBindingConfigObjects().values()) {
                String policyName = policy.getName();
                IFolder policyNameFolder = CommonPolicyUtils.createIFolder((IContainer)policyTypesFolder, (String)policyName);
                IFile bindingFile = policyNameFolder.getFile("bindings.xml");
                if (!bindingFile.exists()) {
                    CopyGeneratedFilesCommand copyCommand = new CopyGeneratedFilesCommand();
                    copyCommand.setSourceFile(new File(sourcePath.append(policyName).toOSString()));
                    copyCommand.setTargetPath(policyNameFolder.getFullPath());
                    copyCommand.setEnvironment(this.getEnvironment());
                    copyCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                EditorUtils.openEditor(bindingFile);
            }
        }
    }
}

