/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.command;

import com.ibm.ast.ws.jaxws.emitter.collector.ServiceData;
import com.ibm.ast.ws.jaxws.emitter.util.ProjectDescriptionRegistry;
import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.CollectorUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was7.policyset.ui.common.WSPolicyControlReferenceObject;
import com.ibm.ast.ws.was7.policyset.ui.common.WSPolicyServiceControlReferenceObject;
import com.ibm.ast.ws.was7.policyset.ui.plugin.Activator;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelper;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelperFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadWSPolicyServiceControlCommand
extends AbstractDataModelOperation {
    private Map<String, WSPolicyControlReferenceObject> serviceWSPolicyControlReferences = new HashMap<String, WSPolicyControlReferenceObject>();
    private HashSet<String> configuredEndpointNames = new HashSet();
    private IProject project;

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ServiceData[] serviceDataArray = CollectorUtils.getServiceDataFromProject(this.project);
        int n = serviceDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceData service = serviceDataArray[n2];
            String displayName = this.formatDisplayName(service);
            WSPolicyServiceControlReferenceObject refObject = new WSPolicyServiceControlReferenceObject();
            refObject.setResource("WebService:/" + displayName);
            if (this.configuredEndpointNames.contains(displayName)) {
                refObject.setIgnored(false);
            } else {
                refObject.setIgnored(true);
            }
            this.serviceWSPolicyControlReferences.put(displayName, refObject);
            ++n2;
        }
        WSPolicyServiceControlReferenceObject earLevelRefObject = new WSPolicyServiceControlReferenceObject();
        earLevelRefObject.setResource("WebService:/");
        if (this.configuredEndpointNames.contains(Activator.getMessage("LABEL_ALL_SERVICES"))) {
            earLevelRefObject.setIgnored(false);
        } else {
            earLevelRefObject.setIgnored(true);
        }
        this.serviceWSPolicyControlReferences.put(Activator.getMessage("LABEL_ALL_SERVICES"), earLevelRefObject);
        IFolder folder = CommonPolicyUtils.getOutputFolder((IProject)this.project, (boolean)true);
        try {
            String serviceControlFile = String.valueOf(folder.getLocation().toString()) + File.separator + "wsPolicyServiceControl.xml";
            String servicePolicyAttachmentFile = String.valueOf(folder.getLocation().toString()) + File.separator + "policyAttachments.xml";
            WSPolicyServiceControlHelper helper = WSPolicyServiceControlHelperFactory.createHelper((String)serviceControlFile, (String)servicePolicyAttachmentFile);
            for (Properties p : helper.getWSPolicyServiceControlReferencesProperties()) {
                String resource;
                String displayName;
                WSPolicyControlReferenceObject refObject;
                if (!p.containsKey(PolicyConstants.RESOURCE) || (refObject = this.serviceWSPolicyControlReferences.get(displayName = this.formatDisplayName(resource = p.getProperty(PolicyConstants.RESOURCE)))) == null) continue;
                refObject.setResource(resource);
                if (!p.containsKey(PolicyConstants.SHARE_POLICY_METHODS)) continue;
                String acquisitionMethods = p.getProperty(PolicyConstants.SHARE_POLICY_METHODS);
                boolean httpGetEnabled = acquisitionMethods.indexOf(PolicyConstants.HTTP_GET) != -1;
                refObject.setExportPolicyInWSDL(httpGetEnabled);
                if (acquisitionMethods.indexOf(PolicyConstants.WSMEX) != -1) {
                    refObject.setWsMexSupported(true);
                    refObject.setWsMexPolicySetName(p.getProperty(PolicyConstants.WS_MEX_POLICY_SET_NAME));
                    refObject.setWsMexPolicySetBinding(p.getProperty(PolicyConstants.WS_MEX_POLICY_SET_BINDING));
                } else {
                    refObject.setWsMexSupported(false);
                }
                if (this.configuredEndpointNames.contains(displayName)) {
                    refObject.setIgnored(false);
                } else {
                    refObject.setIgnored(true);
                }
                this.serviceWSPolicyControlReferences.put(displayName, refObject);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {}
        return Status.OK_STATUS;
    }

    public Map<String, WSPolicyControlReferenceObject> getServiceWSPolicyControlReferences() {
        return this.serviceWSPolicyControlReferences;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private String formatDisplayName(String resource) {
        String displayName = resource.replaceFirst("WebService:/", "");
        if (displayName.endsWith("/")) {
            displayName = displayName.substring(0, displayName.length() - 1);
        }
        return displayName.equals("") ? Activator.getMessage("LABEL_ALL_SERVICES") : displayName;
    }

    private String formatDisplayName(ServiceData data) {
        if (data == null) {
            return null;
        }
        String prefix = "";
        if (!ProjectDescriptionRegistry.getInstance().isUnmanagedProject(data.getProject())) {
            String module = data.getProject().getName();
            String extension = J2EEUtils.isWebComponent((IProject)data.getProject()) ? ".war" : ".jar";
            prefix = String.valueOf(module) + extension + ":";
        }
        return String.valueOf(prefix) + "{" + data.getTargetNamespace() + "}" + data.getServiceName();
    }

    public void setReferences(List<EndPointObject> references) {
        this.configuredEndpointNames.clear();
        for (EndPointObject endpoint : references) {
            this.configuredEndpointNames.add(endpoint.getDisplayName());
        }
    }
}

