/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.command;

import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.BindingObject;
import com.ibm.ast.ws.was7.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was7.policyset.ui.plugin.Activator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseStatusHandler;
import org.eclipse.wst.common.environment.Choice;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReadPolicyAttachmentsCommand
extends AbstractDataModelOperation {
    protected List<EndPointObject> endpoints;
    protected Map<String, BindingObject> bindings;
    protected Map<String, IServicePolicy> policySets;
    protected IProject project;
    protected boolean useDefault = false;

    protected abstract String policySetAttachmentFileName();

    protected HashMap<String, EndPointObject> promptForMissingPolicySets() {
        Vector<IStatus> missingPolicySets = new Vector<IStatus>();
        HashMap<String, EndPointObject> endpointMap = new HashMap<String, EndPointObject>();
        for (EndPointObject endpoint : this.endpoints) {
            if (endpoint.getAttachedPolicySet() == null && endpoint.getPolicySetAttachedName() != null) {
                missingPolicySets.add(StatusUtils.warningStatus((String)endpoint.getPolicySetAttachedName()));
            }
            endpointMap.put(endpoint.getDisplayName(), endpoint);
        }
        Choice result = this.generateMultiChoiceMessage((IStatus[])missingPolicySets.toArray(new Status[missingPolicySets.size()]));
        this.useDefault = result == null || result.getShortcut() == 'D';
        return endpointMap;
    }

    protected Choice generateMultiChoiceMessage(IStatus[] children) {
        MultiStatus status_ = StatusUtils.multiStatus((String)Activator.getMessage("MISSING_POLICYSETS_WARNING"), (IStatus[])children);
        EclipseStatusHandler monitor = new EclipseStatusHandler();
        Choice ignoreChoice = new Choice('I', Activator.getMessage("OPTION_IGNORE_POLICYSETS"), Activator.getMessage("OPTION_IGNORE_POLICYSETS_DESC"));
        Choice ignoreAllChoice = new Choice('D', Activator.getMessage("OPTION_USE_DEFAULT_POLICYSET"), Activator.getMessage("OPTION_USE_DEFAULT_POLICYSET_DESC"));
        return monitor.report((IStatus)status_, new Choice[]{ignoreChoice, ignoreAllChoice});
    }

    public List<EndPointObject> getReferences() {
        return this.endpoints;
    }

    public void setProject(IProject clientProject) {
        this.project = clientProject;
    }

    public void setPolicySets(Map<String, IServicePolicy> policySets) {
        this.policySets = policySets;
    }

    public void setBindings(Map<String, BindingObject> bindings) {
        this.bindings = bindings;
    }
}

