/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.command;

import com.ibm.ast.ws.service.policy.ui.PolicySetUtils;
import com.ibm.ast.ws.was7.policyset.ui.command.ReadPolicyAttachmentsCommand;
import com.ibm.ast.ws.was7.policyset.ui.common.ClientEndPointObject;
import com.ibm.ast.ws.was7.policyset.ui.common.DefaultBindingObject;
import com.ibm.ast.ws.was7.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was7.policyset.ui.common.PolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.WSPolicyControlReferenceObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadClientPolicyAttachmentsCommand
extends ReadPolicyAttachmentsCommand {
    private Map<String, WSPolicyControlReferenceObject> clientWSPolicyControlReferences;

    @Override
    protected String policySetAttachmentFileName() {
        return "clientPolicyAttachments.xml";
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        this.endpoints = PolicyUtils.readClientPolicyAttachments(this.project, this.policySets, this.bindings);
        HashMap<String, EndPointObject> endpointMap = this.promptForMissingPolicySets();
        for (String displayName : this.clientWSPolicyControlReferences.keySet()) {
            EndPointObject endpoint;
            if (endpointMap.containsKey(displayName)) {
                endpoint = endpointMap.get(displayName);
                if (!this.clientWSPolicyControlReferences.get(displayName).isWSPolicyEnabled()) continue;
                endpoint.setProviderPolicyEnabled(true);
                continue;
            }
            if (!this.clientWSPolicyControlReferences.get(displayName).isWSPolicyEnabled()) continue;
            endpoint = new ClientEndPointObject(displayName);
            endpoint.setProviderPolicyEnabled(true);
            endpoint.attachPolicySetAndBinding(null, null, new DefaultBindingObject());
            this.endpoints.add(endpoint);
        }
        IServicePolicy defaultPolicySet = PolicySetUtils.getDefaultPolicySet((IProject)this.project, (String)"com.ibm.ast.ws.service.policy.ui.policyset.category70");
        for (EndPointObject endpoint : endpointMap.values()) {
            if (endpoint.getAttachedPolicySet() == null && endpoint.getPolicySetAttachedName() != null) {
                if (this.useDefault) {
                    endpoint.attachPolicySetAndBinding(this.project, defaultPolicySet, endpoint.getAttachedBinding());
                } else {
                    this.endpoints.remove(endpoint);
                }
            }
            if (endpoint.getAttachedPolicySet() != null || endpoint.getPolicySetAttachedName() != null || endpoint.isProviderPolicyEnabled()) continue;
            this.endpoints.remove(endpoint);
        }
        return Status.OK_STATUS;
    }

    public void setClientWSPolicyControlReferences(Map<String, WSPolicyControlReferenceObject> clientWSPolicyControlReferences) {
        this.clientWSPolicyControlReferences = clientWSPolicyControlReferences;
    }

    public Map<String, WSPolicyControlReferenceObject> getClientWSPolicyControlReferences() {
        return this.clientWSPolicyControlReferences;
    }
}

