/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.command;

import com.ibm.ast.ws.policyset.ui.command.CopyGeneratedFilesCommand;
import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.BindingObject;
import com.ibm.ast.ws.was7.policyset.ui.common.DefaultBindingObject;
import com.ibm.ast.ws.was7.policyset.ui.common.EndPointObject;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.NamespacePrefixMapperImpl;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.ObjectFactory;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetBinding;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PolicySetAttachmentOutputCommand
extends AbstractDataModelOperation {
    protected IFolder attachmentFileLocation;
    protected Vector<EndPointObject> references;
    protected IPath outputTempPath;

    protected abstract String policySetAttachmentFileName();

    protected abstract void createCustomBindings(EndPointObject var1) throws Exception;

    public abstract void setProject(IProject var1);

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (this.references == null) {
            return Status.OK_STATUS;
        }
        this.outputTempPath = new Path(CommonPolicyUtils.createTempDir().getAbsolutePath());
        ObjectFactory objectFactory = new ObjectFactory();
        PolicySetAttachment policySetAttachment = objectFactory.createPolicySetAttachment();
        try {
            for (EndPointObject endPoint : this.references) {
                PolicySetReference policySetReference = objectFactory.createPolicySetReference();
                if (endPoint.isProviderPolicyEnabled()) {
                    policySetReference.setProviderPolicyEnabled(Boolean.valueOf(true));
                }
                if (endPoint.getAttachedPolicySet() != null) {
                    policySetReference.setName(endPoint.getAttachedPolicySet().getDescriptor().getShortName());
                    policySetReference.setId(endPoint.getAttachedPolicySet().getId());
                }
                if (endPoint.getAttachedBinding() != null) {
                    PolicySetBinding policySetBinding = null;
                    BindingObject attachedBinding = endPoint.getAttachedBinding();
                    if (!(endPoint.getAttachedBinding() instanceof DefaultBindingObject)) {
                        policySetBinding = objectFactory.createPolicySetBinding();
                        policySetBinding.setName(attachedBinding.getBindingName());
                        String scope = null;
                        if (attachedBinding.getNamedBinding() != null) {
                            scope = "domain";
                        }
                        policySetBinding.setScope(scope);
                    }
                    policySetReference.setPolicySetBinding(policySetBinding);
                    if (attachedBinding.getNamedBinding() == null && !(attachedBinding instanceof DefaultBindingObject)) {
                        this.createCustomBindings(endPoint);
                    }
                }
                Resource resource = objectFactory.createResource();
                resource.setPattern(endPoint.getPattern());
                policySetReference.getResource().add(resource);
                policySetAttachment.getPolicySetReference().add(policySetReference);
            }
            this.writePolicySetAttachment(policySetAttachment);
            IPath fileLocation = this.attachmentFileLocation.getFullPath();
            CopyGeneratedFilesCommand copyCommand = new CopyGeneratedFilesCommand();
            copyCommand.setSourceFile(this.outputTempPath.toFile());
            copyCommand.setTargetPath(fileLocation);
            copyCommand.setEnvironment(this.getEnvironment());
            copyCommand.execute(monitor, adaptable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    private void writePolicySetAttachment(PolicySetAttachment attachment) throws Exception {
        File outputDir = new File(this.outputTempPath.append(this.policySetAttachmentFileName()).toString());
        JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200605.policysetattachment");
        Marshaller m = jc.createMarshaller();
        m.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
        m.setProperty("jaxb.formatted.output", (Object)true);
        FileOutputStream os = new FileOutputStream(outputDir);
        m.marshal((Object)attachment, (OutputStream)os);
        ((OutputStream)os).close();
    }

    public void setReferences(Vector<EndPointObject> references) {
        this.references = references;
    }

    public void setAttachmentFileLocation(IFolder attachmentFileLocation) {
        this.attachmentFileLocation = attachmentFileLocation;
    }
}

