/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.command;

import com.ibm.ast.ws.policyset.ui.command.CopyGeneratedFilesCommand;
import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.service.policy.ui.NamedBindingstUtils;
import com.ibm.ast.ws.service.policy.ui.PolicySetUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was7.policyset.ui.common.PolicyUtils;
import java.io.File;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyServicePolicySetToProjectCommand
extends AbstractDataModelOperation {
    private IProject project;
    private Vector<EndPointObject> references;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        try {
            this.copyPolicySetsToProject(monitor, adaptable);
            this.copyNamedBindingToProject(monitor, adaptable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    public IStatus copyPolicySetsToProject(IProgressMonitor monitor, IAdaptable adaptable) throws CoreException {
        IFolder parentFolder = CommonPolicyUtils.createIFolder((IContainer)CommonPolicyUtils.getOutputFolder((IProject)this.project, (boolean)true), (String)"PolicySets");
        for (EndPointObject endPoint : this.references) {
            if (endPoint.getAttachedPolicySet().isPredefined()) continue;
            String sourcePath = PolicySetUtils.getPolicyPath((IServicePolicy)endPoint.getAttachedPolicySet());
            Path oldPath = new Path(PolicyUtils.expandURL(sourcePath));
            oldPath = oldPath.removeLastSegments(1);
            IPath newPath = CommonPolicyUtils.createIFolder((IContainer)parentFolder, (String)oldPath.lastSegment()).getFullPath();
            CopyGeneratedFilesCommand command = new CopyGeneratedFilesCommand();
            command.setEnvironment(this.getEnvironment());
            command.setSourceFile(new File(oldPath.toString()));
            command.setTargetPath(newPath);
            IStatus status = command.execute(monitor, adaptable);
            if (status.getSeverity() != 4) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus copyNamedBindingToProject(IProgressMonitor monitor, IAdaptable adaptable) throws CoreException {
        IFolder parentFolder = CommonPolicyUtils.getOutputFolder((IProject)this.project, (boolean)true);
        for (EndPointObject endPoint : this.references) {
            IServicePolicy binding = endPoint.getAttachedBinding().getNamedBinding();
            if (binding == null || binding.isPredefined()) continue;
            String sourcePath = NamedBindingstUtils.getPolicyPath((IServicePolicy)binding);
            Path oldPath = new Path(PolicyUtils.expandURL(sourcePath));
            oldPath = oldPath.removeLastSegments(1);
            IPath newPath = CommonPolicyUtils.createIFolder((IContainer)parentFolder, (String)oldPath.lastSegment()).getFullPath();
            CopyGeneratedFilesCommand command = new CopyGeneratedFilesCommand();
            command.setEnvironment(this.getEnvironment());
            command.setSourceFile(new File(oldPath.toString()));
            command.setTargetPath(newPath);
            IStatus status = command.execute(monitor, adaptable);
            if (status.getSeverity() != 4) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setReferences(Vector<EndPointObject> references) {
        this.references = references;
    }
}

