/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.widgets;

import com.ibm.ast.ws.jaxws.emitter.collector.ClientData;
import com.ibm.ast.ws.policyset.ui.collector.CollectorUtils;
import com.ibm.ast.ws.was61.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was61.policyset.ui.common.PolicyUtils;
import com.ibm.ast.ws.was61.policyset.ui.common.ProjectContainerPropertyTester;
import com.ibm.ast.ws.was61.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was61.policyset.ui.tables.BindingConfigurationTable;
import com.ibm.ast.ws.was61.policyset.ui.tables.EndPointConfigurationTable;
import com.ibm.ast.ws.was61.policyset.ui.types.PolicyType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSidePolicyAttachmentWidget
extends SimpleWidgetDataContributor {
    private String INFOPOP_CSATT_PAGE = "CSATT0004";
    private Listener statusListener_;
    private String INFOPOP_CSATT_ENDPOINT_GROUPE = "CSATT0002";
    private EndPointConfigurationTable table;
    private String INFOPOP_CSATT_BINDING_GROUPE = "CSATT0003";
    private BindingConfigurationTable tableBindingConfig;
    private ClientData clientData;
    private Combo serviceClient;
    private HashMap<String, ClientData> clientMap;
    private IProject clientProject;
    private Map<String, IServicePolicy> policySets;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener_ = statusListener;
        UIUtils uiUtils = Activator.getUiUtils();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.INFOPOP_CSATT_PAGE);
        this.clientMap = new HashMap();
        Composite serviceClientComp = uiUtils.createComposite(parent, 2);
        this.serviceClient = uiUtils.createCombo(serviceClientComp, Activator.getMessage("LABEL_WEB_SERVICE_CLIENT"), Activator.getMessage("TOOLTIP_CSATT_PROJECT_COMBO"), null, 2060);
        this.serviceClient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ClientSidePolicyAttachmentWidget.this.clientData == null || !ClientSidePolicyAttachmentWidget.this.formatDispalyName(ClientSidePolicyAttachmentWidget.this.clientData).equals(ClientSidePolicyAttachmentWidget.this.serviceClient.getText())) {
                    ClientSidePolicyAttachmentWidget.this.clientData = (ClientData)ClientSidePolicyAttachmentWidget.this.clientMap.get(ClientSidePolicyAttachmentWidget.this.serviceClient.getText());
                    ClientSidePolicyAttachmentWidget.this.refreshPage(ClientSidePolicyAttachmentWidget.this.clientData);
                    ClientSidePolicyAttachmentWidget.this.statusListener_.handleEvent(null);
                }
            }
        });
        Group endPointGroup = uiUtils.createGroup(parent, Activator.getMessage("LABEL_APPLICATION"), Activator.getMessage("TOOLTIP_CSATT_ENDPOINT_GROUPE"), this.INFOPOP_CSATT_ENDPOINT_GROUPE, 2, -1, -1);
        GridData griddata = new GridData(1808);
        endPointGroup.setLayoutData((Object)griddata);
        this.table = new EndPointConfigurationTable((Composite)endPointGroup, this.statusListener_, new String[]{Activator.getMessage("LABEL_COL_ENDPOINT"), Activator.getMessage("LABEL_COL_POLICYSET_ATTACHED"), Activator.getMessage("LABEL_COL_BINDING_ATTACHED")});
        Group bindingConfigGroup = uiUtils.createGroup(parent, Activator.getMessage("LABEL_BINDING_CONFIGURATION"), Activator.getMessage("TOOLTIP_CSATT_BINDING_GROUPE"), this.INFOPOP_CSATT_BINDING_GROUPE, 2, -1, -1);
        bindingConfigGroup.setLayoutData((Object)griddata);
        this.tableBindingConfig = new BindingConfigurationTable((Composite)bindingConfigGroup, this.statusListener_, new String[]{Activator.getMessage("LABEL_COL_POLICY_TYPE"), Activator.getMessage("LABEL_COL_BINDING")});
        this.table.setPolicySets(this.policySets);
        return this;
    }

    private String formatDispalyName(ClientData data) {
        return String.valueOf(data.getProject().getName()) + ":{" + data.getTargetNamespace() + "}" + data.getName();
    }

    public IStatus getStatus() {
        if (this.serviceClient.getItemCount() == 0) {
            return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_NO_CLIENT_PROJECTS"));
        }
        if (J2EEUtils.isWebComponent((IProject)this.clientData.getProject()) && J2EEUtils.getReferencingEARComponents((IProject)this.clientData.getProject()).length == 0) {
            return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_WEB_CLIENT_WITH_NO_CONTAINER"));
        }
        this.tableBindingConfig.setReferences(this.table.getSelectedEndPointObject());
        IStatus status = this.checkDuplicateBindingSelection(this.table.getReferences());
        if (status.getSeverity() == 4) {
            return status;
        }
        return this.checkCompleteBindingConfig(this.table.getReferences());
    }

    private IStatus checkCompleteBindingConfig(List<EndPointObject> ref) {
        for (EndPointObject object : ref) {
            for (PolicyType type : object.getBindingConfigObjects().values()) {
                if (!type.validateConfiguration().equals(Activator.getMessage("NOT_CONFIGURED"))) continue;
                return StatusUtils.warningStatus((String)Activator.getMessage("ERROR_NO_COMPLETE_BINDING_CONFIG", new String[]{type.getName()}));
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus checkDuplicateBindingSelection(List<EndPointObject> ref) {
        int i = 0;
        while (i < ref.size()) {
            EndPointObject object1 = ref.get(i);
            int j = i;
            while (j < ref.size()) {
                EndPointObject object2 = ref.get(j);
                if (object1.getAttachedBinding() != null && object1.getAttachedBinding().equals(object2.getAttachedBinding()) && !object1.getAttachedPolicySet().getDescriptor().getShortName().equals(object2.getAttachedPolicySet().getDescriptor().getShortName())) {
                    return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_CONFLICTING_BINDINGS"));
                }
                ++j;
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public List<EndPointObject> getReferences() {
        return this.table.getReferences();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setClientData(ClientData data) {
        if (data == null) {
            this.serviceClient.removeAll();
            ClientData[] clientDataArray = CollectorUtils.collectAllClientData();
            int n = clientDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClientData allData = clientDataArray[n2];
                if (ProjectContainerPropertyTester.isSupportedClientData(allData)) {
                    String displayName = this.formatDispalyName(allData);
                    this.clientMap.put(displayName, allData);
                    this.serviceClient.add(displayName);
                }
                ++n2;
            }
            if (this.serviceClient.getItemCount() <= 0) return;
            this.serviceClient.select(0);
            this.clientData = this.clientMap.get(this.serviceClient.getText());
        } else {
            this.clientData = data;
            this.serviceClient.setItems(new String[]{this.formatDispalyName(this.clientData)});
            this.serviceClient.select(0);
        }
        this.refreshPage(this.clientData);
    }

    private void refreshPage(ClientData clientData) {
        this.clientProject = clientData.getProject();
        this.table.setPolicySets(this.policySets);
        this.table.setReferences(PolicyUtils.readClientPolicyAttachments(this.clientProject, this.policySets));
        this.table.setClientData(new ClientData[]{clientData});
        this.table.setApplication(this.clientProject);
    }

    public IProject getProject() {
        return this.clientProject;
    }

    public void setPolicySets(Map<String, IServicePolicy> policySets) {
        this.policySets = policySets;
        if (this.table != null) {
            this.table.setPolicySets(policySets);
        }
        if (this.serviceClient.getItemCount() > 0) {
            this.table.setReferences(PolicyUtils.readClientPolicyAttachments(this.clientProject, policySets));
        }
    }
}

