/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.types;

import com.ibm.ast.ws.policyset.ui.common.BasicAuthentication;
import com.ibm.ast.ws.policyset.ui.common.DefaultSymmetricDerivedKeyObject;
import com.ibm.ast.ws.policyset.ui.common.DerivedKeyInfoObject;
import com.ibm.ast.ws.policyset.ui.common.EncryptionOutBoundSecurityBindingObject;
import com.ibm.ast.ws.policyset.ui.common.KeyStore;
import com.ibm.ast.ws.policyset.ui.common.KeyStoreWithKey;
import com.ibm.ast.ws.policyset.ui.common.PropertyObject;
import com.ibm.ast.ws.policyset.ui.common.SecurityBindingObject;
import com.ibm.ast.ws.policyset.ui.common.SignatureSecurityBindingObject;
import com.ibm.ast.ws.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.policyset.ui.tokens.AuthenticationToken;
import com.ibm.ast.ws.policyset.ui.tokens.CustomeAuthenticationToken;
import com.ibm.ast.ws.policyset.ui.tokens.KerberosProtectionToken;
import com.ibm.ast.ws.policyset.ui.tokens.LTPAAuthenticationToken;
import com.ibm.ast.ws.policyset.ui.tokens.LTPAPropAuthenticationToken;
import com.ibm.ast.ws.policyset.ui.tokens.ProtectionToken;
import com.ibm.ast.ws.policyset.ui.tokens.SecureConversationToken;
import com.ibm.ast.ws.policyset.ui.tokens.UserNameAuthenticationToken;
import com.ibm.ast.ws.policyset.ui.tokens.X509ProtectionToken;
import com.ibm.ast.ws.service.policy.ui.PolicySetUtils;
import com.ibm.ast.ws.was61.policyset.ui.common.PolicyUtils;
import com.ibm.ast.ws.was61.policyset.ui.dialogs.WSSecurityBindingConfigurationDialog;
import com.ibm.ast.ws.was61.policyset.ui.types.PolicyConfigUtil;
import com.ibm.ast.ws.was61.policyset.ui.types.PolicyType;
import com.ibm.ast.ws.was61.policyset.ui.types.WSFactoryUtils;
import com.ibm.ast.ws.was61.policyset.ui.validator.BindingXMLBadAttribute;
import com.ibm.ast.ws.was61.policyset.ui.validator.BindingXMLBadElement;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.BasicAuth;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CallbackHandler;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertPathSettings;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertStoreList;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertStoreRef;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CollectionCertStores;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.DataEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.EncryptionInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.EncryptionPartReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Key;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.ObjectFactory;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Properties;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBinding;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityInboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityOutboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityTokenReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningPartReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TimestampExpires;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenConsumer;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenGenerator;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Transform;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TrustAnchor;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TrustAnchorRef;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TrustAnyCertificate;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.X509Certificates;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecurityPolicy
extends PolicyType {
    public static String WSSecuritySchemaId = "com.ibm.ast.ws.was61.policyset.ui.schema.WSSecurity";
    public static String PolicyTypeName = "WSSecurity";
    public static String PolicyContextPath = "org.oasis_open.docs.ws_sx.ws_securitypolicy._200512:org.xmlsoap.schemas.ws._2004._09.policy:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext";
    public static String BindingContextPath = "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding";
    public static String ApplicationBindingName = "application";
    public static String BootstrapBindingName = "bootstrap";
    private String outTokenSpecificationName = "WssX509V3Token10";
    private String inTokenSpecificationName = "WssX509V3Token10";
    private boolean asymmetricBindingToken = false;
    private SignatureSecurityBindingObject generatorSymmetric = null;
    private SignatureSecurityBindingObject consumerSymmetric = null;
    private boolean isInboundSignatureFound = false;
    private boolean isOutboundSignatureFound = false;
    private boolean isInboundEncryptionFound = false;
    private boolean isOutboundEncryptionFound = false;
    private SignatureSecurityBindingObject SignOutbound;
    private SignatureSecurityBindingObject SignInbound;
    private String certificatePath;
    private String messageExpiryTime;
    private EncryptionOutBoundSecurityBindingObject EncOutbound;
    private SecurityBindingObject EncInbound;
    private AuthenticationToken token;
    private String authenticationTokenLocalname;
    private String authenticationTokenName = "WssUsernameToken10";
    private boolean isOldSchema;
    protected static JAXBContext jc;
    protected static JAXBContext bindingJAXB;
    protected static Unmarshaller u;
    protected static Unmarshaller bindingUnmarshaller;
    protected static Marshaller m;
    protected ObjectFactory bindingFactory;
    protected String CONTEXT_PATH = "org.oasis_open.docs.ws_sx.ws_securitypolicy._200512:org.xmlsoap.schemas.ws._2004._09.policy:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext";
    protected IFile file;
    protected String schemaID;

    @Override
    protected Marshaller getMarshaller() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)this.CONTEXT_PATH);
        }
        if (m == null) {
            m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
        }
        return m;
    }

    @Override
    protected Unmarshaller getUnmarshaller() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)this.CONTEXT_PATH);
        }
        if (u == null) {
            u = jc.createUnmarshaller();
        }
        return u;
    }

    protected Unmarshaller getBindingUnmarshaller() throws JAXBException {
        if (bindingJAXB == null) {
            bindingJAXB = JAXBContext.newInstance((String)BindingContextPath);
        }
        if (bindingUnmarshaller == null) {
            bindingUnmarshaller = bindingJAXB.createUnmarshaller();
        }
        return bindingUnmarshaller;
    }

    @Override
    public ArrayList<BindingXMLBadElement> validateBindingXML(IFile file, String schemaID) {
        this.file = file;
        this.schemaID = schemaID;
        ArrayList<BindingXMLBadElement> badElements = new ArrayList<BindingXMLBadElement>();
        try {
            Object binding = this.getBindingUnmarshaller().unmarshal((InputStream)new FileInputStream(file.getLocation().toFile()));
            this.isOldSchema = false;
            for (SecurityBinding securityBinding : ((SecurityBindings)binding).getSecurityBinding()) {
                CallbackHandler handler;
                BindingXMLBadElement badElement;
                String tokenRef;
                String ref;
                SecurityOutboundBindingConfig outBoundConfig = securityBinding.getSecurityOutboundBindingConfig();
                SecurityInboundBindingConfig inBoundConfig = securityBinding.getSecurityInboundBindingConfig();
                TimestampExpires expTime = outBoundConfig.getTimestampExpires();
                if (expTime != null) {
                    try {
                        Integer time = new Integer(expTime.getExpires());
                        if (time == 0) {
                            BindingXMLBadElement badElement2 = new BindingXMLBadElement("timestampExpires");
                            BindingXMLBadAttribute badAttr = new BindingXMLBadAttribute("expires", expTime.getExpires());
                            badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.was61.policyset.ui.plugin", 1, "ERROR_INVALID_MESSAGE_EXP", new String[]{schemaID}, (Object)file));
                            badElement2.setAttribute(badAttr);
                            badElements.add(badElement2);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        BindingXMLBadElement badElement3 = new BindingXMLBadElement("timestampExpires");
                        BindingXMLBadAttribute badAttr = new BindingXMLBadAttribute("expires", expTime.getExpires());
                        badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.was61.policyset.ui.plugin", 1, "ERROR_INVALID_MESSAGE_EXP", new String[]{schemaID}, (Object)file));
                        badElement3.setAttribute(badAttr);
                        badElements.add(badElement3);
                    }
                }
                for (SigningInfo signingInfo : outBoundConfig.getSigningInfo()) {
                    for (SigningKeyInfo signingKeyInfo : signingInfo.getSigningKeyInfo()) {
                        ref = signingKeyInfo.getReference();
                        for (KeyInfo keyInfo : outBoundConfig.getKeyInfo()) {
                            if (!keyInfo.getName().equals(ref)) continue;
                            tokenRef = keyInfo.getTokenReference().getReference();
                            for (TokenGenerator tokenGenerator : outBoundConfig.getTokenGenerator()) {
                                if (!tokenGenerator.getName().equals(tokenRef)) continue;
                                badElement = new BindingXMLBadElement("tokenGenerator");
                                handler = tokenGenerator.getCallbackHandler();
                                this.checkHandlerKeyStore(badElement, "name", tokenGenerator.getName(), handler, "ERROR_MISSING_OUTBOUND_KEYSTORE", com.ibm.ast.ws.was61.policyset.ui.plugin.Activator.getMessage("DIGITAL_SIGNATURE"));
                                if (badElement.getAttributes().size() <= 0) continue;
                                badElements.add(badElement);
                            }
                        }
                    }
                }
                for (SigningInfo signingInfo : inBoundConfig.getSigningInfo()) {
                    for (SigningKeyInfo signingKeyInfo : signingInfo.getSigningKeyInfo()) {
                        ref = signingKeyInfo.getReference();
                        for (KeyInfo keyInfo : inBoundConfig.getKeyInfo()) {
                            if (!keyInfo.getName().equals(ref)) continue;
                            tokenRef = keyInfo.getTokenReference().getReference();
                            for (TokenConsumer tokenConsumer : inBoundConfig.getTokenConsumer()) {
                                TrustAnchorRef trustAnchorRef;
                                if (!tokenConsumer.getName().equals(tokenRef)) continue;
                                badElement = new BindingXMLBadElement("tokenConsumer");
                                handler = tokenConsumer.getCallbackHandler();
                                if (handler.getCertPathSettings() == null || (trustAnchorRef = handler.getCertPathSettings().getTrustAnchorRef()) == null) continue;
                                String trustRef = trustAnchorRef.getReference();
                                for (TrustAnchor trustAnchor : inBoundConfig.getTrustAnchor()) {
                                    if (!trustAnchor.getName().equals(trustRef)) continue;
                                    this.checkTrustAnchorKeyStore(badElement, "name", tokenConsumer.getName(), trustAnchor, "ERROR_MISSING_INBOUND_KEYSTORE", com.ibm.ast.ws.was61.policyset.ui.plugin.Activator.getMessage("DIGITAL_SIGNATURE"));
                                    if (badElement.getAttributes().size() <= 0) continue;
                                    badElements.add(badElement);
                                }
                            }
                        }
                    }
                }
                for (EncryptionInfo encInfo : outBoundConfig.getEncryptionInfo()) {
                    for (KeyEncryptionKeyInfo encKeyInfo : encInfo.getKeyEncryptionKeyInfo()) {
                        ref = encKeyInfo.getReference();
                        for (KeyInfo keyInfo : outBoundConfig.getKeyInfo()) {
                            if (!keyInfo.getName().equals(ref)) continue;
                            tokenRef = keyInfo.getTokenReference().getReference();
                            for (TokenGenerator tokenGenerator : outBoundConfig.getTokenGenerator()) {
                                if (!tokenGenerator.getName().equals(tokenRef)) continue;
                                badElement = new BindingXMLBadElement("tokenGenerator");
                                handler = tokenGenerator.getCallbackHandler();
                                this.checkHandlerKeyStore(badElement, "name", tokenGenerator.getName(), handler, "ERROR_MISSING_OUTBOUND_KEYSTORE", com.ibm.ast.ws.was61.policyset.ui.plugin.Activator.getMessage("XML_ENCRYPTION"));
                                if (badElement.getAttributes().size() <= 0) continue;
                                badElements.add(badElement);
                            }
                        }
                    }
                }
                for (EncryptionInfo encInfo : inBoundConfig.getEncryptionInfo()) {
                    for (KeyEncryptionKeyInfo encKeyInfo : encInfo.getKeyEncryptionKeyInfo()) {
                        ref = encKeyInfo.getReference();
                        for (KeyInfo keyInfo : inBoundConfig.getKeyInfo()) {
                            if (!keyInfo.getName().equals(ref)) continue;
                            tokenRef = keyInfo.getTokenReference().getReference();
                            for (TokenConsumer tokenConsumer : inBoundConfig.getTokenConsumer()) {
                                if (!tokenConsumer.getName().equals(tokenRef)) continue;
                                badElement = new BindingXMLBadElement("tokenConsumer");
                                handler = tokenConsumer.getCallbackHandler();
                                this.checkHandlerKeyStore(badElement, "name", tokenConsumer.getName(), handler, "ERROR_MISSING_INBOUND_KEYSTORE", com.ibm.ast.ws.was61.policyset.ui.plugin.Activator.getMessage("XML_ENCRYPTION"));
                                if (badElement.getAttributes().size() <= 0) continue;
                                badElements.add(badElement);
                            }
                        }
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnmarshalException unmarshalException) {
            this.isOldSchema = true;
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return badElements;
    }

    private void checkTrustAnchorKeyStore(BindingXMLBadElement badElement, String name, String value, TrustAnchor trust, String message, String prefix) {
        com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyStore keyStore;
        if (trust.getKeyStore() != null && ((keyStore = trust.getKeyStore()).getType().length() == 0 || PasswordUtil.passwordDecode((String)keyStore.getStorepass()).length() == 0 || keyStore.getPath().length() == 0)) {
            BindingXMLBadAttribute badAttr = new BindingXMLBadAttribute(name, value);
            badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.was61.policyset.ui.plugin", 1, message, new String[]{prefix}, (Object)this.file));
            badElement.setAttribute(badAttr);
        }
    }

    private void checkHandlerKeyStore(BindingXMLBadElement badElement, String name, String value, CallbackHandler handler, String message, String prefix) {
        if (handler.getKeyStore() != null) {
            Key key;
            com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyStore keyStore = handler.getKeyStore();
            if (keyStore.getType().length() == 0 || PasswordUtil.passwordDecode((String)keyStore.getStorepass()).length() == 0 || keyStore.getPath().length() == 0) {
                BindingXMLBadAttribute badAttr = new BindingXMLBadAttribute(name, value);
                badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.was61.policyset.ui.plugin", 1, message, new String[]{prefix}, (Object)this.file));
                badElement.setAttribute(badAttr);
            } else if (handler.getKey() != null && ((key = handler.getKey()).getName() == null || key.getName().length() == 0 || key.getAlias().length() == 0)) {
                BindingXMLBadAttribute badAttr = new BindingXMLBadAttribute(name, value);
                badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.was61.policyset.ui.plugin", 1, message, new String[]{prefix}, (Object)this.file));
                badElement.setAttribute(badAttr);
            }
        }
    }

    @Override
    public IStatus saveBindingConfiguration(File location) {
        String pathname = PolicySetUtils.getPolicyPath((IServicePolicy)this.getServicePolicy());
        Policy policy = null;
        try {
            policy = (Policy)this.getUnmarshaller().unmarshal(new File(PolicyUtils.expandURL(pathname)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bindingFactory = new ObjectFactory();
        SecurityBindings bindings = this.wsSecurityBindings(policy);
        try {
            this.writeWSSecurityBindings(bindings, location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    @Override
    public void readBindingConfiguration(IPath location) {
        String assertion;
        X509ProtectionToken inProtectionToken;
        X509ProtectionToken outProtectionToken;
        String pathname = PolicySetUtils.getPolicyPath((IServicePolicy)this.getServicePolicy());
        Policy policy = null;
        try {
            String policyPath = PolicyUtils.expandURL(pathname);
            policy = (Policy)this.getUnmarshaller().unmarshal(new File(policyPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getTokenSpecificationNames(policy);
        if (this.isSignatureFound(policy) && this.asymmetricBindingToken) {
            outProtectionToken = new X509ProtectionToken(this.outTokenSpecificationName, true);
            inProtectionToken = new X509ProtectionToken(this.inTokenSpecificationName, false);
            if (this.isInboundSignatureFound) {
                this.SignInbound = new SignatureSecurityBindingObject();
                this.SignInbound.setToken((ProtectionToken)inProtectionToken);
                this.SignInbound.setKeyStore(null);
                this.SignInbound.setDerivedKey(new DerivedKeyInfoObject());
            }
            if (this.isOutboundSignatureFound) {
                this.SignOutbound = new SignatureSecurityBindingObject();
                this.SignOutbound.setToken((ProtectionToken)outProtectionToken);
                this.SignOutbound.setKeyStore((KeyStore)new KeyStoreWithKey());
                this.SignOutbound.setDerivedKey(new DerivedKeyInfoObject());
            }
        }
        if (this.isEncryptionFound(policy) && this.asymmetricBindingToken) {
            outProtectionToken = new X509ProtectionToken(this.outTokenSpecificationName, true);
            inProtectionToken = new X509ProtectionToken(this.inTokenSpecificationName, false);
            if (this.isOutboundEncryptionFound) {
                this.EncOutbound = new EncryptionOutBoundSecurityBindingObject();
                this.EncOutbound.setToken((ProtectionToken)outProtectionToken);
                KeyStoreWithKey outKeyStoreWithKey = new KeyStoreWithKey();
                outKeyStoreWithKey.setKeyPassword(null);
                this.EncOutbound.setKeyStore((KeyStore)outKeyStoreWithKey);
                this.EncOutbound.setDerivedKey(new DerivedKeyInfoObject());
            }
            if (this.isInboundEncryptionFound) {
                this.EncInbound = new SecurityBindingObject();
                this.EncInbound.setToken((ProtectionToken)inProtectionToken);
                this.EncInbound.setKeyStore((KeyStore)new KeyStoreWithKey());
                this.EncInbound.setDerivedKey(new DerivedKeyInfoObject());
            }
        }
        if (this.generatorSymmetric != null) {
            this.generatorSymmetric.setDerivedKey((DerivedKeyInfoObject)new DefaultSymmetricDerivedKeyObject());
        }
        if (this.consumerSymmetric != null) {
            this.consumerSymmetric.setDerivedKey((DerivedKeyInfoObject)new DefaultSymmetricDerivedKeyObject());
        }
        if ((assertion = WSSecurityPolicy.isAuthenticationFound(policy)) != null) {
            if (assertion.equalsIgnoreCase("UsernameToken")) {
                this.token = new UserNameAuthenticationToken(this.authenticationTokenName, true);
            } else if (assertion.equalsIgnoreCase("LTPAToken")) {
                this.token = new LTPAAuthenticationToken("LTPAToken", true);
            } else if (assertion.equalsIgnoreCase("LTPAPropagationToken")) {
                this.token = new LTPAPropAuthenticationToken("LTPAPropagationToken", true);
            } else if (assertion.equalsIgnoreCase("CustomToken")) {
                this.token = new CustomeAuthenticationToken("CustomToken");
            }
            if (this.token == null) {
                MessageDialog.openWarning(null, (String)Activator.getMessage((String)"MESSAGE_TITLE_TOKEN_NOT_SUPPORTED"), (String)Activator.getMessage((String)"WARNING_NOT_SUPPORTED_TOKEN", (Object[])new String[]{assertion}));
            } else {
                this.token.setBasicAuth(new BasicAuthentication("", ""));
            }
        }
        if (location == null) {
            return;
        }
        try {
            Object securityBindings = PolicyUtils.readExistingBindingConfiguration(location, this.getName(), BindingContextPath);
            if (securityBindings == null) {
                return;
            }
            this.isOldSchema = false;
            List bindings = ((SecurityBindings)securityBindings).getSecurityBinding();
            for (SecurityBinding securityBinding : bindings) {
                SecurityOutboundBindingConfig securityOutboundBindingConfig = securityBinding.getSecurityOutboundBindingConfig();
                boolean isApplicationSection = securityBinding.getName().equals(ApplicationBindingName);
                boolean isSymmetricApplicationSection = isApplicationSection && this.generatorSymmetric != null;
                List signingInfos = securityOutboundBindingConfig.getSigningInfo();
                List encryptionInfos = securityOutboundBindingConfig.getEncryptionInfo();
                List keyInfos = securityOutboundBindingConfig.getKeyInfo();
                List tokenGenerators = securityOutboundBindingConfig.getTokenGenerator();
                TimestampExpires expiry = securityOutboundBindingConfig.getTimestampExpires();
                if (expiry != null) {
                    this.messageExpiryTime = expiry.getExpires();
                }
                for (TokenGenerator tokenGenerator : tokenGenerators) {
                    CallbackHandler callbackHandler = tokenGenerator.getCallbackHandler();
                    if (callbackHandler == null) continue;
                    int k = 0;
                    while (k < keyInfos.size()) {
                        KeyInfo keyInfo = (KeyInfo)keyInfos.get(k);
                        if (tokenGenerator.getName().equalsIgnoreCase(keyInfo.getTokenReference().getReference())) {
                            Object secObject;
                            int l = 0;
                            while (l < signingInfos.size()) {
                                SigningInfo signingInfo = (SigningInfo)signingInfos.get(l);
                                for (SigningKeyInfo SigningKeyInfo2 : signingInfo.getSigningKeyInfo()) {
                                    Object object = secObject = isSymmetricApplicationSection ? this.generatorSymmetric : this.SignOutbound;
                                    if (!keyInfo.getName().equalsIgnoreCase(SigningKeyInfo2.getReference())) continue;
                                    secObject.setKeyStore(WSFactoryUtils.readKeyStore(callbackHandler));
                                    secObject.setTransformAlgorithm(((Transform)((SigningPartReference)signingInfo.getSigningPartReference().get(0)).getTransform().get(0)).getAlgorithm());
                                    secObject.setOrder(signingInfo.getOrder());
                                    secObject.getToken().setKeyInfoType(keyInfo.getType());
                                    secObject.getToken().setCallBackHandler(callbackHandler.getClassname());
                                    secObject.getToken().setJAASConfig(tokenGenerator.getJAASConfig().getConfigName());
                                    for (Properties property : callbackHandler.getProperties()) {
                                        secObject.addProperty(new PropertyObject(property.getName(), property.getValue()));
                                    }
                                }
                                ++l;
                            }
                            int m = 0;
                            while (m < encryptionInfos.size()) {
                                Object secObject2 = isSymmetricApplicationSection ? this.generatorSymmetric : this.EncOutbound;
                                EncryptionInfo encryptionInfo = (EncryptionInfo)encryptionInfos.get(m);
                                for (Properties property : encryptionInfo.getProperties()) {
                                    secObject2.addProperty(new PropertyObject(property.getName(), property.getValue()));
                                }
                                secObject = encryptionInfo.getKeyEncryptionKeyInfo().iterator();
                                while (secObject.hasNext()) {
                                    KeyEncryptionKeyInfo encryptionKeyInfo = (KeyEncryptionKeyInfo)secObject.next();
                                    if (keyInfo.getName().equalsIgnoreCase(encryptionKeyInfo.getReference())) {
                                        callbackHandler.getKey().setKeypass(null);
                                        secObject2.setKeyStore(WSFactoryUtils.readKeyStore(callbackHandler));
                                        secObject2.getToken().setKeyInfoType(keyInfo.getType());
                                        secObject2.getToken().setCallBackHandler(callbackHandler.getClassname());
                                        secObject2.getToken().setJAASConfig(tokenGenerator.getJAASConfig().getConfigName());
                                        for (Properties property : callbackHandler.getProperties()) {
                                            secObject2.addProperty(new PropertyObject(property.getName(), property.getValue()));
                                        }
                                    }
                                    secObject2.setOrder(encryptionInfo.getOrder());
                                }
                                ++m;
                            }
                        }
                        ++k;
                    }
                    BasicAuth basicAuth = callbackHandler.getBasicAuth();
                    if (basicAuth == null || this.token == null) continue;
                    BasicAuthentication basicAuthentication = new BasicAuthentication(basicAuth.getUserid(), PasswordUtil.passwordDecode((String)basicAuth.getPassword()));
                    this.token.setBasicAuth(basicAuthentication);
                    this.token.setCallBackHandler(callbackHandler.getClassname());
                    this.token.setJAASConfig(tokenGenerator.getJAASConfig().getConfigName());
                    for (Properties property : callbackHandler.getProperties()) {
                        basicAuthentication.addProperty(new PropertyObject(property.getName(), property.getValue()));
                    }
                }
                SecurityInboundBindingConfig securityInboundBindingConfig = securityBinding.getSecurityInboundBindingConfig();
                signingInfos = securityInboundBindingConfig.getSigningInfo();
                encryptionInfos = securityInboundBindingConfig.getEncryptionInfo();
                keyInfos = securityInboundBindingConfig.getKeyInfo();
                List tokenConsumers = securityInboundBindingConfig.getTokenConsumer();
                for (TokenConsumer tokenConsumer : tokenConsumers) {
                    CallbackHandler callbackHandler = tokenConsumer.getCallbackHandler();
                    if (callbackHandler == null) continue;
                    int k = 0;
                    while (k < keyInfos.size()) {
                        KeyInfo keyInfo = (KeyInfo)keyInfos.get(k);
                        if (tokenConsumer.getName().equalsIgnoreCase(keyInfo.getTokenReference().getReference())) {
                            SignatureSecurityBindingObject secObject;
                            int l = 0;
                            while (l < signingInfos.size()) {
                                SigningInfo signingInfo = (SigningInfo)signingInfos.get(l);
                                for (SigningKeyInfo SigningKeyInfo3 : signingInfo.getSigningKeyInfo()) {
                                    SignatureSecurityBindingObject signatureSecurityBindingObject = secObject = isSymmetricApplicationSection ? this.consumerSymmetric : this.SignInbound;
                                    if (!keyInfo.getName().equalsIgnoreCase(SigningKeyInfo3.getReference())) continue;
                                    secObject.setKeyStore(WSFactoryUtils.readKeyStore(callbackHandler));
                                    secObject.getToken().setKeyInfoType(keyInfo.getType());
                                    secObject.getToken().setCallBackHandler(callbackHandler.getClassname());
                                    secObject.getToken().setJAASConfig(tokenConsumer.getJAASConfig().getConfigName());
                                    secObject.setTransformAlgorithm(((Transform)((SigningPartReference)signingInfo.getSigningPartReference().get(0)).getTransform().get(0)).getAlgorithm());
                                    for (Properties property : callbackHandler.getProperties()) {
                                        secObject.addProperty(new PropertyObject(property.getName(), property.getValue()));
                                    }
                                }
                                ++l;
                            }
                            for (EncryptionInfo encryptionInfo : encryptionInfos) {
                                for (KeyEncryptionKeyInfo encryptionKeyInfo : encryptionInfo.getKeyEncryptionKeyInfo()) {
                                    Object object = secObject = isSymmetricApplicationSection ? this.consumerSymmetric : this.EncInbound;
                                    if (!keyInfo.getName().equalsIgnoreCase(encryptionKeyInfo.getReference())) continue;
                                    secObject.setKeyStore(WSFactoryUtils.readKeyStore(callbackHandler));
                                    secObject.getToken().setKeyInfoType(keyInfo.getType());
                                    secObject.getToken().setCallBackHandler(callbackHandler.getClassname());
                                    secObject.getToken().setJAASConfig(tokenConsumer.getJAASConfig().getConfigName());
                                    for (Properties property : callbackHandler.getProperties()) {
                                        secObject.addProperty(new PropertyObject(property.getName(), property.getValue()));
                                    }
                                }
                            }
                        }
                        ++k;
                    }
                }
                List trustAnchors = securityInboundBindingConfig.getTrustAnchor();
                for (TrustAnchor trustAnchor : trustAnchors) {
                    com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyStore keyStore = trustAnchor.getKeyStore();
                    if (keyStore == null) continue;
                    KeyStore newKeyStore = new KeyStore(PasswordUtil.passwordDecode((String)keyStore.getStorepass()), keyStore.getPath(), keyStore.getType());
                    this.SignInbound.setKeyStore(newKeyStore);
                }
                CertStoreList certStoreList = securityInboundBindingConfig.getCertStoreList();
                if (certStoreList == null) continue;
                List collectionCertStores = certStoreList.getLdapCertStoresOrCollectionCertStores();
                int j = 0;
                while (j < collectionCertStores.size()) {
                    CollectionCertStores collectionCertStore = (CollectionCertStores)collectionCertStores.get(j);
                    List x509CertificatesOrCRLs = collectionCertStore.getX509CertificatesOrCRL();
                    int k = 0;
                    while (k < x509CertificatesOrCRLs.size()) {
                        X509Certificates x509Certificates = (X509Certificates)x509CertificatesOrCRLs.get(k);
                        if (x509Certificates != null) {
                            this.setCertificatePath(x509Certificates.getPath());
                        }
                        ++k;
                    }
                    ++j;
                }
            }
        }
        catch (UnmarshalException unmarshalException) {
            this.isOldSchema = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return PolicyTypeName;
    }

    @Override
    public Dialog getConfigurationDialog(Shell shell) {
        return new WSSecurityBindingConfigurationDialog(shell, this);
    }

    @Override
    public String validateConfiguration() {
        if (this.generatorSymmetric != null && !this.generatorSymmetric.getToken().isValid()) {
            return com.ibm.ast.ws.was61.policyset.ui.plugin.Activator.getMessage("NOT_CONFIGURED");
        }
        if (!(this.isSignatureValid() && this.isEncryptionValid() && this.isAuthenticationValid())) {
            return com.ibm.ast.ws.was61.policyset.ui.plugin.Activator.getMessage("NOT_CONFIGURED");
        }
        if (this.isOldSchema) {
            return com.ibm.ast.ws.was61.policyset.ui.plugin.Activator.getMessage("NOT_LOADED");
        }
        return com.ibm.ast.ws.was61.policyset.ui.plugin.Activator.getMessage("CONFIGURED");
    }

    private boolean isSignatureValid() {
        return this.SignOutbound == null || this.SignOutbound.getKeyStore() == null || this.SignOutbound.getKeyStore().isValid() && (this.SignInbound == null || this.SignInbound.getKeyStore() == null || this.SignInbound.getKeyStore().isValid());
    }

    private boolean isEncryptionValid() {
        return this.EncOutbound == null || this.EncOutbound.getKeyStore() == null || this.EncOutbound.getKeyStore().isValid() && (this.EncInbound == null || this.EncInbound.getKeyStore() == null || this.EncInbound.getKeyStore().isValid());
    }

    private boolean isAuthenticationValid() {
        return this.token == null || this.token.isValid();
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    private void writeWSSecurityBindings(SecurityBindings securityBindings, File bindingLocation) throws Exception {
        IPath fileLocation = new Path(bindingLocation.getAbsolutePath()).append("bindings.xml");
        JAXBContext jc = JAXBContext.newInstance((String)BindingContextPath);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        FileOutputStream os = new FileOutputStream(fileLocation.toFile());
        m.marshal((Object)securityBindings, (OutputStream)os);
        ((OutputStream)os).close();
    }

    private SecurityBindings wsSecurityBindings(Policy qosPolicyInstance) {
        SecurityBindings securityBindings = this.bindingFactory.createSecurityBindings();
        SecurityBinding securityBinding = this.bindingFactory.createSecurityBinding();
        securityBinding.setName(ApplicationBindingName);
        SecurityOutboundBindingConfig securityOutboundBindingConfig = this.bindingFactory.createSecurityOutboundBindingConfig();
        securityBinding.setSecurityOutboundBindingConfig(securityOutboundBindingConfig);
        if (this.messageExpiryTime != null) {
            TimestampExpires expiry = this.bindingFactory.createTimestampExpires();
            expiry.setExpires(this.messageExpiryTime);
            securityOutboundBindingConfig.setTimestampExpires(expiry);
        }
        SecurityInboundBindingConfig securityInboundBindingConfig = this.bindingFactory.createSecurityInboundBindingConfig();
        securityBinding.setSecurityInboundBindingConfig(securityInboundBindingConfig);
        List policys = qosPolicyInstance.getPolicyOrAllOrExactlyOne();
        int j = 0;
        while (j < policys.size()) {
            if (policys.get(j) instanceof JAXBElement) {
                JAXBElement jaxbel = (JAXBElement)policys.get(j);
                QName name = jaxbel.getName();
                NestedPolicyType nestedPolicy = (NestedPolicyType)jaxbel.getValue();
                if (PolicyConfigUtil.supportingTokenQName.equals(name)) {
                    this.SupportingTokens(nestedPolicy, securityOutboundBindingConfig);
                } else if (PolicyConfigUtil.asymmetricBindingQName.equals(name)) {
                    this.AsymmetricBinding(nestedPolicy);
                } else if (PolicyConfigUtil.symmetricBindingQName.equals(name)) {
                    Object jaxbProtection = nestedPolicy.getPolicy().getPolicyOrAllOrExactlyOne().get(0);
                    NestedPolicyType protectionPolicy = (NestedPolicyType)((JAXBElement)jaxbProtection).getValue();
                    JAXBElement requiredToken = (JAXBElement)protectionPolicy.getPolicy().getPolicyOrAllOrExactlyOne().get(0);
                    String requiredTokenName = requiredToken.getName().getLocalPart();
                    Policy requiredTokenAssertionPolicy = null;
                    if (requiredTokenName.equals("SecureConversationToken")) {
                        SecureConversationTokenType required = (SecureConversationTokenType)requiredToken.getValue();
                        List list = required.getAny();
                        if (list != null && list.size() > 0) {
                            requiredTokenAssertionPolicy = (Policy)list.get(0);
                        }
                        if (requiredTokenAssertionPolicy != null) {
                            int b = 0;
                            while (b < requiredTokenAssertionPolicy.getPolicyOrAllOrExactlyOne().size()) {
                                JAXBElement jaxbBootstrap = (JAXBElement)requiredTokenAssertionPolicy.getPolicyOrAllOrExactlyOne().get(b);
                                if (jaxbBootstrap.getValue() instanceof NestedPolicyType) {
                                    NestedPolicyType bootstrapPolicy = (NestedPolicyType)jaxbBootstrap.getValue();
                                    List bootstrapPolicys = bootstrapPolicy.getPolicy().getPolicyOrAllOrExactlyOne();
                                    SecurityBinding bootstrapBinding = this.bootstrapBinding(bootstrapPolicys);
                                    securityBindings.getSecurityBinding().add(bootstrapBinding);
                                    break;
                                }
                                ++b;
                            }
                        }
                    }
                }
            }
            ++j;
        }
        j = 0;
        while (j < policys.size()) {
            if (policys.get(j) instanceof Policy) {
                Policy policy = (Policy)policys.get(j);
                String policyId = policy.getId();
                JAXBElement jaxbel = (JAXBElement)policy.getPolicyOrAllOrExactlyOne().get(0);
                QName name = jaxbel.getName();
                if (PolicyConfigUtil.signedPartsQName.equals(name) || PolicyConfigUtil.signedElementsQName.equals(name)) {
                    if (policyId.startsWith("request:")) {
                        if (this.generatorSymmetric == null) {
                            this.genAsymmetricSignatureOutbound(policyId, securityOutboundBindingConfig);
                        } else {
                            this.genSymmetricSignatureOutbound(policyId, securityOutboundBindingConfig);
                        }
                    } else if (policyId.startsWith("response:")) {
                        if (this.consumerSymmetric == null) {
                            this.genAsymmetricSignatureInbound(policyId, securityInboundBindingConfig);
                        } else {
                            this.genSymmetricSignatureInbound(policyId, securityInboundBindingConfig);
                        }
                    }
                }
                if (PolicyConfigUtil.encryptedPartsQName.equals(name) || PolicyConfigUtil.encryptedElementsQName.equals(name)) {
                    if (policyId.startsWith("request:")) {
                        if (this.generatorSymmetric == null) {
                            this.genAsymmetricEncryptionOutbound(policyId, securityOutboundBindingConfig);
                        } else {
                            this.genSymmetricEncryptionOutbound(policyId, securityOutboundBindingConfig);
                        }
                    } else if (policyId.startsWith("response:")) {
                        if (this.consumerSymmetric == null) {
                            this.genAsymmetricEncryptionInbound(policyId, securityInboundBindingConfig);
                        } else {
                            this.genSymmetricEncryptionInbound(policyId, securityInboundBindingConfig);
                        }
                    }
                }
            }
            ++j;
        }
        securityBindings.getSecurityBinding().add(securityBinding);
        return securityBindings;
    }

    private SecurityBinding bootstrapBinding(List<Object> policys) {
        SecurityBinding securityBinding = this.bindingFactory.createSecurityBinding();
        securityBinding.setName(BootstrapBindingName);
        SecurityOutboundBindingConfig securityOutboundBindingConfig = this.bindingFactory.createSecurityOutboundBindingConfig();
        securityBinding.setSecurityOutboundBindingConfig(securityOutboundBindingConfig);
        SecurityInboundBindingConfig securityInboundBindingConfig = this.bindingFactory.createSecurityInboundBindingConfig();
        securityBinding.setSecurityInboundBindingConfig(securityInboundBindingConfig);
        int j = 0;
        while (j < policys.size()) {
            if (policys.get(j) instanceof Policy) {
                Policy policy = (Policy)policys.get(j);
                String policyId = policy.getId();
                JAXBElement jaxbel = (JAXBElement)policy.getPolicyOrAllOrExactlyOne().get(0);
                QName name = jaxbel.getName();
                if (PolicyConfigUtil.signedPartsQName.equals(name) || PolicyConfigUtil.signedElementsQName.equals(name)) {
                    if (policyId.startsWith("request:")) {
                        this.genAsymmetricSignatureOutbound(policyId, securityOutboundBindingConfig);
                    }
                    if (policyId.startsWith("response:")) {
                        this.genAsymmetricSignatureInbound(policyId, securityInboundBindingConfig);
                    }
                }
                if (PolicyConfigUtil.encryptedPartsQName.equals(name) || PolicyConfigUtil.encryptedElementsQName.equals(name)) {
                    if (policyId.startsWith("request:")) {
                        this.genAsymmetricEncryptionOutbound(policyId, securityOutboundBindingConfig);
                    }
                    if (policyId.startsWith("response:")) {
                        this.genAsymmetricEncryptionInbound(policyId, securityInboundBindingConfig);
                    }
                }
            }
            ++j;
        }
        return securityBinding;
    }

    private void SymmetricBinding(NestedPolicyType nestedPolicy) {
        try {
            TokenAssertionType required;
            Object object;
            JAXBElement jaxbProtection = (JAXBElement)nestedPolicy.getPolicy().getPolicyOrAllOrExactlyOne().get(0);
            NestedPolicyType protectionPolicy = (NestedPolicyType)jaxbProtection.getValue();
            JAXBElement requiredToken = (JAXBElement)protectionPolicy.getPolicy().getPolicyOrAllOrExactlyOne().get(0);
            Policy requiredTokenAssertionPolicy = null;
            if (requiredToken.getValue() instanceof SecureConversationTokenType) {
                SecureConversationTokenType required2 = (SecureConversationTokenType)requiredToken.getValue();
                List list = required2.getAny();
                if (list != null && list.size() > 0) {
                    requiredTokenAssertionPolicy = (Policy)list.get(0);
                }
                if (requiredTokenAssertionPolicy != null) {
                    int b = 0;
                    while (b < requiredTokenAssertionPolicy.getPolicyOrAllOrExactlyOne().size()) {
                        JAXBElement jaxbBootstrap = (JAXBElement)requiredTokenAssertionPolicy.getPolicyOrAllOrExactlyOne().get(b);
                        if (jaxbBootstrap.getValue() instanceof NestedPolicyType) {
                            NestedPolicyType bootstrapPolicy = (NestedPolicyType)jaxbBootstrap.getValue();
                            bootstrapPolicy.getPolicy().getPolicyOrAllOrExactlyOne();
                            break;
                        }
                        ++b;
                    }
                }
                this.generatorSymmetric = new SignatureSecurityBindingObject();
                this.consumerSymmetric = new SignatureSecurityBindingObject();
                this.generatorSymmetric.setToken((ProtectionToken)new SecureConversationToken(requiredToken.getName().getLocalPart(), true));
                this.consumerSymmetric.setToken((ProtectionToken)new SecureConversationToken(requiredToken.getName().getLocalPart(), false));
                this.asymmetricBindingToken = true;
            } else if (requiredToken.getValue() instanceof TokenAssertionType && (object = (requiredTokenAssertionPolicy = (Policy)(required = (TokenAssertionType)requiredToken.getValue()).getAny().get(0)).getPolicyOrAllOrExactlyOne().get(0)) instanceof WssCustomToken) {
                WssCustomToken token = (WssCustomToken)object;
                this.generatorSymmetric = new SignatureSecurityBindingObject();
                this.consumerSymmetric = new SignatureSecurityBindingObject();
                this.generatorSymmetric.setToken((ProtectionToken)new KerberosProtectionToken(token.getLocalname(), true));
                this.consumerSymmetric.setToken((ProtectionToken)new KerberosProtectionToken(token.getLocalname(), false));
                this.asymmetricBindingToken = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void AsymmetricBinding(NestedPolicyType nestedPolicy) {
        try {
            List assertions = nestedPolicy.getPolicy().getPolicyOrAllOrExactlyOne();
            int k = 0;
            while (k < assertions.size()) {
                JAXBElement anAssertion;
                String anAssertionName;
                Object potentialAssertion = assertions.get(k);
                if (potentialAssertion instanceof JAXBElement && ("InitiatorToken".equals(anAssertionName = (anAssertion = (JAXBElement)potentialAssertion).getName().getLocalPart()) || "RecipientToken".equals(anAssertionName))) {
                    NestedPolicyType np = (NestedPolicyType)anAssertion.getValue();
                    Object requiredTokenAssertion = np.getPolicy().getPolicyOrAllOrExactlyOne().get(0);
                    JAXBElement requiredToken = (JAXBElement)requiredTokenAssertion;
                    TokenAssertionType required = (TokenAssertionType)requiredToken.getValue();
                    Policy requiredTokenAssertionPolicy = (Policy)required.getAny().get(0);
                    Object object = requiredTokenAssertionPolicy.getPolicyOrAllOrExactlyOne().get(0);
                    if (object instanceof JAXBElement) {
                        JAXBElement tokenSpecification = (JAXBElement)object;
                        if ("InitiatorToken".equals(anAssertionName)) {
                            this.outTokenSpecificationName = tokenSpecification.getName().getLocalPart();
                        } else if ("RecipientToken".equals(anAssertionName)) {
                            this.inTokenSpecificationName = tokenSpecification.getName().getLocalPart();
                        }
                    }
                    this.asymmetricBindingToken = true;
                }
                ++k;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void SupportingTokens(NestedPolicyType nestedPolicy, SecurityOutboundBindingConfig securityOutboundBindingConfig) {
        try {
            Policy supportingTokenPolicy = nestedPolicy.getPolicy();
            String policyId = supportingTokenPolicy.getId();
            this.authenticationOutput(policyId, securityOutboundBindingConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void authenticationOutput(String policyId, SecurityOutboundBindingConfig securityOutboundBindingConfig) {
        TokenGenerator tokenGenerator = WSFactoryUtils.createSupportedTokenGenerator(this.bindingFactory, this.token);
        SecurityTokenReference securityTokenReference = this.bindingFactory.createSecurityTokenReference();
        securityTokenReference.setReference(policyId);
        tokenGenerator.setSecurityTokenReference(securityTokenReference);
        securityOutboundBindingConfig.getTokenGenerator().add(tokenGenerator);
    }

    private void genSymmetricSignatureInbound(String policyId, SecurityInboundBindingConfig securityInboundBindingConfig) {
        SigningInfo signingInfo = this.bindingFactory.createSigningInfo();
        SigningPartReference signingPartReference = this.bindingFactory.createSigningPartReference();
        signingPartReference.setReference(policyId);
        Transform transform = this.bindingFactory.createTransform();
        signingPartReference.getTransform().add(transform);
        signingInfo.getSigningPartReference().add(signingPartReference);
        SigningKeyInfo signingKeyInfo = this.bindingFactory.createSigningKeyInfo();
        signingInfo.getSigningKeyInfo().add(signingKeyInfo);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        transform.setAlgorithm(this.SignInbound.getTransformAlgorithm());
        TokenConsumer tokenConsumer = WSFactoryUtils.createSymmetricTokenConsumer(this.bindingFactory, this.consumerSymmetric.getToken());
        List properties = tokenConsumer.getProperties();
        properties.add(this.getPropertyObject(this.bindingFactory, "com.ibm.ws.wssecurity.sc.dkt.ServiceLabel", "WS-SecureConversation"));
        properties.add(this.getPropertyObject(this.bindingFactory, "com.ibm.ws.wssecurity.sc.dkt.ClientLabel", "WS-SecureConversation"));
        securityInboundBindingConfig.getTokenConsumer().add(tokenConsumer);
        keyInfo.setType(this.consumerSymmetric.getToken().getKeyInfoType(true));
        keyInfo.setName("con_signkeyinfo");
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentConsumer");
        tokenReference.setReference(tokenConsumer.getName());
        securityInboundBindingConfig.getKeyInfo().add(keyInfo);
        signingKeyInfo.setReference(keyInfo.getName());
        securityInboundBindingConfig.getSigningInfo().add(signingInfo);
    }

    private void genSymmetricSignatureOutbound(String policyId, SecurityOutboundBindingConfig securityOutboundBindingConfig) {
        SigningInfo signingInfo = this.bindingFactory.createSigningInfo();
        SigningPartReference signingPartReference = this.bindingFactory.createSigningPartReference();
        signingPartReference.setReference(policyId);
        Transform transform = this.bindingFactory.createTransform();
        signingPartReference.getTransform().add(transform);
        signingInfo.getSigningPartReference().add(signingPartReference);
        SigningKeyInfo signingKeyInfo = this.bindingFactory.createSigningKeyInfo();
        signingInfo.getSigningKeyInfo().add(signingKeyInfo);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        TokenGenerator tokenGenerator = WSFactoryUtils.createSymmetricTokenGenerator(this.bindingFactory, this.generatorSymmetric.getToken());
        transform.setAlgorithm(this.SignOutbound.getTransformAlgorithm());
        List properties = tokenGenerator.getProperties();
        properties.add(this.getPropertyObject(this.bindingFactory, "com.ibm.ws.wssecurity.sc.dkt.ServiceLabel", "WS-SecureConversation"));
        properties.add(this.getPropertyObject(this.bindingFactory, "com.ibm.ws.wssecurity.sc.dkt.ClientLabel", "WS-SecureConversation"));
        securityOutboundBindingConfig.getTokenGenerator().add(tokenGenerator);
        keyInfo.setType(this.generatorSymmetric.getToken().getKeyInfoType(true));
        keyInfo.setName("gen_signkeyinfo");
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentGenerator");
        tokenReference.setReference(tokenGenerator.getName());
        securityOutboundBindingConfig.getKeyInfo().add(keyInfo);
        signingInfo.setOrder(this.SignOutbound.getOrder());
        signingKeyInfo.setReference(keyInfo.getName());
        securityOutboundBindingConfig.getSigningInfo().add(signingInfo);
    }

    private void genAsymmetricEncryptionInbound(String policyId, SecurityInboundBindingConfig securityInboundBindingConfig) {
        EncryptionInfo encryptionInfo = this.bindingFactory.createEncryptionInfo();
        EncryptionPartReference encryptionPartReference = this.bindingFactory.createEncryptionPartReference();
        encryptionPartReference.setReference(policyId);
        encryptionInfo.setEncryptionPartReference(encryptionPartReference);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        TokenConsumer tokenConsumer = WSFactoryUtils.createAsymmetricTokenConsumer(this.bindingFactory, this.EncInbound);
        CallbackHandler handler = tokenConsumer.getCallbackHandler();
        WSFactoryUtils.createKeyStore(this.bindingFactory, handler, this.EncInbound.getKeyStore());
        CertPathSettings certPathSettings = this.bindingFactory.createCertPathSettings();
        TrustAnyCertificate trustAnyCertificate = this.bindingFactory.createTrustAnyCertificate();
        certPathSettings.setTrustAnyCertificate(trustAnyCertificate);
        handler.setCertPathSettings(certPathSettings);
        securityInboundBindingConfig.getTokenConsumer().add(tokenConsumer);
        keyInfo.setName("con_enckeyinfo");
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentConsumer");
        keyInfo.setType(this.EncInbound.getToken().getKeyInfoType(false));
        tokenReference.setReference(tokenConsumer.getName());
        securityInboundBindingConfig.getKeyInfo().add(keyInfo);
        KeyEncryptionKeyInfo keyEncryptionKeyInfo = this.bindingFactory.createKeyEncryptionKeyInfo();
        keyEncryptionKeyInfo.setReference(keyInfo.getName());
        encryptionInfo.getKeyEncryptionKeyInfo().add(keyEncryptionKeyInfo);
        securityInboundBindingConfig.getEncryptionInfo().add(encryptionInfo);
    }

    private void genAsymmetricSignatureInbound(String policyId, SecurityInboundBindingConfig securityInboundBindingConfig) {
        SigningInfo signingInfo = this.bindingFactory.createSigningInfo();
        SigningPartReference signingPartReference = this.bindingFactory.createSigningPartReference();
        signingPartReference.setReference(policyId);
        Transform transform = this.bindingFactory.createTransform();
        transform.setAlgorithm(this.SignInbound.getTransformAlgorithm());
        signingPartReference.getTransform().add(transform);
        signingInfo.getSigningPartReference().add(signingPartReference);
        SigningKeyInfo signingKeyInfo = this.bindingFactory.createSigningKeyInfo();
        signingInfo.getSigningKeyInfo().add(signingKeyInfo);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        TokenConsumer tokenConsumer = WSFactoryUtils.createAsymmetricTokenConsumer(this.bindingFactory, (SecurityBindingObject)this.SignInbound);
        securityInboundBindingConfig.getTokenConsumer().add(tokenConsumer);
        ProtectionToken token = this.SignInbound.getToken();
        CertPathSettings certPathSettings = this.bindingFactory.createCertPathSettings();
        if (this.SignInbound.getKeyStore() != null) {
            TrustAnchor trustAnchor = this.bindingFactory.createTrustAnchor();
            trustAnchor.setName("DigSigTrustAnchor");
            WSFactoryUtils.createKeyStore(this.bindingFactory, trustAnchor, this.SignInbound.getKeyStore());
            securityInboundBindingConfig.getTrustAnchor().add(trustAnchor);
            TrustAnchorRef trustAnchorRef = this.bindingFactory.createTrustAnchorRef();
            trustAnchorRef.setReference(trustAnchor.getName());
            certPathSettings.setTrustAnchorRef(trustAnchorRef);
            if (this.getCertificatePath() != null && this.getCertificatePath().length() > 0) {
                CertStoreList certStoreList = this.bindingFactory.createCertStoreList();
                CollectionCertStores collectionCertStore = this.bindingFactory.createCollectionCertStores();
                collectionCertStore.setName("DigSigCertStore");
                collectionCertStore.setProvider("IBMCertPath");
                X509Certificates x509Certificate = this.bindingFactory.createX509Certificates();
                x509Certificate.setPath(this.getCertificatePath());
                collectionCertStore.getX509CertificatesOrCRL().add(x509Certificate);
                certStoreList.getLdapCertStoresOrCollectionCertStores().add(collectionCertStore);
                securityInboundBindingConfig.setCertStoreList(certStoreList);
                CertStoreRef certStoreRef = this.bindingFactory.createCertStoreRef();
                certStoreRef.setReference("DigSigCertStore");
                certPathSettings.setCertStoreRef(certStoreRef);
            }
        } else {
            TrustAnyCertificate trustAnyCertificate = this.bindingFactory.createTrustAnyCertificate();
            certPathSettings.setTrustAnyCertificate(trustAnyCertificate);
        }
        tokenConsumer.getCallbackHandler().setCertPathSettings(certPathSettings);
        keyInfo.setName("con_signkeyinfo");
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentConsumer");
        keyInfo.setType(token.getKeyInfoType(true));
        tokenReference.setReference(token.getId());
        securityInboundBindingConfig.getKeyInfo().add(keyInfo);
        signingKeyInfo.setReference(keyInfo.getName());
        securityInboundBindingConfig.getSigningInfo().add(signingInfo);
    }

    private void genAsymmetricSignatureOutbound(String policyId, SecurityOutboundBindingConfig securityOutboundBindingConfig) {
        SigningInfo signingInfo = this.bindingFactory.createSigningInfo();
        SigningPartReference signingPartReference = this.bindingFactory.createSigningPartReference();
        signingPartReference.setReference(policyId);
        Transform transform = this.bindingFactory.createTransform();
        transform.setAlgorithm(this.SignOutbound.getTransformAlgorithm());
        signingPartReference.getTransform().add(transform);
        signingInfo.getSigningPartReference().add(signingPartReference);
        SigningKeyInfo signingKeyInfo = this.bindingFactory.createSigningKeyInfo();
        signingInfo.getSigningKeyInfo().add(signingKeyInfo);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        securityOutboundBindingConfig.getTokenGenerator().add(WSFactoryUtils.createAsymmetricTokenGenerator(this.bindingFactory, (SecurityBindingObject)this.SignOutbound));
        ProtectionToken token = this.SignOutbound.getToken();
        keyInfo.setType(token.getKeyInfoType(true));
        keyInfo.setName("gen_signkeyinfo");
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentGenerator");
        tokenReference.setReference(token.getId());
        securityOutboundBindingConfig.getKeyInfo().add(keyInfo);
        signingInfo.setOrder(this.SignOutbound.getOrder());
        signingKeyInfo.setReference(keyInfo.getName());
        securityOutboundBindingConfig.getSigningInfo().add(signingInfo);
    }

    private void genAsymmetricEncryptionOutbound(String policyId, SecurityOutboundBindingConfig securityOutboundBindingConfig) {
        EncryptionInfo encryptionInfo = this.bindingFactory.createEncryptionInfo();
        EncryptionPartReference encryptionPartReference = this.bindingFactory.createEncryptionPartReference();
        encryptionPartReference.setReference(policyId);
        encryptionInfo.setEncryptionPartReference(encryptionPartReference);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        securityOutboundBindingConfig.getTokenGenerator().add(WSFactoryUtils.createAsymmetricTokenGenerator(this.bindingFactory, (SecurityBindingObject)this.EncOutbound));
        ProtectionToken token = this.EncOutbound.getToken();
        keyInfo.setName("gen_enckeyinfo");
        keyInfo.setType(token.getKeyInfoType(false));
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentGenerator");
        tokenReference.setReference(token.getId());
        securityOutboundBindingConfig.getKeyInfo().add(keyInfo);
        encryptionInfo.setOrder(this.EncOutbound.getOrder());
        KeyEncryptionKeyInfo keyEncryptionKeyInfo = this.bindingFactory.createKeyEncryptionKeyInfo();
        keyEncryptionKeyInfo.setReference(keyInfo.getName());
        encryptionInfo.getKeyEncryptionKeyInfo().add(keyEncryptionKeyInfo);
        encryptionInfo.getProperties().add(this.getPropertyObject(this.bindingFactory, this.EncOutbound.getEnableMTOM()));
        encryptionInfo.getProperties().add(this.getPropertyObject(this.bindingFactory, this.EncOutbound.getEncryptedHeader()));
        securityOutboundBindingConfig.getEncryptionInfo().add(encryptionInfo);
    }

    private void genSymmetricEncryptionInbound(String policyId, SecurityInboundBindingConfig securityInboundBindingConfig) {
        EncryptionInfo encryptionInfo = this.bindingFactory.createEncryptionInfo();
        EncryptionPartReference encryptionPartReference = this.bindingFactory.createEncryptionPartReference();
        encryptionPartReference.setReference(policyId);
        encryptionInfo.setEncryptionPartReference(encryptionPartReference);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        keyInfo.setType(this.consumerSymmetric.getToken().getKeyInfoType(true));
        keyInfo.setName("con_enckeyinfo");
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentConsumer");
        SecureConversationToken duplicateToken = new SecureConversationToken(this.consumerSymmetric.getToken().getTokenName(), false);
        TokenConsumer tokenConsumer = WSFactoryUtils.createSymmetricTokenConsumer(this.bindingFactory, (ProtectionToken)duplicateToken);
        List properties = tokenConsumer.getProperties();
        properties.add(this.getPropertyObject(this.bindingFactory, "com.ibm.ws.wssecurity.sc.dkt.ServiceLabel", "WS-SecureConversation"));
        properties.add(this.getPropertyObject(this.bindingFactory, "com.ibm.ws.wssecurity.sc.dkt.ClientLabel", "WS-SecureConversation"));
        securityInboundBindingConfig.getTokenConsumer().add(tokenConsumer);
        tokenReference.setReference(tokenConsumer.getName());
        securityInboundBindingConfig.getKeyInfo().add(keyInfo);
        DataEncryptionKeyInfo dataEncryptionKeyInfo = this.bindingFactory.createDataEncryptionKeyInfo();
        dataEncryptionKeyInfo.setReference(keyInfo.getName());
        encryptionPartReference.getDataEncryptionKeyInfo().add(dataEncryptionKeyInfo);
        securityInboundBindingConfig.getEncryptionInfo().add(encryptionInfo);
    }

    private void genSymmetricEncryptionOutbound(String policyId, SecurityOutboundBindingConfig securityOutboundBindingConfig) {
        EncryptionInfo encryptionInfo = this.bindingFactory.createEncryptionInfo();
        EncryptionPartReference encryptionPartReference = this.bindingFactory.createEncryptionPartReference();
        encryptionPartReference.setReference(policyId);
        encryptionInfo.setEncryptionPartReference(encryptionPartReference);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        keyInfo.setType(this.generatorSymmetric.getToken().getKeyInfoType(true));
        keyInfo.setName("gen_enckeyinfo");
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentGenerator");
        securityOutboundBindingConfig.getKeyInfo().add(keyInfo);
        SecureConversationToken duplicateToken = new SecureConversationToken(this.generatorSymmetric.getToken().getTokenName(), true);
        TokenGenerator tokenGenerator = WSFactoryUtils.createSymmetricTokenGenerator(this.bindingFactory, (ProtectionToken)duplicateToken);
        List properties = tokenGenerator.getProperties();
        properties.add(this.getPropertyObject(this.bindingFactory, "com.ibm.ws.wssecurity.sc.dkt.ServiceLabel", "WS-SecureConversation"));
        properties.add(this.getPropertyObject(this.bindingFactory, "com.ibm.ws.wssecurity.sc.dkt.ClientLabel", "WS-SecureConversation"));
        securityOutboundBindingConfig.getTokenGenerator().add(tokenGenerator);
        tokenReference.setReference(tokenGenerator.getName());
        encryptionInfo.setOrder(this.EncOutbound.getOrder());
        DataEncryptionKeyInfo dataEncryptionKeyInfo = this.bindingFactory.createDataEncryptionKeyInfo();
        dataEncryptionKeyInfo.setReference(keyInfo.getName());
        encryptionPartReference.getDataEncryptionKeyInfo().add(dataEncryptionKeyInfo);
        securityOutboundBindingConfig.getEncryptionInfo().add(encryptionInfo);
    }

    public boolean isSignatureFound(Policy qosPolicyInstance) {
        List policys = qosPolicyInstance.getPolicyOrAllOrExactlyOne();
        int j = 0;
        while (j < policys.size()) {
            Policy policy;
            JAXBElement jaxbel;
            QName name;
            if (policys.get(j) instanceof Policy && (PolicyConfigUtil.signedPartsQName.equals(name = (jaxbel = (JAXBElement)(policy = (Policy)policys.get(j)).getPolicyOrAllOrExactlyOne().get(0)).getName()) || PolicyConfigUtil.signedElementsQName.equals(name))) {
                if (policy.getId().startsWith("request:")) {
                    this.isOutboundSignatureFound = true;
                }
                if (policy.getId().startsWith("response:")) {
                    this.isInboundSignatureFound = true;
                }
            }
            ++j;
        }
        return this.isOutboundSignatureFound || this.isInboundSignatureFound;
    }

    public boolean isEncryptionFound(Policy qosPolicyInstance) {
        List policys = qosPolicyInstance.getPolicyOrAllOrExactlyOne();
        int j = 0;
        while (j < policys.size()) {
            Policy policy;
            JAXBElement jaxbel;
            QName name;
            if (policys.get(j) instanceof Policy && (PolicyConfigUtil.encryptedPartsQName.equals(name = (jaxbel = (JAXBElement)(policy = (Policy)policys.get(j)).getPolicyOrAllOrExactlyOne().get(0)).getName()) || PolicyConfigUtil.encryptedElementsQName.equals(name))) {
                if (policy.getId().startsWith("request:")) {
                    this.isOutboundEncryptionFound = true;
                }
                if (policy.getId().startsWith("response:")) {
                    this.isInboundEncryptionFound = true;
                }
            }
            ++j;
        }
        return this.isInboundEncryptionFound || this.isOutboundEncryptionFound;
    }

    public static String isAuthenticationFound(Policy qosPolicyInstance) {
        List policys = qosPolicyInstance.getPolicyOrAllOrExactlyOne();
        int j = 0;
        while (j < policys.size()) {
            JAXBElement jaxbel;
            QName name;
            if (policys.get(j) instanceof JAXBElement && PolicyConfigUtil.supportingTokenQName.equals(name = (jaxbel = (JAXBElement)policys.get(j)).getName())) {
                NestedPolicyType nestedPolicy = (NestedPolicyType)jaxbel.getValue();
                Policy supportingTokenPolicy = nestedPolicy.getPolicy();
                JAXBElement jaxbAssertion = (JAXBElement)supportingTokenPolicy.getPolicyOrAllOrExactlyOne().get(0);
                return jaxbAssertion.getName().getLocalPart();
            }
            ++j;
        }
        return null;
    }

    private void getTokenSpecificationNames(Policy qosPolicyInstance) {
        try {
            List policys = qosPolicyInstance.getPolicyOrAllOrExactlyOne();
            int j = 0;
            while (j < policys.size()) {
                if (policys.get(j) instanceof JAXBElement) {
                    Object anObject;
                    Policy supportingTokenPolicy;
                    JAXBElement jaxbAssertion;
                    TokenAssertionType authToken;
                    List any;
                    JAXBElement jaxbel = (JAXBElement)policys.get(j);
                    QName name = jaxbel.getName();
                    NestedPolicyType nestedPolicy = (NestedPolicyType)jaxbel.getValue();
                    if (PolicyConfigUtil.asymmetricBindingQName.equals(name)) {
                        this.AsymmetricBinding(nestedPolicy);
                    } else if (PolicyConfigUtil.symmetricBindingQName.equals(name)) {
                        this.SymmetricBinding(nestedPolicy);
                    } else if (PolicyConfigUtil.supportingTokenQName.equals(name) && (any = (authToken = (TokenAssertionType)(jaxbAssertion = (JAXBElement)(supportingTokenPolicy = nestedPolicy.getPolicy()).getPolicyOrAllOrExactlyOne().get(0)).getValue()).getAny()) != null && any.size() != 0 && (anObject = any.get(0)) instanceof Policy) {
                        Policy tokenPolicy = (Policy)anObject;
                        Object object = tokenPolicy.getPolicyOrAllOrExactlyOne().get(0);
                        if (object instanceof JAXBElement) {
                            JAXBElement jaxbToken = (JAXBElement)object;
                            this.authenticationTokenName = jaxbToken.getName().getLocalPart();
                        } else if (object instanceof WssCustomToken) {
                            this.authenticationTokenLocalname = ((WssCustomToken)object).getLocalname();
                        }
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getMessageExpiryTime() {
        return this.messageExpiryTime;
    }

    public void setMessageExpiryTime(String messageExpiryTime) {
        this.messageExpiryTime = messageExpiryTime;
    }

    public SecurityBindingObject getEncInbound() {
        return this.EncInbound;
    }

    public void setEncInbound(SecurityBindingObject encInbound) {
        this.EncInbound = encInbound;
    }

    public SecurityBindingObject getEncOutbound() {
        return this.EncOutbound;
    }

    public void setEncOutbound(EncryptionOutBoundSecurityBindingObject encOutbound) {
        this.EncOutbound = encOutbound;
    }

    public SignatureSecurityBindingObject getSignInbound() {
        return this.SignInbound;
    }

    public void setSignInbound(SignatureSecurityBindingObject signInbound) {
        this.SignInbound = signInbound;
    }

    public SignatureSecurityBindingObject getSignOutbound() {
        return this.SignOutbound;
    }

    public void setSignOutbound(SignatureSecurityBindingObject signOutbound) {
        this.SignOutbound = signOutbound;
    }

    public AuthenticationToken getAuthenticationToken() {
        return this.token;
    }

    private Properties getPropertyObject(ObjectFactory factory, String name, String value) {
        Properties properties = factory.createProperties();
        properties.setName(name);
        properties.setValue(value);
        return properties;
    }

    private Properties getPropertyObject(ObjectFactory factory, PropertyObject object) {
        return this.getPropertyObject(factory, object.getName(), object.getValue());
    }

    public void setAuthenticationToken(AuthenticationToken token) {
        this.token = token;
    }
}

