/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.types;

import com.ibm.ast.ws.service.policy.ui.PolicySetUtils;
import com.ibm.ast.ws.was61.policyset.ui.common.PolicyUtils;
import com.ibm.ast.ws.was61.policyset.ui.dialogs.WSRMBindingConfigurationDialog;
import com.ibm.ast.ws.was61.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was61.policyset.ui.types.PolicyType;
import com.ibm.ws.websvcs.rm.policyset.Constants;
import com.ibm.ws.websvcs.rm.policyset.gen.BusConfiguration;
import com.ibm.ws.websvcs.rm.policyset.gen.ObjectFactory;
import com.ibm.ws.websvcs.rm.policyset.gen.policy.OperatorContentType;
import com.ibm.ws.websvcs.rm.policyset.gen.policy.Policy;
import com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1.RMAssertion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

public class WSReliableMessagingPolicy
extends PolicyType {
    public static String PolicyTypeName = "WSReliableMessaging";
    public static String ContextPath = String.valueOf(Constants._RM_V1_0_SCHEMA) + ":" + Constants._WS_POLICY_SCHEMA + ":" + Constants._POLICY_SCHEMA;
    private String busName = "";
    private String messagingEngineName = "";
    protected static JAXBContext jc;
    protected static Unmarshaller u;
    protected static Marshaller m;
    protected String CONTEXT_PATH = String.valueOf(Constants._RM_V1_0_SCHEMA) + ":" + Constants._RM_V1_1_SCHEMA + ":" + Constants._WS_POLICY_SCHEMA + ":" + Constants._POLICY_SCHEMA;
    private boolean unmanaged;

    protected Marshaller getMarshaller() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)this.CONTEXT_PATH);
        }
        if (m == null) {
            m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
        }
        return m;
    }

    protected Unmarshaller getUnmarshaller() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)this.CONTEXT_PATH);
        }
        if (u == null) {
            u = jc.createUnmarshaller();
        }
        return u;
    }

    public IStatus saveBindingConfiguration(File location) {
        try {
            BusConfiguration bindings = this.rmBindings();
            this.writeRmBindings(bindings, location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    private BusConfiguration rmBindings() {
        ObjectFactory bindingFactory = new ObjectFactory();
        BusConfiguration busConfigurations = bindingFactory.createBusConfiguration();
        busConfigurations.setBusName(this.busName);
        busConfigurations.setMessagingEngineName(this.messagingEngineName);
        return busConfigurations;
    }

    private void writeRmBindings(BusConfiguration rmBindings, File bindingLocation) throws Exception {
        IPath fileLocation = new Path(bindingLocation.getAbsolutePath()).append("bindings.xml");
        JAXBContext jc = JAXBContext.newInstance((String)ContextPath);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        FileOutputStream os = new FileOutputStream(fileLocation.toFile());
        m.marshal((Object)rmBindings, (OutputStream)os);
        ((OutputStream)os).close();
    }

    public void readBindingConfiguration(IPath location) {
        if (location == null) {
            return;
        }
        try {
            this.readReliableMessagingPolicy();
            Object bindings = PolicyUtils.readExistingBindingConfiguration(location, this.getName(), ContextPath);
            if (bindings == null) {
                return;
            }
            BusConfiguration busConfigurations = (BusConfiguration)bindings;
            this.busName = busConfigurations.getBusName();
            this.messagingEngineName = busConfigurations.getMessagingEngineName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readReliableMessagingPolicy() throws JAXBException {
        Policy policy = null;
        String pathname = PolicySetUtils.getPolicyPath((IServicePolicy)this.getServicePolicy());
        Iterator policyProps = null;
        policy = (Policy)this.getUnmarshaller().unmarshal(new File(PolicyUtils.expandURL(pathname)));
        JAXBElement exactlyOneElem = (JAXBElement)policy.getPolicyOrAllOrExactlyOne().get(0);
        OperatorContentType exactlyOne = (OperatorContentType)exactlyOneElem.getValue();
        JAXBElement allElem = (JAXBElement)exactlyOne.getPolicyOrAllOrExactlyOne().get(0);
        OperatorContentType all = (OperatorContentType)allElem.getValue();
        Object abstractRMAssertion = all.getPolicyOrAllOrExactlyOne().get(0);
        if (abstractRMAssertion instanceof RMAssertion) {
            policyProps = ((RMAssertion)abstractRMAssertion).getAny().iterator();
        } else if (abstractRMAssertion instanceof com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_0.RMAssertion) {
            policyProps = ((com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_0.RMAssertion)abstractRMAssertion).getAny().iterator();
        }
        while (policyProps.hasNext()) {
            JAXBElement currPolicyProp;
            String propName;
            Object o = policyProps.next();
            if (!(o instanceof JAXBElement) || !(propName = (currPolicyProp = (JAXBElement)o).getName().getLocalPart()).equals(Constants._QUALITY_OF_SERVICE)) continue;
            String qualityOfService = (String)currPolicyProp.getValue();
            this.unmanaged = qualityOfService.equals(Constants._UNMANAGED_NON_PERSISTENT);
        }
    }

    public String getName() {
        return PolicyTypeName;
    }

    public Dialog getConfigurationDialog(Shell shell) {
        if (this.unmanaged) {
            return null;
        }
        return new WSRMBindingConfigurationDialog(shell, this);
    }

    public String validateConfiguration() {
        if (this.unmanaged) {
            this.busName = null;
            this.messagingEngineName = null;
            return Activator.getMessage("CONFIGURATION_NA");
        }
        if (this.busName != null && !this.busName.equals("") && this.messagingEngineName != null && !this.messagingEngineName.equals("")) {
            return Activator.getMessage("CONFIGURED");
        }
        return Activator.getMessage("NOT_CONFIGURED");
    }

    public String getMessagingEngineName() {
        return this.messagingEngineName;
    }

    public void setMessagingEngineName(String messagingEngineName) {
        this.messagingEngineName = messagingEngineName;
    }

    public String getBusName() {
        return this.busName;
    }

    public void setBusName(String busName) {
        this.busName = busName;
    }
}

