/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.tables;

import com.ibm.ast.ws.jaxws.emitter.collector.ClientData;
import com.ibm.ast.ws.jaxws.emitter.collector.ServiceData;
import com.ibm.ast.ws.was61.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was61.policyset.ui.dialogs.ClientSideConfigureEndpointDialog;
import com.ibm.ast.ws.was61.policyset.ui.dialogs.ConfigureEndpointDialog;
import com.ibm.ast.ws.was61.policyset.ui.dialogs.ServerSideConfigureEndpointDialog;
import com.ibm.ast.ws.was61.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was61.policyset.ui.tables.AbstractConfigurationTable;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndPointConfigurationTable
extends AbstractConfigurationTable {
    private Button add_;
    private Button remove_;
    private Button edit_;
    private IProject application;
    private EndPointObject selectedEndPointObject;
    private Listener listener;
    private Map<String, EndPointObject> endPoints;
    private ServiceData[] serviceData;
    private ClientData[] clientData;
    private Map<String, IServicePolicy> policySets;

    public EndPointConfigurationTable(Composite parent, Listener listener, String[] columns) {
        super(parent, columns);
        this.listener = listener;
    }

    @Override
    protected void addButtonsAndHandlers(Composite parent) {
        this.add_ = this.uiUtils.createPushButton(parent, Activator.getMessage("LABEL_ADD"), null, null);
        this.add_.setEnabled(false);
        this.add_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ConfigureEndpointDialog dialog = null;
                dialog = EndPointConfigurationTable.this.serviceData != null ? new ServerSideConfigureEndpointDialog(EndPointConfigurationTable.this.getShell(), EndPointConfigurationTable.this.application, EndPointConfigurationTable.this.serviceData) : new ClientSideConfigureEndpointDialog(EndPointConfigurationTable.this.getShell(), EndPointConfigurationTable.this.application, EndPointConfigurationTable.this.clientData);
                dialog.setPolicySets(EndPointConfigurationTable.this.policySets);
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    EndPointObject endPoint = dialog.getEndPoint();
                    TableItem tableItem = null;
                    if (EndPointConfigurationTable.this.endPoints.containsKey(endPoint.getDisplayName())) {
                        TableItem[] items = EndPointConfigurationTable.this.table_.getItems();
                        int i = 0;
                        while (i < items.length) {
                            if (items[i].getText(0).equals(endPoint.getDisplayName())) {
                                tableItem = items[i];
                            }
                            ++i;
                        }
                        Assert.isNotNull((Object)tableItem);
                    } else {
                        tableItem = new TableItem(EndPointConfigurationTable.this.table_, 8);
                    }
                    String binding = endPoint.getAttachedBinding();
                    if (binding == null || binding.equals("")) {
                        binding = Activator.getMessage("DEFAULT_BINDING");
                    }
                    tableItem.setText(new String[]{endPoint.getDisplayName(), endPoint.getAttachedPolicySet().getDescriptor().getLongName(), binding});
                    EndPointConfigurationTable.this.endPoints.put(endPoint.getDisplayName(), endPoint);
                    EndPointConfigurationTable.this.table_.select(EndPointConfigurationTable.this.table_.indexOf(tableItem));
                    EndPointConfigurationTable.this.selectedEndPointObject = endPoint;
                    EndPointConfigurationTable.this.enableButtons();
                    EndPointConfigurationTable.this.listener.handleEvent(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.edit_ = this.uiUtils.createPushButton(parent, Activator.getMessage("LABEL_EDIT_BUTTON"), null, null);
        this.edit_.setEnabled(false);
        this.edit_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableItem itemToEdit = EndPointConfigurationTable.this.table_.getItem(EndPointConfigurationTable.this.table_.getSelectionIndex());
                Assert.isTrue((boolean)EndPointConfigurationTable.this.endPoints.containsKey(itemToEdit.getText(0)));
                EndPointObject object = (EndPointObject)EndPointConfigurationTable.this.endPoints.get(itemToEdit.getText(0));
                ConfigureEndpointDialog dialog = null;
                dialog = EndPointConfigurationTable.this.serviceData != null ? new ServerSideConfigureEndpointDialog(EndPointConfigurationTable.this.getShell(), EndPointConfigurationTable.this.application, object, EndPointConfigurationTable.this.serviceData) : new ClientSideConfigureEndpointDialog(EndPointConfigurationTable.this.getShell(), EndPointConfigurationTable.this.application, object, EndPointConfigurationTable.this.clientData);
                dialog.setPolicySets(EndPointConfigurationTable.this.policySets);
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    String binding = object.getAttachedBinding();
                    if (binding == null || binding.equals("")) {
                        binding = Activator.getMessage("DEFAULT_BINDING");
                    }
                    itemToEdit.setText(new String[]{object.getDisplayName(), object.getAttachedPolicySet().getDescriptor().getLongName(), binding});
                    EndPointConfigurationTable.this.table_.select(EndPointConfigurationTable.this.table_.indexOf(itemToEdit));
                    EndPointConfigurationTable.this.selectedEndPointObject = (EndPointObject)EndPointConfigurationTable.this.endPoints.get(itemToEdit.getText(0));
                    EndPointConfigurationTable.this.listener.handleEvent(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.remove_ = this.uiUtils.createPushButton(parent, Activator.getMessage("LABEL_REMOVE"), null, null);
        this.remove_.setEnabled(false);
        this.remove_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EndPointConfigurationTable.this.selectedEndPointObject = null;
                TableItem itemToRemove = EndPointConfigurationTable.this.table_.getItem(EndPointConfigurationTable.this.table_.getSelectionIndex());
                Assert.isTrue((boolean)EndPointConfigurationTable.this.endPoints.containsKey(itemToRemove.getText(0)));
                EndPointConfigurationTable.this.endPoints.remove(itemToRemove.getText(0));
                EndPointConfigurationTable.this.table_.remove(EndPointConfigurationTable.this.table_.getSelectionIndex());
                EndPointConfigurationTable.this.enableButtons();
                EndPointConfigurationTable.this.listener.handleEvent(null);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        TableItem itemToEdit = this.table_.getItem(this.table_.getSelectionIndex());
        Assert.isTrue((boolean)this.endPoints.containsKey(itemToEdit.getText(0)));
        this.selectedEndPointObject = this.endPoints.get(itemToEdit.getText(0));
        this.listener.handleEvent(null);
    }

    public void setReferences(List<EndPointObject> references) {
        this.table_.removeAll();
        this.add_.setEnabled(true);
        this.endPoints = new Hashtable<String, EndPointObject>();
        for (EndPointObject object : references) {
            TableItem newItem = new TableItem(this.table_, 8);
            String binding = object.getAttachedBinding();
            if (binding == null || binding.equals("")) {
                binding = Activator.getMessage("DEFAULT_BINDING");
            }
            newItem.setText(new String[]{object.getDisplayName(), object.getAttachedPolicySet().getDescriptor().getLongName(), binding});
            this.endPoints.put(object.getDisplayName(), object);
        }
        if (this.table_.getItemCount() == 0) {
            this.selectedEndPointObject = null;
        } else {
            this.table_.select(0);
            this.widgetSelected(null);
        }
        this.enableButtons();
    }

    private void enableButtons() {
        boolean enabled = this.table_.getItemCount() > 0;
        this.remove_.setEnabled(enabled);
        this.edit_.setEnabled(enabled);
    }

    public List<EndPointObject> getReferences() {
        Vector<EndPointObject> references = new Vector<EndPointObject>();
        for (EndPointObject object : this.endPoints.values()) {
            references.add(object);
        }
        return references;
    }

    public void setApplication(IProject application) {
        this.application = application;
    }

    public EndPointObject getSelectedEndPointObject() {
        return this.selectedEndPointObject;
    }

    public void setServiceData(ServiceData[] serviceData) {
        this.serviceData = serviceData;
    }

    public void setClientData(ClientData[] clientData) {
        this.clientData = clientData;
    }

    public Map<String, IServicePolicy> getPolicySets() {
        return this.policySets;
    }

    public void setPolicySets(Map<String, IServicePolicy> policySets) {
        this.policySets = policySets;
    }
}

