/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.tables;

import com.ibm.ast.ws.was61.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was61.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was61.policyset.ui.tables.AbstractConfigurationTable;
import com.ibm.ast.ws.was61.policyset.ui.types.PolicyType;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class BindingConfigurationTable
extends AbstractConfigurationTable {
    private Button edit_;
    private EndPointObject endPointObject;
    private Listener statusListener_;

    public BindingConfigurationTable(Composite parent, Listener statusListener, String[] columns) {
        super(parent, columns);
        this.statusListener_ = statusListener;
    }

    protected void addButtonsAndHandlers(Composite parent) {
        this.edit_ = this.uiUtils.createPushButton(parent, Activator.getMessage("LABEL_CONFIG"), null, null);
        this.edit_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableItem itemToEdit = BindingConfigurationTable.this.table_.getItem(BindingConfigurationTable.this.table_.getSelectionIndex());
                String policyType = itemToEdit.getText(0);
                PolicyType type = BindingConfigurationTable.this.endPointObject.getBindingConfigObjects().get(policyType);
                Dialog dialog = type.getConfigurationDialog(BindingConfigurationTable.this.getShell());
                if (dialog != null) {
                    dialog.open();
                    BindingConfigurationTable.this.endPointObject.getBindingConfigObjects().put(policyType, type);
                    itemToEdit.setText(new String[]{policyType, type.validateConfiguration()});
                    BindingConfigurationTable.this.statusListener_.handleEvent(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.edit_.setEnabled(false);
    }

    public void setReferences(EndPointObject endPointObject) {
        this.endPointObject = endPointObject;
        this.table_.removeAll();
        if (endPointObject == null) {
            return;
        }
        Map<String, PolicyType> references = endPointObject.getBindingConfigObjects();
        for (PolicyType policyType : references.values()) {
            TableItem newItem = new TableItem(this.table_, 8);
            newItem.setText(new String[]{policyType.getName(), policyType.validateConfiguration()});
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        TableItem itemToEdit = this.table_.getItem(this.table_.getSelectionIndex());
        String bindingConfig = itemToEdit.getText(1);
        this.edit_.setEnabled(!bindingConfig.equals(Activator.getMessage("CONFIGURATION_NA")));
    }
}

