/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.preferences;

import com.ibm.ast.ws.service.policy.ui.DefaultServicePoliciesUtils;
import com.ibm.ast.ws.service.policy.ui.PolicySetUtils;
import com.ibm.ast.ws.service.policy.ui.ServiceUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.ws.service.policy.IDescriptor;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyPlatformLoadListener;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class WASv61PolicySetsLoadListener
implements IPolicyPlatformLoadListener {
    private static final String[] ENUM_ID_VALUES = new String[]{"org.eclipse.wst.true", "org.eclipse.wst.false"};
    private static final String[] OLDQoS_IDS = new String[]{"com.ibm.ast.ws.policyset.ui.qos.LTPARAMPdefault", "com.ibm.ast.ws.policyset.ui.qos.LTPASecureConversation", "com.ibm.ast.ws.policyset.ui.qos.LTPAWSSecuritydefault", "com.ibm.ast.ws.policyset.ui.qos.RAMPdefault", "com.ibm.ast.ws.policyset.ui.qos.SecureConversation", "com.ibm.ast.ws.policyset.ui.qos.SSLWSTransaction", "com.ibm.ast.ws.policyset.ui.qos.UsernameRAMPdefault", "com.ibm.ast.ws.policyset.ui.qos.UsernameSecureConversation", "com.ibm.ast.ws.policyset.ui.qos.UsernameWSSecuritydefault", "com.ibm.ast.ws.policyset.ui.qos.WSAddressingdefault", "com.ibm.ast.ws.policyset.ui.qos.WSHTTPSdefault", "com.ibm.ast.ws.policyset.ui.qos.WSReliableMessagingdefault", "com.ibm.ast.ws.policyset.ui.qos.WSReliableMessaging1_0", "com.ibm.ast.ws.policyset.ui.qos.WSReliableMessagingpersistent", "com.ibm.ast.ws.policyset.ui.qos.WSSecuritydefault", "com.ibm.ast.ws.policyset.ui.qos.WSTransaction"};
    private static final String[] NEWPolicySetFavorite_IDS = new String[]{"com.ibm.ast.ws.policy.ui.qos.LTPARAMPdefault", "com.ibm.ast.ws.policy.ui.qos.LTPASecureConversation", "com.ibm.ast.ws.policy.ui.qos.LTPAWSSecuritydefault", "com.ibm.ast.ws.policy.ui.qos.RAMPdefault", "com.ibm.ast.ws.policy.ui.qos.SecureConversation", "com.ibm.ast.ws.policy.ui.qos.SSLWSTransaction", "com.ibm.ast.ws.policy.ui.qos.UsernameRAMPdefault", "com.ibm.ast.ws.policy.ui.qos.UsernameSecureConversation", "com.ibm.ast.ws.policy.ui.qos.UsernameWSSecuritydefault", "com.ibm.ast.ws.policy.ui.qos.WSAddressingdefault", "com.ibm.ast.ws.policy.ui.qos.WSHTTPSdefault", "com.ibm.ast.ws.policy.ui.qos.WSReliableMessagingdefault", "com.ibm.ast.ws.policy.ui.qos.WSReliableMessaging1_0", "com.ibm.ast.ws.policy.ui.qos.WSReliableMessagingpersistent", "com.ibm.ast.ws.policy.ui.qos.WSSecuritydefault", "com.ibm.ast.ws.policy.ui.qos.WSTransaction"};
    private static final String oldQoSPluginID = "com.ibm.ccl.ws.qos.core";

    public void load() {
        block17: {
            block16: {
                ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
                String policySetFavorite = null;
                boolean bFavoriteDefined = false;
                try {
                    try {
                        this.migrateV61PolicySets(platform);
                        IEclipsePreferences preferences = new InstanceScope().getNode("org.eclipse.wst.ws.service.policy");
                        int i = 0;
                        while (i < NEWPolicySetFavorite_IDS.length) {
                            policySetFavorite = preferences.get(String.valueOf(NEWPolicySetFavorite_IDS[i]) + "." + "default.value.key", null);
                            if (policySetFavorite != null && policySetFavorite.equals(ENUM_ID_VALUES[0])) {
                                bFavoriteDefined = true;
                                break;
                            }
                            ++i;
                        }
                        if (bFavoriteDefined) break block16;
                        String qosFavorite = Platform.getPreferencesService().getString(oldQoSPluginID, "policySetFavorite", "", null);
                        if (qosFavorite != null && !qosFavorite.equals("")) {
                            int oldQoSIDIndex = this.indexOfString(qosFavorite, OLDQoS_IDS);
                            String newPolicySetFavoriteID = null;
                            newPolicySetFavoriteID = oldQoSIDIndex < NEWPolicySetFavorite_IDS.length && oldQoSIDIndex != -1 ? NEWPolicySetFavorite_IDS[oldQoSIDIndex] : this.getImportedFavoriteId(qosFavorite, null);
                            if (newPolicySetFavoriteID != null) {
                                IServicePolicy policySetFavoritePolicy = platform.getServicePolicy(newPolicySetFavoriteID);
                                IPolicyState policySetFavoritePolicyState = policySetFavoritePolicy.getPolicyState();
                                IServicePolicy oldFavoritePolicySet = PolicySetUtils.getDefaultCategoryPolicy((String)"com.ibm.ast.ws.service.policy.ui.policyset.category", null);
                                if (oldFavoritePolicySet != policySetFavoritePolicy) {
                                    policySetFavoritePolicyState.putValue("default.value.key", ENUM_ID_VALUES[0]);
                                    oldFavoritePolicySet.getPolicyState().putValue("default.value.key", ENUM_ID_VALUES[1]);
                                }
                                bFavoriteDefined = true;
                            }
                        }
                        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int i2 = 0;
                        while (i2 < projects.length) {
                            try {
                                IProject project = projects[i2];
                                ProjectScope projectScope = new ProjectScope(project);
                                IEclipsePreferences projectNode = projectScope.getNode(oldQoSPluginID);
                                if (projectNode != null) {
                                    boolean projectEnabled = projectNode.getBoolean("projectEnabled", false);
                                    String projectPolicySetFavoriteID = projectNode.get("policySetFavorite", null);
                                    if (projectEnabled && projectPolicySetFavoriteID != null && !projectPolicySetFavoriteID.equals("")) {
                                        int oldQoSIDIndex = this.indexOfString(projectPolicySetFavoriteID, OLDQoS_IDS);
                                        String newProjectPolicySetFavorite = null;
                                        newProjectPolicySetFavorite = oldQoSIDIndex < NEWPolicySetFavorite_IDS.length && oldQoSIDIndex != -1 ? NEWPolicySetFavorite_IDS[oldQoSIDIndex] : this.getImportedFavoriteId(qosFavorite, project);
                                        if (newProjectPolicySetFavorite != null) {
                                            IServicePolicy policySetFavoritePolicy = platform.getServicePolicy(newProjectPolicySetFavorite);
                                            IPolicyState projectPolicySetFavoritePolicyState = policySetFavoritePolicy.getPolicyState(project);
                                            IServicePolicy oldFavoritePolicySet = PolicySetUtils.getDefaultCategoryPolicy((String)"com.ibm.ast.ws.service.policy.ui.policyset.category", (IProject)project);
                                            if (oldFavoritePolicySet != policySetFavoritePolicy) {
                                                projectPolicySetFavoritePolicyState.putValue("default.value.key", ENUM_ID_VALUES[0]);
                                                oldFavoritePolicySet.getPolicyState(project).putValue("default.value.key", ENUM_ID_VALUES[1]);
                                            }
                                            platform.setProjectPreferencesEnabled(project, true);
                                        }
                                    }
                                }
                            }
                            catch (Exception exception) {}
                            ++i2;
                        }
                    }
                    catch (Exception exception) {
                        String[] categories = new String[]{"com.ibm.ast.ws.service.policy.ui.policyset.category"};
                        DefaultServicePoliciesUtils utils = new DefaultServicePoliciesUtils(categories);
                        utils.load();
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    String[] categories = new String[]{"com.ibm.ast.ws.service.policy.ui.policyset.category"};
                    DefaultServicePoliciesUtils utils = new DefaultServicePoliciesUtils(categories);
                    utils.load();
                    throw throwable;
                }
            }
            String[] categories = new String[]{"com.ibm.ast.ws.service.policy.ui.policyset.category"};
            DefaultServicePoliciesUtils utils = new DefaultServicePoliciesUtils(categories);
            utils.load();
        }
    }

    private void migrateV61PolicySets(ServicePolicyPlatform platform) throws BackingStoreException, IOException {
        Bundle bundle = Platform.getBundle((String)"com.ibm.ast.ws.service.policy.ui");
        IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
        IPath oldLocation = stateLocation.removeLastSegments(1).append(oldQoSPluginID);
        IEclipsePreferences preferences = new InstanceScope().getNode(oldQoSPluginID);
        String oldPolicyIds = preferences.get("localPolicySets", "");
        String[] splitIds = oldPolicyIds.split(",");
        boolean foundOldId = false;
        String[] stringArray = splitIds;
        int n = splitIds.length;
        int n2 = 0;
        while (n2 < n) {
            String oldId = stringArray[n2];
            String oldPolicyInfo = preferences.get(oldId, "");
            String[] splitInfo = oldPolicyInfo.split(",");
            String oldPolicyName = null;
            if (splitInfo.length >= 2 && !splitInfo[1].equals("")) {
                oldPolicyName = splitInfo[1];
            }
            if (oldPolicyName != null) {
                this.migratePolicy(oldPolicyName, oldLocation, platform, stateLocation);
                foundOldId = true;
            }
            ++n2;
        }
        if (foundOldId) {
            preferences.remove("localPolicySets");
            preferences.flush();
        }
    }

    private String getImportedFavoriteId(String qosFavorite, IProject project) {
        String[] splitInfo;
        String result = null;
        IEclipsePreferences preferences = project == null ? new InstanceScope().getNode(oldQoSPluginID) : new ProjectScope(project).getNode(oldQoSPluginID);
        String favInfo = preferences.get(qosFavorite, "");
        String favName = null;
        if (!favInfo.equals("") && (splitInfo = favInfo.split(",")).length >= 2) {
            favName = splitInfo[1];
        }
        if (favName != null) {
            List v61PolicySets = PolicySetUtils.getCategoryPolicies((String)"com.ibm.ast.ws.service.policy.ui.policyset.category");
            for (IServicePolicy policySet : v61PolicySets) {
                if (!policySet.getDescriptor().getShortName().equals(favName)) continue;
                result = policySet.getId();
                break;
            }
        }
        return result;
    }

    private void migratePolicy(String oldPolicyName, IPath oldLocation, ServicePolicyPlatform platform, IPath stateLocation) throws FileNotFoundException, IOException {
        IServicePolicy wasV61Category = platform.getServicePolicy("com.ibm.ast.ws.service.policy.ui.policyset.category");
        List policySets = wasV61Category.getChildren();
        Set names = ServiceUtils.getPolicySetNames((List)policySets);
        String uniqueName = ServiceUtils.findUniqueName((Set)names, (String)oldPolicyName);
        IPath relNewPolicySetPath = new Path(wasV61Category.getId()).append("PolicySets").append(uniqueName).append("policySet.xml");
        IPath newPolicySetPath = stateLocation.append(relNewPolicySetPath);
        IPath oldPolicySetPath = oldLocation.append("policySets").append(oldPolicyName);
        IServicePolicy policySetPolicy = this.createModelPolicy(platform, wasV61Category, uniqueName, relNewPolicySetPath.toString(), true, "");
        WASv61PolicySetsLoadListener.copyFile(oldPolicySetPath.append("policySet.xml").toString(), newPolicySetPath.toString());
        IPath policyTypesPath = oldPolicySetPath.append("PolicyTypes");
        File policyTypesDir = new File(policyTypesPath.toString());
        File[] policies = policyTypesDir.listFiles();
        if (policies != null) {
            File[] fileArray = policies;
            int n = policies.length;
            int n2 = 0;
            while (n2 < n) {
                File policyType = fileArray[n2];
                String policyName = policyType.getName();
                IPath policyNamePath = new Path(policyName).append("policy.xml");
                IPath relNewPolicyPath = relNewPolicySetPath.removeLastSegments(1).append(policyNamePath);
                IPath newPolicyPath = newPolicySetPath.removeLastSegments(1).append("PolicyTypes").append(policyNamePath);
                IPath oldPolicyPath = oldPolicySetPath.append("PolicyTypes").append(policyNamePath);
                this.createModelPolicy(platform, policySetPolicy, policyName, relNewPolicyPath.toString(), false, "");
                WASv61PolicySetsLoadListener.copyFile(oldPolicyPath.toString(), newPolicyPath.toString());
                ++n2;
            }
        }
    }

    private static void copyFile(String inputFileName, String outputFileName) {
        try {
            FileInputStream oldStream = new FileInputStream(inputFileName);
            File outputFile = new File(outputFileName);
            File parentFile = outputFile.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            FileOutputStream newStream = new FileOutputStream(outputFile);
            WASv61PolicySetsLoadListener.copyStreams(oldStream, newStream);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private static void copyStreams(InputStream is, OutputStream os) throws IOException {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream(os);
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            while ((bytesRead = bis.read(buffer)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, bytesRead);
            }
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    private IServicePolicy createModelPolicy(ServicePolicyPlatform platform, IServicePolicy parent, String name, String path, boolean isPolicySet, String description) {
        String idName = isPolicySet ? "qos.policyset" : "policytype";
        String id = "com.ibm.ast.ws.local." + idName + ".id1";
        IServicePolicy newPolicy = platform.createServicePolicy(parent, id, "org.eclipse.wst.service.policy.booleanEnum", "org.eclipse.wst.false");
        IDescriptor descriptor = newPolicy.getDescriptor();
        IPolicyState policyState = newPolicy.getPolicyState();
        descriptor.setShortName(name);
        descriptor.setIconBundleId("com.ibm.ast.ws.service.policy.ui");
        descriptor.setIconPath(isPolicySet ? "icons/obj16/localPolicySet.gif" : "icons/obj16/policytype_obj.gif");
        descriptor.setDescription(description);
        policyState.putValue("policyPath", "local:/" + path);
        return newPolicy;
    }

    private int indexOfString(String target, String[] values) {
        int result = -1;
        int index = 0;
        while (index < values.length) {
            String value = values[index];
            if (value.equals(target)) {
                result = index;
                break;
            }
            ++index;
        }
        return result;
    }
}

