/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.dialogs;

import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.policyset.ui.common.EncryptionOutBoundSecurityBindingObject;
import com.ibm.ast.ws.policyset.ui.common.KeyStore;
import com.ibm.ast.ws.policyset.ui.common.KeyStoreWithKey;
import com.ibm.ast.ws.policyset.ui.common.SecurityBindingObject;
import com.ibm.ast.ws.policyset.ui.common.SignatureSecurityBindingObject;
import com.ibm.ast.ws.policyset.ui.dialogs.AuthenticationTokenComposite;
import com.ibm.ast.ws.policyset.ui.dialogs.BindingConfigurationDialog;
import com.ibm.ast.ws.policyset.ui.dialogs.KeyStoreSettingsDialog;
import com.ibm.ast.ws.policyset.ui.tokens.ProtectionToken;
import com.ibm.ast.ws.was61.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was61.policyset.ui.types.PolicyType;
import com.ibm.ast.ws.was61.policyset.ui.types.WSSecurityPolicy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class WSSecurityBindingConfigurationDialog
extends BindingConfigurationDialog {
    private TabFolder tabFolder;
    private TabItem digitalSignature;
    private TabItem xmlEncryption;
    private TabItem authentication;
    private static final String DEFAULT_SIGNATURE_ORDER = "1";
    private static final String DEFAULT_ENCRYPTION_ORDER = "2";
    private String INFOPOP_WS_SECURITY_DIALOG = "WSS0007";
    private String INFOPOP_WSS_SIGNOUT_GROUP = "WSS0001";
    private SignatureSecurityBindingObject SignOutbound;
    private String INFOPOP_WSS_SIGNIN_GROUP = "WSS0002";
    private SignatureSecurityBindingObject SignInbound;
    private String INFOPOP_WSS_SIGNCER_TEXT = "WSS0003";
    private Text certificatePath;
    private String INFOPOP_WSS_SIGNCER_BUTTON = "WSS0004";
    private Button browseCert;
    private String INFOPOP_WSS_ENCOUT_GROUP = "WSS0005";
    private EncryptionOutBoundSecurityBindingObject EncOutbound;
    private String INFOPOP_WSS_ENCIN_GROUP = "WSS0006";
    private SecurityBindingObject EncInbound;
    private TokenComposite OutboundSign;
    private String INFOPOP_WSS_KEYINF_DIG_COMBO = "WSS0017";
    private String INFOPOP_WSS_TRANS_OUT_COMBO = "WSS0008";
    private Combo transformAlgorithmOutbound;
    private Combo signOrder;
    private TokenComposite InboundSign;
    private String INFOPOP_WSS_TRANS_IN_COMBO = "WSS0009";
    private Combo transformAlgorithmInbound;
    private TokenComposite OutboundEnc;
    private String INFOPOP_WSS_KEYINF_ENC_COMBO = "WSS0010";
    private Combo encOrder;
    private String INFOPOP_WSS_KEYST_BUTTON = "WSS0011";
    private Button signInKeyStore;
    private TokenComposite InboundEnc;
    private String INFOPOP_WSS_TRUST_ANY_CHECK = "WSS0012";
    private Button trustAnyCertificate;
    private AuthenticationTokenComposite auth;
    private WSSecurityPolicy policyType;
    private String INFOPOP_WSS_MSG_EXP_CHECK = "WSS0013";
    private Button enableMessageExp;
    private String INFOPOP_WSS_MSG_EXP_TEXT = "WSS0014";
    private Text messageExpirationTime;
    private String INFOPOP_WSS_MTOM_CHECK = "WSS0015";
    private Button enableMTOM;
    private String INFOPOP_WSS_ENC_HEAD_CHECK = "WSS0016";
    private Button enableEncHeader;
    private boolean first = true;
    private Button signOutTimestamp;
    private Button signOutNonce;
    private Button signInTimestamp;
    private Button signInNonce;
    private Button encOutTimestamp;
    private Button encOutNonce;
    private Button encInTimestamp;
    private Button encInNonce;

    public WSSecurityBindingConfigurationDialog(Shell parent, PolicyType type) {
        super(parent);
        this.policyType = (WSSecurityPolicy)type;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parent_ = (Composite)super.createDialogArea(parent);
        this.setTitle(this.getMessage("CONFIGURE_WSSECURITY_DIALOG_TITLE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent_, "com.ibm.ast.ws.was61.policyset.ui." + this.INFOPOP_WS_SECURITY_DIALOG);
        new Label(parent_, 256);
        new Label(parent_, 256);
        this.tabFolder = new TabFolder(parent_, 0);
        GridData gd = new GridData(1808);
        this.tabFolder.setLayoutData((Object)gd);
        if (this.policyType.getSignInbound() != null || this.policyType.getSignOutbound() != null) {
            this.digitalSignature = new TabItem(this.tabFolder, 0);
            this.digitalSignature.setText(this.getMessage("DIGITAL_SIGNATURE_CONFIG"));
            this.digitalSignature.setControl(this.createDigitalSignatureConfigPage((Composite)this.tabFolder));
            this.digitalSignature.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        }
        if (this.policyType.getEncInbound() != null || this.policyType.getEncOutbound() != null) {
            this.xmlEncryption = new TabItem(this.tabFolder, 0);
            this.xmlEncryption.setText(this.getMessage("XML_ENCRYPTION_CONFIG"));
            this.xmlEncryption.setControl(this.createXMLEncryptionConfigPage((Composite)this.tabFolder));
        }
        if (this.policyType.getAuthenticationToken() != null) {
            this.authentication = new TabItem(this.tabFolder, 0);
            this.authentication.setText(this.getMessage("AUTHENTICATION_CONFIG_TAB"));
            this.authentication.setControl(this.createAuthenticationConfigPage((Composite)this.tabFolder));
        }
        Composite messageExpiry = this.uiUtils.createComposite(parent_, 1);
        this.enableMessageExp = this.uiUtils.createCheckbox(messageExpiry, this.getMessage("CHECKBOX_ENABLE_MESSAGE_EXP"), this.getMessage("TOOLTIP_MESSAGE_EXPIRATION"), this.INFOPOP_WSS_MSG_EXP_CHECK);
        this.enableMessageExp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSSecurityBindingConfigurationDialog.this.messageExpirationTime.setEnabled(WSSecurityBindingConfigurationDialog.this.enableMessageExp.getSelection());
                WSSecurityBindingConfigurationDialog.this.getStatusListener().handleEvent(null);
            }
        });
        Composite messageExpiryInterval = this.uiUtils.createComposite(parent_, 6);
        this.messageExpirationTime = this.uiUtils.createText(messageExpiryInterval, this.getMessage("LABEL_MESSAGE_EXP_INTERVAL"), this.getMessage("TOOLTIP_MESSAGE_EXPIRATION"), this.INFOPOP_WSS_MSG_EXP_TEXT, 2048);
        this.uiUtils.createText(messageExpiryInterval, this.getMessage("LABEL_MESSAGE_EXP_MINUTES"), null, null, 8);
        String expTime = this.policyType.getMessageExpiryTime();
        if (expTime != null) {
            this.enableMessageExp.setSelection(true);
            this.messageExpirationTime.setEnabled(true);
            this.messageExpirationTime.setText(expTime);
        } else {
            this.enableMessageExp.setSelection(false);
            this.messageExpirationTime.setEnabled(false);
        }
        this.messageExpirationTime.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WSSecurityBindingConfigurationDialog.this.getStatusListener().handleEvent(null);
            }
        });
        this.tabFolder.addListener(13, this.getStatusListener());
        return parent;
    }

    private Control createDigitalSignatureConfigPage(Composite parent) {
        ScrolledComposite scomp = new ScrolledComposite(parent, 768);
        Composite signatureGroup = this.uiUtils.createComposite((Composite)scomp, 1);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        if (this.policyType.getSignOutbound() != null) {
            this.OutboundSign = new TokenComposite(signatureGroup, this.getMessage("CONFIGURE_OUTBOUND_MESSAGE"), this.getMessage("TOOLTIP_WSS_SIGNOUT_GROUP"), this.INFOPOP_WSS_SIGNOUT_GROUP);
            Group outBound = this.OutboundSign.getMainComposite();
            this.transformAlgorithmOutbound = this.uiUtils.createCombo((Composite)outBound, this.getMessage("LABEL_TRANSFORM_ALGO"), null, this.INFOPOP_WSS_TRANS_OUT_COMBO, 2056);
            this.transformAlgorithmOutbound.setItems(CommonPolicyUtils.getTransformAlgorithms());
            this.transformAlgorithmOutbound.select(0);
            this.signOrder = this.uiUtils.createCombo((Composite)outBound, this.getMessage("LABEL_ORDER"), null, null, 2056);
            this.signOrder.setItems(new String[]{DEFAULT_SIGNATURE_ORDER, DEFAULT_ENCRYPTION_ORDER});
            this.signOrder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (WSSecurityBindingConfigurationDialog.this.signOrder.getSelectionIndex() == 0) {
                        WSSecurityBindingConfigurationDialog.this.encOrder.select(1);
                    } else {
                        WSSecurityBindingConfigurationDialog.this.encOrder.select(0);
                    }
                }
            });
            Button signOutKeyStore = this.uiUtils.createPushButton((Composite)outBound, this.getMessage("KEY_STORE_SETTINGS"), null, this.INFOPOP_WSS_KEYST_BUTTON);
            signOutKeyStore.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KeyStoreSettingsDialog dialog = new KeyStoreSettingsDialog(WSSecurityBindingConfigurationDialog.this.getShell(), WSSecurityBindingConfigurationDialog.this.SignOutbound.getKeyStore());
                    int result = dialog.open();
                    if (result == 0) {
                        WSSecurityBindingConfigurationDialog.this.SignOutbound.setKeyStore((KeyStore)((KeyStoreWithKey)dialog.getKeyStore()));
                    }
                    WSSecurityBindingConfigurationDialog.this.getStatusListener().handleEvent(null);
                }
            });
            new Label((Composite)outBound, 256);
            Composite properties = this.uiUtils.createComposite((Composite)outBound, 1);
            properties.setLayoutData((Object)gridData);
            this.signOutTimestamp = this.uiUtils.createCheckbox(properties, this.getMessage("GENERATOR_TIMESTAMP"), null, this.INFOPOP_WSS_KEYST_BUTTON);
            this.signOutNonce = this.uiUtils.createCheckbox(properties, this.getMessage("GENERATOR_NONCE"), null, this.INFOPOP_WSS_KEYST_BUTTON);
        }
        if (this.policyType.getSignInbound() != null) {
            this.InboundSign = new TokenComposite(signatureGroup, this.getMessage("CONFIGURE_INBOUND_MESSAGE"), this.getMessage("TOOLTIP_WSS_SIGNIN_GROUP"), this.INFOPOP_WSS_SIGNIN_GROUP);
            Group inBound = this.InboundSign.getMainComposite();
            this.transformAlgorithmInbound = this.uiUtils.createCombo((Composite)inBound, this.getMessage("LABEL_TRANSFORM_ALGO"), null, this.INFOPOP_WSS_TRANS_IN_COMBO, 2056);
            this.transformAlgorithmInbound.setItems(CommonPolicyUtils.getTransformAlgorithms());
            this.transformAlgorithmInbound.select(0);
            this.trustAnyCertificate = this.uiUtils.createCheckbox((Composite)inBound, this.getMessage("CHECKBOX_TRUST_ANY_CERT"), this.getMessage("TOOLTIP_CHECKBOX_TRUST_ANY_CERT"), this.INFOPOP_WSS_TRUST_ANY_CHECK);
            this.trustAnyCertificate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean trustAny = WSSecurityBindingConfigurationDialog.this.trustAnyCertificate.getSelection();
                    WSSecurityBindingConfigurationDialog.this.signInKeyStore.setEnabled(!trustAny);
                    WSSecurityBindingConfigurationDialog.this.certificatePath.setEnabled(!trustAny);
                    WSSecurityBindingConfigurationDialog.this.browseCert.setEnabled(!trustAny);
                    WSSecurityBindingConfigurationDialog.this.getStatusListener().handleEvent(null);
                }
            });
            new Label((Composite)inBound, 0);
            this.signInKeyStore = this.uiUtils.createPushButton((Composite)inBound, this.getMessage("KEY_STORE_SETTINGS"), null, this.INFOPOP_WSS_KEYST_BUTTON);
            this.signInKeyStore.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KeyStoreSettingsDialog dialog;
                    int result;
                    if (WSSecurityBindingConfigurationDialog.this.SignInbound.getKeyStore() == null) {
                        WSSecurityBindingConfigurationDialog.this.SignInbound.setKeyStore(new KeyStore("", "", ""));
                    }
                    if ((result = (dialog = new KeyStoreSettingsDialog(WSSecurityBindingConfigurationDialog.this.getShell(), WSSecurityBindingConfigurationDialog.this.SignInbound.getKeyStore())).open()) == 0) {
                        WSSecurityBindingConfigurationDialog.this.SignInbound.setKeyStore(dialog.getKeyStore());
                    }
                    WSSecurityBindingConfigurationDialog.this.getStatusListener().handleEvent(null);
                }
            });
            new Label((Composite)inBound, 0);
            Label certPathLabel = new Label((Composite)inBound, 8);
            certPathLabel.setText(this.getMessage("CERTIFICATE_PATH_LABEL"));
            Composite composite = this.uiUtils.createComposite((Composite)inBound, 2, 0, 0);
            this.certificatePath = new Text(composite, 2048);
            this.certificatePath.setToolTipText(this.getMessage("TOOLTIP_WSS_SIGNCER_TEXT"));
            this.certificatePath.setToolTipText(this.INFOPOP_WSS_SIGNCER_TEXT);
            this.certificatePath.setLayoutData((Object)new GridData(768));
            this.browseCert = this.uiUtils.createPushButton(composite, this.getMessage("LABEL_BROWSE_BUTTON"), this.getMessage("TOOLTIP_WSS_SIGNCER_BUTTON"), this.INFOPOP_WSS_SIGNCER_BUTTON);
            this.browseCert.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileDialog = new FileDialog(WSSecurityBindingConfigurationDialog.this.getShell());
                    fileDialog.setFilterExtensions(new String[]{"*.cer", "*.*"});
                    fileDialog.setFilterNames(new String[]{String.valueOf(Activator.getMessage("CERTIFICATE_FILES")) + " (*.cer)", String.valueOf(Activator.getMessage("ALL_FILE")) + " (*.*)"});
                    String certificatePathText = fileDialog.open();
                    if (certificatePathText != null) {
                        WSSecurityBindingConfigurationDialog.this.certificatePath.setText(certificatePathText);
                    }
                }
            });
            Composite properties = this.uiUtils.createComposite((Composite)inBound, 1);
            properties.setLayoutData((Object)gridData);
            this.signInTimestamp = this.uiUtils.createCheckbox(properties, this.getMessage("CONSUMER_TIMESTAMP"), null, this.INFOPOP_WSS_KEYST_BUTTON);
            this.signInNonce = this.uiUtils.createCheckbox(properties, this.getMessage("CONSUMER_NONCE"), null, this.INFOPOP_WSS_KEYST_BUTTON);
            this.SignInbound = this.policyType.getSignInbound();
            if (this.SignInbound != null) {
                this.InboundSign.setSecurityObject((SecurityBindingObject)this.SignInbound);
                if (this.SignInbound.getTransformAlgorithm() != null) {
                    this.transformAlgorithmInbound.setText(this.SignInbound.getTransformAlgorithm());
                } else {
                    this.transformAlgorithmInbound.select(0);
                }
                if (this.SignInbound.getKeyStore() == null) {
                    this.trustAnyCertificate.setSelection(true);
                    this.signInKeyStore.setEnabled(false);
                    this.certificatePath.setEnabled(false);
                    this.browseCert.setEnabled(false);
                } else {
                    this.trustAnyCertificate.setSelection(false);
                    String certPath = this.policyType.getCertificatePath();
                    if (certPath != null) {
                        this.certificatePath.setText(certPath);
                    }
                }
            }
            this.signInTimestamp.setSelection(this.SignInbound.getConsumerTimestamp().getBooleanValue());
            this.signInNonce.setSelection(this.SignInbound.getConsumerNonce().getBooleanValue());
        }
        this.SignOutbound = this.policyType.getSignOutbound();
        if (this.SignOutbound != null) {
            this.OutboundSign.setSecurityObject((SecurityBindingObject)this.SignOutbound);
            if (this.SignOutbound.getTransformAlgorithm() != null) {
                this.transformAlgorithmOutbound.setText(this.SignOutbound.getTransformAlgorithm());
            } else {
                this.transformAlgorithmOutbound.select(0);
            }
            try {
                this.signOrder.setText(this.SignOutbound.getOrder());
            }
            catch (Exception exception) {
                this.signOrder.setText(DEFAULT_SIGNATURE_ORDER);
            }
            this.signOutTimestamp.setSelection(this.SignOutbound.getGeneratorTimestamp().getBooleanValue());
            this.signOutNonce.setSelection(this.SignOutbound.getGeneratorNonce().getBooleanValue());
        }
        scomp.setExpandHorizontal(true);
        scomp.setExpandVertical(true);
        scomp.setContent((Control)signatureGroup);
        scomp.setMinSize(signatureGroup.computeSize(-1, -1));
        return scomp;
    }

    private Control createXMLEncryptionConfigPage(Composite parent) {
        Composite properties;
        ScrolledComposite scomp = new ScrolledComposite(parent, 768);
        Composite encGroup = this.uiUtils.createComposite((Composite)scomp, 1);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        if (this.policyType.getEncOutbound() != null) {
            this.OutboundEnc = new TokenComposite(encGroup, this.getMessage("CONFIGURE_OUTBOUND_MESSAGE"), this.getMessage("TOOLTIP_WSS_ENCOUT_GROUP"), this.INFOPOP_WSS_ENCOUT_GROUP);
            Group outBound = this.OutboundEnc.getMainComposite();
            this.encOrder = this.uiUtils.createCombo((Composite)outBound, this.getMessage("LABEL_ORDER"), null, null, 2056);
            this.encOrder.setItems(new String[]{DEFAULT_SIGNATURE_ORDER, DEFAULT_ENCRYPTION_ORDER});
            this.encOrder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (WSSecurityBindingConfigurationDialog.this.encOrder.getSelectionIndex() == 0) {
                        WSSecurityBindingConfigurationDialog.this.signOrder.select(1);
                    } else {
                        WSSecurityBindingConfigurationDialog.this.signOrder.select(0);
                    }
                }
            });
            Button encOutKeyStore = this.uiUtils.createPushButton((Composite)outBound, this.getMessage("KEY_STORE_SETTINGS"), null, this.INFOPOP_WSS_KEYST_BUTTON);
            encOutKeyStore.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KeyStoreSettingsDialog dialog = new KeyStoreSettingsDialog(WSSecurityBindingConfigurationDialog.this.getShell(), WSSecurityBindingConfigurationDialog.this.EncOutbound.getKeyStore());
                    int result = dialog.open();
                    if (result == 0) {
                        WSSecurityBindingConfigurationDialog.this.EncOutbound.setKeyStore((KeyStore)((KeyStoreWithKey)dialog.getKeyStore()));
                    }
                    WSSecurityBindingConfigurationDialog.this.getStatusListener().handleEvent(null);
                }
            });
            properties = this.uiUtils.createComposite((Composite)outBound, 1);
            properties.setLayoutData((Object)gridData);
            this.encOutTimestamp = this.uiUtils.createCheckbox(properties, this.getMessage("GENERATOR_TIMESTAMP"), null, this.INFOPOP_WSS_KEYST_BUTTON);
            this.encOutNonce = this.uiUtils.createCheckbox(properties, this.getMessage("GENERATOR_NONCE"), null, this.INFOPOP_WSS_KEYST_BUTTON);
            this.enableMTOM = this.uiUtils.createCheckbox(properties, this.getMessage("CHECKBOX_ENABLE_MTOM"), null, this.INFOPOP_WSS_MTOM_CHECK);
            this.enableEncHeader = this.uiUtils.createCheckbox(properties, this.getMessage("CHECKBOX_ENABLE_ENC_HEAD"), null, this.INFOPOP_WSS_ENC_HEAD_CHECK);
            this.EncOutbound = (EncryptionOutBoundSecurityBindingObject)this.policyType.getEncOutbound();
            try {
                this.encOrder.setText(this.EncOutbound.getOrder());
            }
            catch (Exception exception) {
                this.encOrder.setText(DEFAULT_ENCRYPTION_ORDER);
            }
            this.OutboundEnc.setSecurityObject((SecurityBindingObject)this.EncOutbound);
            this.encOutTimestamp.setSelection(this.EncOutbound.getGeneratorTimestamp().getBooleanValue());
            this.encOutNonce.setSelection(this.EncOutbound.getGeneratorNonce().getBooleanValue());
            this.enableMTOM.setSelection(this.EncOutbound.getEnableMTOM().getBooleanValue());
            this.enableEncHeader.setSelection(this.EncOutbound.getEncryptedHeader().getBooleanValue());
        }
        if (this.policyType.getEncInbound() != null) {
            this.InboundEnc = new TokenComposite(encGroup, this.getMessage("CONFIGURE_INBOUND_MESSAGE"), this.getMessage("TOOLTIP_WSS_ENCIN_GROUP"), this.INFOPOP_WSS_ENCIN_GROUP);
            Group inBound = this.InboundEnc.getMainComposite();
            Button encInKeyStore = this.uiUtils.createPushButton((Composite)inBound, this.getMessage("KEY_STORE_SETTINGS"), null, this.INFOPOP_WSS_KEYST_BUTTON);
            encInKeyStore.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KeyStoreSettingsDialog dialog = new KeyStoreSettingsDialog(WSSecurityBindingConfigurationDialog.this.getShell(), WSSecurityBindingConfigurationDialog.this.EncInbound.getKeyStore());
                    int result = dialog.open();
                    if (result == 0) {
                        WSSecurityBindingConfigurationDialog.this.EncInbound.setKeyStore((KeyStore)((KeyStoreWithKey)dialog.getKeyStore()));
                    }
                    WSSecurityBindingConfigurationDialog.this.getStatusListener().handleEvent(null);
                }
            });
            new Label((Composite)inBound, 256);
            properties = this.uiUtils.createComposite((Composite)inBound, 1);
            properties.setLayoutData((Object)gridData);
            this.encInTimestamp = this.uiUtils.createCheckbox(properties, this.getMessage("CONSUMER_TIMESTAMP"), null, this.INFOPOP_WSS_KEYST_BUTTON);
            this.encInNonce = this.uiUtils.createCheckbox(properties, this.getMessage("CONSUMER_NONCE"), null, this.INFOPOP_WSS_KEYST_BUTTON);
            this.EncInbound = this.policyType.getEncInbound();
            this.InboundEnc.setSecurityObject(this.EncInbound);
            this.encInTimestamp.setSelection(this.EncInbound.getConsumerTimestamp().getBooleanValue());
            this.encInNonce.setSelection(this.EncInbound.getConsumerNonce().getBooleanValue());
        }
        scomp.setExpandHorizontal(true);
        scomp.setExpandVertical(true);
        scomp.setContent((Control)encGroup);
        scomp.setMinSize(encGroup.computeSize(-1, -1));
        return scomp;
    }

    private Control createAuthenticationConfigPage(Composite parent) {
        ScrolledComposite scomp = new ScrolledComposite(parent, 768);
        Composite authGroup = this.uiUtils.createComposite((Composite)scomp, 1);
        new Label(authGroup, 256);
        this.auth = new AuthenticationTokenComposite();
        this.auth.addControls(authGroup, this.getStatusListener());
        this.auth.setToken(this.policyType.getAuthenticationToken());
        this.auth.setStatusListener(this.getStatusListener());
        scomp.setExpandHorizontal(true);
        scomp.setExpandVertical(true);
        scomp.setContent((Control)authGroup);
        scomp.setMinSize(authGroup.computeSize(-1, -1));
        return scomp;
    }

    protected void okPressed() {
        if (this.enableMessageExp.getSelection()) {
            this.policyType.setMessageExpiryTime(this.messageExpirationTime.getText().trim());
        } else {
            this.policyType.setMessageExpiryTime(null);
        }
        if (this.digitalSignature != null) {
            if (this.OutboundSign != null) {
                this.SignOutbound = (SignatureSecurityBindingObject)this.OutboundSign.getSecurityObject();
                this.SignOutbound.setTransformAlgorithm(this.transformAlgorithmOutbound.getText());
                this.SignOutbound.getGeneratorTimestamp().setValue(this.signOutTimestamp.getSelection());
                this.SignOutbound.getGeneratorNonce().setValue(this.signOutNonce.getSelection());
                this.SignOutbound.setOrder(this.signOrder.getText());
            }
            this.policyType.setSignOutbound(this.SignOutbound);
            if (this.InboundSign != null) {
                this.SignInbound = (SignatureSecurityBindingObject)this.InboundSign.getSecurityObject();
                this.SignInbound.setTransformAlgorithm(this.transformAlgorithmInbound.getText());
                this.SignInbound.getConsumerTimestamp().setValue(this.signInTimestamp.getSelection());
                this.SignInbound.getConsumerNonce().setValue(this.signInNonce.getSelection());
                if (this.trustAnyCertificate.getSelection()) {
                    this.SignInbound.setKeyStore(null);
                    this.policyType.setCertificatePath(null);
                } else {
                    this.policyType.setCertificatePath(this.certificatePath.getText());
                }
            }
            this.policyType.setSignInbound(this.SignInbound);
        }
        if (this.xmlEncryption != null) {
            if (this.OutboundEnc != null) {
                this.EncOutbound = (EncryptionOutBoundSecurityBindingObject)this.OutboundEnc.getSecurityObject();
                this.EncOutbound.setOrder(this.encOrder.getText());
                this.EncOutbound.getGeneratorTimestamp().setValue(this.encOutTimestamp.getSelection());
                this.EncOutbound.getGeneratorNonce().setValue(this.encOutNonce.getSelection());
                this.EncOutbound.getEnableMTOM().setValue(this.enableMTOM.getSelection());
                this.EncOutbound.getEncryptedHeader().setValue(this.enableEncHeader.getSelection());
            }
            this.policyType.setEncOutbound(this.EncOutbound);
            if (this.InboundEnc != null) {
                this.EncInbound = this.InboundEnc.getSecurityObject();
                this.EncInbound.getConsumerTimestamp().setValue(this.encInTimestamp.getSelection());
                this.EncInbound.getConsumerNonce().setValue(this.encInNonce.getSelection());
            }
            this.policyType.setEncInbound(this.EncInbound);
        }
        if (this.authentication != null) {
            this.policyType.setAuthenticationToken(this.auth.getToken());
        }
        super.okPressed();
    }

    protected IStatus getStatus() {
        MultiStatus status = new MultiStatus("com.ibm.ast.ws.was61.policyset.ui", 0, "", null);
        if (this.enableMessageExp.getSelection()) {
            try {
                Integer timeDouble = new Integer(this.messageExpirationTime.getText());
                if (timeDouble <= 0) {
                    status.add(StatusUtils.errorStatus((String)Activator.getMessage("ERROR_INVALID_MESSAGE_EXP")));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.add(StatusUtils.errorStatus((String)Activator.getMessage("ERROR_INVALID_MESSAGE_EXP")));
            }
        }
        if (this.digitalSignature != null && (this.first || this.tabFolder.getSelectionIndex() == this.tabFolder.indexOf(this.digitalSignature))) {
            boolean imageStatus = true;
            if (!(this.SignOutbound == null || this.SignOutbound.getKeyStore() != null && this.SignOutbound.getKeyStore().isValid())) {
                status.add(StatusUtils.errorStatus((String)Activator.getMessage("ERROR_MISSING_OUTBOUND_KEYSTORE", new String[]{Activator.getMessage("DIGITAL_SIGNATURE")})));
                imageStatus = false;
            }
            if (!(this.SignInbound == null || this.trustAnyCertificate.getSelection() || this.SignInbound.getKeyStore() != null && this.SignInbound.getKeyStore().isValid())) {
                status.add(StatusUtils.errorStatus((String)Activator.getMessage("ERROR_MISSING_INBOUND_KEYSTORE", new String[]{Activator.getMessage("DIGITAL_SIGNATURE")})));
                imageStatus = false;
            }
            this.digitalSignature.setImage(imageStatus ? null : JFaceResources.getImage((String)"dialog_message_error_image"));
        }
        if (this.xmlEncryption != null && (this.first || this.tabFolder.getSelectionIndex() == this.tabFolder.indexOf(this.xmlEncryption))) {
            boolean imageStatus = true;
            if (this.EncOutbound != null && !this.EncOutbound.getKeyStore().isValid()) {
                status.add(StatusUtils.errorStatus((String)Activator.getMessage("ERROR_MISSING_OUTBOUND_KEYSTORE", new String[]{Activator.getMessage("XML_ENCRYPTION")})));
                imageStatus = false;
            }
            if (this.EncInbound != null && !this.EncInbound.getKeyStore().isValid()) {
                status.add(StatusUtils.errorStatus((String)Activator.getMessage("ERROR_MISSING_INBOUND_KEYSTORE", new String[]{Activator.getMessage("XML_ENCRYPTION")})));
                imageStatus = false;
            }
            this.xmlEncryption.setImage(imageStatus ? null : JFaceResources.getImage((String)"dialog_message_error_image"));
        }
        if (this.authentication != null && (this.first || this.tabFolder.getSelectionIndex() == this.tabFolder.indexOf(this.authentication))) {
            status.add((IStatus)this.getContextStatus(this.auth.getStatus(), this.getMessage("AUTHENTICATION_CONFIG")));
            boolean imageStatus = this.auth.getStatus().getSeverity() != 4;
            this.authentication.setImage(imageStatus ? null : JFaceResources.getImage((String)"dialog_message_error_image"));
        }
        this.first = false;
        return status;
    }

    private class TokenComposite
    extends SimpleWidgetDataContributor {
        protected UIUtils uiUtils = Activator.getUiUtils();
        protected String groupName;
        protected String groupTooltip;
        protected String groupINFOPOP;
        protected Composite parent_;
        protected Text tokenType;
        protected Combo callbackHandler;
        protected SecurityBindingObject securityObject;
        protected String INFOPOP_WSS_KEYINF_DIG_COMBO = "WSS0017";
        protected Combo keyInfoType;
        protected Combo jaas;
        protected Group tokenComposite;

        public TokenComposite(Composite parent, String name, String tooltip, String info) {
            this.groupName = name;
            this.groupTooltip = tooltip;
            this.groupINFOPOP = info;
            this.addControls(parent, null);
        }

        public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
            this.parent_ = parent;
            new Label(this.parent_, 256);
            this.tokenComposite = this.uiUtils.createGroup(parent, this.groupName, this.groupTooltip, this.groupINFOPOP, 2, -1, -1);
            this.tokenType = this.uiUtils.createText((Composite)this.tokenComposite, this.getMessage("LABEL_TOKEN_TYPE"), null, null, 2056);
            this.callbackHandler = this.uiUtils.createCombo((Composite)this.tokenComposite, this.getMessage("LABEL_CALLBACK_HANDLER"), null, null, 2048);
            this.jaas = this.uiUtils.createCombo((Composite)this.tokenComposite, this.getMessage("LABEL_JAAS_LOGIN"), null, null, 2048);
            this.keyInfoType = this.uiUtils.createCombo((Composite)this.tokenComposite, this.getMessage("LABEL_KEY_INFO_TYPE"), null, null, 2056);
            return this;
        }

        protected SecurityBindingObject getSecurityObject() {
            this.securityObject.getToken().setKeyInfoType(this.keyInfoType.getText());
            this.securityObject.getToken().setCallBackHandler(this.callbackHandler.getText());
            this.securityObject.getToken().setJAASConfig(this.jaas.getText());
            return this.securityObject;
        }

        public IStatus getStatus() {
            MultiStatus status = new MultiStatus("com.ibm.ast.ws.was61.policyset.ui", 0, "", null);
            return status;
        }

        protected String getMessage(String key) {
            return Activator.getMessage(key);
        }

        public void setSecurityObject(SecurityBindingObject securityObject) {
            this.securityObject = securityObject;
            ProtectionToken token = securityObject.getToken();
            this.tokenType.setText(token.getTokenName());
            this.callbackHandler.setItems(token.getCallBackHandlers());
            if (this.callbackHandler.indexOf(token.getCallBackHandler()) == -1) {
                this.callbackHandler.add(token.getCallBackHandler());
            }
            this.callbackHandler.setText(token.getCallBackHandler());
            this.jaas.setItems(token.getJAASConfigs());
            if (this.jaas.indexOf(token.getJAASConfig()) == -1) {
                this.jaas.add(token.getJAASConfig());
            }
            this.jaas.setText(token.getJAASConfig());
            this.keyInfoType.setItems(token.getKeyInfoTypes());
            this.keyInfoType.setText(token.getKeyInfoType(true));
        }

        public Group getMainComposite() {
            return this.tokenComposite;
        }
    }
}

