/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.command;

import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public abstract class ReadPolicyAttachmentsCommand
extends AbstractDataModelOperation {
    private IPath attachmentFileLocation;
    private String pattern;
    private PolicySetReference policySetReference = null;

    protected abstract String policySetAttachmentFileName();

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        try {
            PolicySetAttachment policySetAttachment = ReadPolicyAttachmentsCommand.readExistingPolicySetAttachment(this.attachmentFileLocation, this.policySetAttachmentFileName());
            if (policySetAttachment != null) {
                this.policySetReference = ReadPolicyAttachmentsCommand.findExistingServiceReference(policySetAttachment, this.pattern);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    public static PolicySetAttachment readExistingPolicySetAttachment(IPath attachmentFileLocation, String attachmentFileName) throws Exception {
        IPath fileLocation = attachmentFileLocation.addTrailingSeparator().append(attachmentFileName);
        if (fileLocation.toFile().exists()) {
            JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200605.policyset_attachment");
            Unmarshaller u = jc.createUnmarshaller();
            return (PolicySetAttachment)u.unmarshal((InputStream)new FileInputStream(fileLocation.toFile()));
        }
        return null;
    }

    public static PolicySetReference findExistingServiceReference(PolicySetAttachment attachment, String resourcePattern) {
        List references = attachment.getPolicySetReference();
        int i = 0;
        while (i < references.size()) {
            PolicySetReference reference = (PolicySetReference)references.get(i);
            List resources = reference.getResource();
            for (Resource resource : resources) {
                if (!resource.getPattern().equals(resourcePattern)) continue;
                return reference;
            }
            ++i;
        }
        return null;
    }

    public void setAttachmentFileLocation(IPath attachmentFileLocation) {
        this.attachmentFileLocation = attachmentFileLocation;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public PolicySetReference getPolicySetReference() {
        return this.policySetReference;
    }
}

