/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.ui.endptenabler.widget;

import com.ibm.ast.ws.ui.endptenabler.util.JMSUtil;
import com.ibm.ast.ws.ui.endptenabler.widget.EarProjectRouterCreationWidget;
import com.ibm.ast.ws.ui.messages.Messages;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class EjbProjectRouterCreationWidget
extends SimpleWidgetDataContributor
implements Listener {
    private IProject project;
    private Listener statusListener;
    private final String pluginId = "com.ibm.ast.ws.ui";
    private Button httpBindingButton;
    private String INFOPOP_BINDING_BUTTON_HTTP = "WSEE0001";
    private Button jmsBindingButton;
    private String INFOPOP_BINDING_BUTTON_JMS = "WSEE0002";
    private Label httpRouterProjectLabel;
    private Combo httpRouterProjectCombo;
    private String INFOPOP_COMBO_ROUTER_HTTP = "WSEE0011";
    private Label jmsRouterProjectLabel;
    private Combo jmsRouterProjectCombo;
    private String INFOPOP_COMBO_ROUTER_JMS = "WSEE0021";
    private Label jmsDestinationTypeLabel;
    private Combo jmsDestinationTypeCombo;
    private final String INFOPOP_COMBO_DEST_TYPE = "WSEE0022";
    private Label mdbDeploymentMechanismLabel;
    private Combo mdbDeploymentMechanism;
    private final String INFOPOP_PBJMS_MDB_DEPLOYMENT = "WSEE0023";
    private Label activationSpecLabel;
    private Text activationSpecText;
    private final String INFOPOP_PBJMS_ACTIVATIONSPEC = "WSEE0024";
    private Label listenerInputPortLabel;
    private Text listenerInputPortText;
    private final String INFOPOP_PBJMS_PORT = "WSEE0025";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener = statusListener;
        UIUtils uiUtils = new UIUtils("com.ibm.ast.ws.ui");
        TextBoxModifyListener modListener = new TextBoxModifyListener();
        BindingSelectionListener bndSelListener = new BindingSelectionListener();
        Group group = uiUtils.createGroup(parent, Messages.LABEL_BINDING_SELECTION, Messages.TOOLTIP_BINDING_SELECTION, null);
        Composite composite = uiUtils.createComposite((Composite)group, 2);
        this.httpBindingButton = uiUtils.createCheckbox(composite, Messages.LABEL_HTTP_BINDING, Messages.TOOLTIP_HTTP_BINDING, this.INFOPOP_BINDING_BUTTON_HTTP);
        this.httpBindingButton.addSelectionListener((SelectionListener)bndSelListener);
        this.jmsBindingButton = uiUtils.createCheckbox(composite, Messages.LABEL_JMS_BINDING, Messages.TOOLTIP_JMS_BINDING, this.INFOPOP_BINDING_BUTTON_JMS);
        this.jmsBindingButton.addSelectionListener((SelectionListener)bndSelListener);
        this.httpBindingButton.setSelection(true);
        Group httpGroup = uiUtils.createGroup(parent, Messages.LABEL_HTTP_BINDING, Messages.TOOLTIP_HTTP_BINDING, null);
        composite = uiUtils.createComposite((Composite)httpGroup, 2);
        this.httpRouterProjectLabel = this.createLabel(composite, Messages.LABEL_HTTP_ROUTER_NAME, Messages.TOOLTIP_HTTP_ROUTER_NAME);
        this.httpRouterProjectCombo = uiUtils.createCombo(composite, null, Messages.TOOLTIP_HTTP_ROUTER_NAME, this.INFOPOP_COMBO_ROUTER_HTTP, 2052);
        this.httpRouterProjectCombo.addModifyListener((ModifyListener)modListener);
        new Label(parent, 256);
        Group jmsGroup = uiUtils.createGroup(parent, Messages.LABEL_JMS_BINDING, Messages.TOOLTIP_JMS_BINDING, null);
        composite = uiUtils.createComposite((Composite)jmsGroup, 2);
        this.jmsRouterProjectLabel = this.createLabel(composite, Messages.LABEL_JMS_ROUTER_NAME, Messages.TOOLTIP_JMS_ROUTER_NAME);
        this.jmsRouterProjectCombo = uiUtils.createCombo(composite, null, Messages.TOOLTIP_JMS_ROUTER_NAME, this.INFOPOP_COMBO_ROUTER_JMS, 2052);
        this.jmsRouterProjectCombo.addModifyListener((ModifyListener)modListener);
        this.jmsDestinationTypeLabel = this.createLabel(composite, Messages.LABEL_JMS_DESTINATION_TYPE, Messages.TOOLTIP_JMS_DESTINATION_TYPE);
        this.jmsDestinationTypeCombo = uiUtils.createCombo(composite, null, Messages.TOOLTIP_JMS_DESTINATION_TYPE, "WSEE0022", 2060);
        this.jmsDestinationTypeCombo.add(Messages.COMBO_DESTINATION_QUEUE);
        this.jmsDestinationTypeCombo.add(Messages.COMBO_DESTINATION_TOPIC);
        this.jmsDestinationTypeCombo.select(0);
        this.mdbDeploymentMechanismLabel = this.createLabel(composite, Messages.LABEL_JMS_MDB_DEPLOYMENT, Messages.TOOLTIP_JMS_COMBO_MDB_DEPLOYMENT);
        this.mdbDeploymentMechanism = uiUtils.createCombo(composite, null, Messages.TOOLTIP_JMS_COMBO_MDB_DEPLOYMENT, "WSEE0023", 2060);
        this.mdbDeploymentMechanism.add(Messages.COMBO_DESINATION_ACTIVATIONSPEC);
        this.mdbDeploymentMechanism.add(Messages.COMBO_DESINATION_LISTENERPORT);
        this.mdbDeploymentMechanism.select(0);
        this.mdbDeploymentMechanism.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                EjbProjectRouterCreationWidget.this.handleMDBDeploymentEvent();
            }
        });
        this.activationSpecLabel = this.createLabel(composite, Messages.LABEL_JMS_ACTIVATIONSPECNAME, Messages.TOOLTIP_JMS_ACTIVATIONSPECNAME);
        this.activationSpecText = uiUtils.createText(composite, null, Messages.TOOLTIP_JMS_ACTIVATIONSPECNAME, "WSEE0024", 2052);
        this.activationSpecText.addModifyListener((ModifyListener)modListener);
        this.listenerInputPortLabel = this.createLabel(composite, Messages.LABEL_JMS_LISTENERNAME, Messages.TOOLTIP_JMS_LISTENERNAME);
        this.listenerInputPortText = uiUtils.createText(composite, null, Messages.TOOLTIP_JMS_LISTENERNAME, "WSEE0025", 2052);
        this.listenerInputPortText.addModifyListener((ModifyListener)modListener);
        this.handleBindingSelectionEvent();
        return this;
    }

    public void handleEvent(Event event) {
    }

    public IStatus getStatus() {
        return this.verifyAllFields();
    }

    private void handleMDBDeploymentEvent() {
        this.mdbDeploymentMechanism.setEnabled(this.getJmsBinding());
        this.mdbDeploymentMechanismLabel.setEnabled(this.getJmsBinding());
        this.jmsDestinationTypeCombo.setEnabled(this.getJmsBinding());
        this.jmsDestinationTypeLabel.setEnabled(this.getJmsBinding());
        if (!this.getJmsBinding()) {
            this.activationSpecText.setEnabled(false);
            this.activationSpecLabel.setEnabled(false);
            this.listenerInputPortText.setEnabled(false);
            this.listenerInputPortLabel.setEnabled(false);
        } else {
            this.activationSpecText.setEnabled(this.mdbDeploymentMechanism.getSelectionIndex() == 0);
            this.activationSpecLabel.setEnabled(this.mdbDeploymentMechanism.getSelectionIndex() == 0);
            this.listenerInputPortText.setEnabled(this.mdbDeploymentMechanism.getSelectionIndex() != 0);
            this.listenerInputPortLabel.setEnabled(this.mdbDeploymentMechanism.getSelectionIndex() != 0);
        }
        this.statusListener.handleEvent(null);
    }

    private IStatus verifyAllFields() {
        if (!this.getHttpBinding() && !this.getJmsBinding()) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_BINDING_NOT_SELECTED);
        }
        if (this.getHttpBinding() && (this.getHttpRouterProjectName() == null || this.getHttpRouterProjectName().trim().length() == 0)) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_ROUTER_NAME_NULL);
        }
        if (this.getJmsBinding() && (this.getJmsRouterProjectName() == null || this.getJmsRouterProjectName().trim().length() == 0)) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_ROUTER_NAME_NULL);
        }
        if (this.getJmsBinding()) {
            if (this.mdbDeploymentMechanism.getSelectionIndex() == 0) {
                if (this.activationSpecText.getText() == null || this.activationSpecText.getText().trim().length() == 0) {
                    return StatusUtils.errorStatus((String)Messages.MSG_ERROR_JMS_ACTIVATIONSPEC_NULL);
                }
            } else if (this.mdbDeploymentMechanism.getSelectionIndex() == 1 && (this.listenerInputPortText.getText() == null || this.listenerInputPortText.getText().trim().length() == 0)) {
                return StatusUtils.errorStatus((String)Messages.MSG_ERROR_JMS_LISTENERPORT_NULL);
            }
        }
        return Status.OK_STATUS;
    }

    private void handleBindingSelectionEvent() {
        this.httpRouterProjectCombo.setEnabled(this.httpBindingButton.getSelection());
        this.httpRouterProjectLabel.setEnabled(this.httpBindingButton.getSelection());
        this.jmsRouterProjectCombo.setEnabled(this.jmsBindingButton.getSelection());
        this.jmsRouterProjectLabel.setEnabled(this.jmsBindingButton.getSelection());
        this.handleMDBDeploymentEvent();
    }

    private Label createLabel(Composite parent, String labelName, String tooltip) {
        Label label = new Label(parent, 64);
        label.setText(labelName);
        label.setToolTipText(tooltip);
        return label;
    }

    public boolean getHttpBinding() {
        if (this.httpBindingButton == null) {
            return false;
        }
        return this.httpBindingButton.getSelection();
    }

    public boolean getJmsBinding() {
        if (this.jmsBindingButton == null) {
            return false;
        }
        return this.jmsBindingButton.getSelection();
    }

    public String getHttpRouterProjectName() {
        return this.httpRouterProjectCombo.getText();
    }

    public String getJmsRouterProjectName() {
        return this.jmsRouterProjectCombo.getText();
    }

    public JMSUtil.DESTINATION_TYPE getDestinationType() {
        if (this.jmsDestinationTypeCombo == null) {
            return null;
        }
        if (this.jmsDestinationTypeCombo.getSelectionIndex() == 0) {
            return JMSUtil.DESTINATION_TYPE.QUEUE;
        }
        return JMSUtil.DESTINATION_TYPE.TOPIC;
    }

    public JMSUtil.DEPLOYMENT_MECHANISM getDeploymentMechanism() {
        if (this.mdbDeploymentMechanism == null) {
            return null;
        }
        if (this.mdbDeploymentMechanism.getSelectionIndex() == 0) {
            return JMSUtil.DEPLOYMENT_MECHANISM.ACTIVATION_SPEC;
        }
        return JMSUtil.DEPLOYMENT_MECHANISM.LISTENER_PORT;
    }

    public String getMdbActivateName() {
        if (this.mdbDeploymentMechanism != null) {
            if (this.mdbDeploymentMechanism.getSelectionIndex() == 0) {
                return this.activationSpecText.getText();
            }
            return this.listenerInputPortText.getText();
        }
        return null;
    }

    public void setProject(IProject project) {
        this.project = project;
        if (project != null) {
            this.httpRouterProjectCombo.setText(String.valueOf(project.getName()) + EarProjectRouterCreationWidget.HTTP_ROUTER_SUFFIX);
            this.jmsRouterProjectCombo.setText(String.valueOf(project.getName()) + EarProjectRouterCreationWidget.JMS_ROUTER_SUFFIX);
        }
    }

    private class BindingSelectionListener
    extends SelectionAdapter {
        private BindingSelectionListener() {
        }

        public void widgetSelected(SelectionEvent evt) {
            EjbProjectRouterCreationWidget.this.handleBindingSelectionEvent();
            EjbProjectRouterCreationWidget.this.statusListener.handleEvent(null);
        }
    }

    private class TextBoxModifyListener
    implements ModifyListener {
        private TextBoxModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            EjbProjectRouterCreationWidget.this.statusListener.handleEvent(null);
        }
    }
}

