/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.ui.endptenabler.command;

import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.impl.WsbndFactoryImpl;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class UpdateIBMWebServicesBndCommand
extends AbstractDataModelOperation {
    private IProject ejbProject;
    private String httpRouterProjectName;
    private String jmsRouterProjectName;
    private boolean httpBinding;
    private boolean jmsBinding;

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        WsbndArtifactEdit artifactEdit = null;
        try {
            try {
                artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForWrite((IProject)this.ejbProject);
                WSBinding wsbnd = artifactEdit.getWSBinding();
                EList routers = wsbnd.getRouterModules();
                this.addAndReplaceExistingRouter(routers, String.valueOf(this.httpRouterProjectName) + ".war", String.valueOf(this.jmsRouterProjectName) + ".jar");
                artifactEdit.saveIfNecessary(monitor);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return Status.OK_STATUS;
    }

    private void addAndReplaceExistingRouter(EList routers, String httpFileName, String jmsFileName) {
        RouterModule newRouter;
        boolean foundHttpRouter = false;
        boolean foundJmsRouter = false;
        int i = 0;
        while (i < routers.size()) {
            RouterModule router = (RouterModule)routers.get(i);
            if (this.httpBinding && httpFileName != null && httpFileName.equals(router.getName()) && "http".equals(router.getTransport())) {
                foundHttpRouter = true;
            } else if (this.jmsBinding && jmsFileName != null && jmsFileName.equals(router.getName()) && "jms".equals(router.getTransport())) {
                foundJmsRouter = true;
            } else if (this.httpBinding && httpFileName != null && httpFileName.length() > 0 && "http".equals(router.getTransport())) {
                router.setName(httpFileName);
                foundHttpRouter = true;
            } else if (this.jmsBinding && jmsFileName != null && jmsFileName.length() > 0 && "jms".equals(router.getTransport())) {
                router.setName(jmsFileName);
                foundJmsRouter = true;
            }
            ++i;
        }
        if (this.httpBinding && !foundHttpRouter && httpFileName != null && httpFileName.length() > 0) {
            WsbndFactoryImpl wsbndfactory = new WsbndFactoryImpl();
            newRouter = wsbndfactory.createRouterModule();
            newRouter.setName(httpFileName);
            newRouter.setTransport("http");
            routers.add((Object)newRouter);
        }
        if (this.jmsBinding && !foundJmsRouter && jmsFileName != null && jmsFileName.length() > 0) {
            WsbndFactoryImpl wsbndfactory = new WsbndFactoryImpl();
            newRouter = wsbndfactory.createRouterModule();
            newRouter.setName(jmsFileName);
            newRouter.setTransport("jms");
            routers.add((Object)newRouter);
        }
    }

    public void setEjbProject(IProject ejbProject) {
        this.ejbProject = ejbProject;
    }

    public void setHttpRouterProjectName(String httpRouterProjectName) {
        this.httpRouterProjectName = httpRouterProjectName;
    }

    public void setJmsRouterProjectName(String jmsRouterProjectName) {
        this.jmsRouterProjectName = jmsRouterProjectName;
    }

    public void setHttpBinding(boolean httpBinding) {
        this.httpBinding = httpBinding;
    }

    public void setJmsBinding(boolean jmsBinding) {
        this.jmsBinding = jmsBinding;
    }
}

