/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.ui.endptenabler.command;

import com.ibm.ast.ws.ui.endptenabler.command.CreateRouterProjectCommand;
import com.ibm.ast.ws.ui.endptenabler.command.UpdateHttpRouterCommand;
import com.ibm.ast.ws.ui.endptenabler.command.UpdateIBMWebServicesBndCommand;
import com.ibm.ast.ws.ui.endptenabler.command.UpdateJMSRouterCommand;
import com.ibm.ast.ws.ui.endptenabler.util.JMSUtil;
import com.ibm.ccl.ws.finder.core.WSInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessEARRouterProjectCommand
extends AbstractDataModelOperation {
    private IProject earProject;
    private List<IProject> webServiceEnabledEJBProjects = new ArrayList<IProject>();
    private HashMap<String, List<WSInfo>> jaxrpcWSInfosByProject = new HashMap();
    private HashMap<String, List<WSInfo>> jaxwsWSInfosByProject = new HashMap();
    private boolean httpBinding = false;
    private boolean jmsBinding = false;
    private String httpRouterProjectSuffix;
    private String jmsRouterProjectSuffix;
    private JMSUtil.DESTINATION_TYPE destinationType = JMSUtil.DESTINATION_TYPE.QUEUE;
    private JMSUtil.DEPLOYMENT_MECHANISM deploymentMechanism = JMSUtil.DEPLOYMENT_MECHANISM.ACTIVATION_SPEC;
    private String mdbActivateName;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        for (IProject ejbProject : this.webServiceEnabledEJBProjects) {
            IStatus status = this.createRouterProject(monitor, adaptable, ejbProject);
            if (status.getSeverity() == 4) {
                return status;
            }
            status = this.updateHttpRouter(monitor, adaptable, ejbProject);
            if (status.getSeverity() == 4) {
                return status;
            }
            status = this.updateJmsRouter(monitor, adaptable, ejbProject);
            if (status.getSeverity() == 4) {
                return status;
            }
            status = this.updateIBMWSBndXMI(monitor, adaptable, ejbProject);
            if (status.getSeverity() != 4) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    private IStatus createRouterProject(IProgressMonitor monitor, IAdaptable adaptable, IProject ejbProject) {
        CreateRouterProjectCommand createRouterCmd = new CreateRouterProjectCommand();
        createRouterCmd.setEnvironment(super.getEnvironment());
        createRouterCmd.setHttpBinding(this.httpBinding);
        createRouterCmd.setJmsBinding(this.jmsBinding);
        createRouterCmd.setJmsRouterProjectName(String.valueOf(ejbProject.getName()) + this.jmsRouterProjectSuffix);
        createRouterCmd.setHttpRouterProjectName(String.valueOf(ejbProject.getName()) + this.httpRouterProjectSuffix);
        createRouterCmd.setEarProjectName(this.earProject.getName());
        createRouterCmd.setProject(ejbProject);
        return createRouterCmd.execute(monitor, adaptable);
    }

    private IStatus updateHttpRouter(IProgressMonitor monitor, IAdaptable adaptable, IProject ejbProject) {
        UpdateHttpRouterCommand updateRouterCmd = new UpdateHttpRouterCommand();
        updateRouterCmd.setEnvironment(super.getEnvironment());
        updateRouterCmd.setHttpBinding(this.httpBinding);
        updateRouterCmd.setHttpRouterProjectName(String.valueOf(ejbProject.getName()) + this.httpRouterProjectSuffix);
        updateRouterCmd.setJaxrpcWsInfosInProject(this.jaxrpcWSInfosByProject.get(ejbProject.getName()));
        updateRouterCmd.setJaxwsWsInfosInProject(this.jaxwsWSInfosByProject.get(ejbProject.getName()));
        return updateRouterCmd.execute(monitor, adaptable);
    }

    private IStatus updateJmsRouter(IProgressMonitor monitor, IAdaptable adaptable, IProject ejbProject) {
        UpdateJMSRouterCommand updateRouterCmd = new UpdateJMSRouterCommand();
        updateRouterCmd.setEnvironment(super.getEnvironment());
        updateRouterCmd.setJmsBinding(this.jmsBinding);
        updateRouterCmd.setJmsRouterProjectName(String.valueOf(ejbProject.getName()) + this.jmsRouterProjectSuffix);
        updateRouterCmd.setDestinationType(this.destinationType);
        return updateRouterCmd.execute(monitor, adaptable);
    }

    private IStatus updateIBMWSBndXMI(IProgressMonitor monitor, IAdaptable adaptable, IProject ejbProject) {
        UpdateIBMWebServicesBndCommand updateWsBndCmd = new UpdateIBMWebServicesBndCommand();
        updateWsBndCmd.setEnvironment(super.getEnvironment());
        updateWsBndCmd.setHttpBinding(this.httpBinding);
        updateWsBndCmd.setJmsBinding(this.jmsBinding);
        updateWsBndCmd.setJmsRouterProjectName(String.valueOf(ejbProject.getName()) + this.jmsRouterProjectSuffix);
        updateWsBndCmd.setHttpRouterProjectName(String.valueOf(ejbProject.getName()) + this.httpRouterProjectSuffix);
        updateWsBndCmd.setEjbProject(ejbProject);
        return updateWsBndCmd.execute(monitor, adaptable);
    }

    public void setWebServiceEnabledEJBProjects(List<IProject> webServiceEnabledEJBProjects) {
        this.webServiceEnabledEJBProjects = webServiceEnabledEJBProjects;
    }

    public void setJaxrpcWSInfosByProject(HashMap<String, List<WSInfo>> jaxrpcWSInfosByProject) {
        this.jaxrpcWSInfosByProject = jaxrpcWSInfosByProject;
    }

    public void setJaxwsWSInfosByProject(HashMap<String, List<WSInfo>> jaxwsWSInfosByProject) {
        this.jaxwsWSInfosByProject = jaxwsWSInfosByProject;
    }

    public void setHttpBinding(boolean httpBinding) {
        this.httpBinding = httpBinding;
    }

    public void setJmsBinding(boolean jmsBinding) {
        this.jmsBinding = jmsBinding;
    }

    public void setHttpRouterProjectSuffix(String httpRouterProjectSuffix) {
        this.httpRouterProjectSuffix = httpRouterProjectSuffix;
    }

    public void setJmsRouterProjectSuffix(String jmsRouterProjectSuffix) {
        this.jmsRouterProjectSuffix = jmsRouterProjectSuffix;
    }

    public void setEarProject(IProject earProject) {
        this.earProject = earProject;
    }

    public void setDestinationType(JMSUtil.DESTINATION_TYPE destinationType) {
        if (destinationType != null) {
            this.destinationType = destinationType;
        }
    }

    public void setDeploymentMechanism(JMSUtil.DEPLOYMENT_MECHANISM deploymentMechanism) {
        this.deploymentMechanism = deploymentMechanism;
    }

    public void setMdbActivateName(String mdbActivateName) {
        this.mdbActivateName = mdbActivateName;
    }
}

