/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.ui.endptenabler.command;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.command.common.AssociateModuleWithEARCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateFacetedProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;

public class CreateRouterProjectCommand
extends AbstractDataModelOperation {
    private String earProjectName;
    private IProject project;
    private String earFacetVersion = null;
    private String wasFacetVersion = null;
    private String httpRouterProjectName;
    private String jmsRouterProjectName;
    private boolean httpBinding = false;
    private boolean jmsBinding = false;
    private String serverInstanceId;
    private String serverFactoryId;

    private void init() {
        IRuntime rt = null;
        try {
            IFacetedProject fp = ProjectFacetsManager.create((IProject)this.project);
            rt = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)fp.getPrimaryRuntime());
        }
        catch (Exception exception) {}
        if (rt != null) {
            IServer[] servers;
            IServerType[] serverTypes;
            String rtTypeId = rt.getRuntimeType().getId();
            IServerType[] iServerTypeArray = serverTypes = ServerCore.getServerTypes();
            int n = serverTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IServerType serverType = iServerTypeArray[n2];
                if (serverType.getRuntimeType().getId().equals(rtTypeId)) {
                    this.serverFactoryId = serverType.getId();
                    break;
                }
                ++n2;
            }
            String rtId = rt.getId();
            IServer[] iServerArray = servers = ServerCore.getServers();
            int n3 = servers.length;
            int n4 = 0;
            while (n4 < n3) {
                IServer server = iServerArray[n4];
                if (server.getRuntime().getId().equals(rtId)) {
                    this.serverInstanceId = server.getId();
                    break;
                }
                ++n4;
            }
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IProject jmsProject;
        AssociateModuleWithEARCommand associateEarCmd;
        IEnvironment env;
        IWorkspaceRoot root;
        IProject httpProject;
        this.init();
        if (this.httpBinding && !(httpProject = (root = ResourcesPlugin.getWorkspace().getRoot()).getProject(this.httpRouterProjectName)).exists()) {
            env = super.getEnvironment();
            this.createWebProject(env, monitor, adaptable);
            if (this.earProjectName != null) {
                associateEarCmd = new AssociateModuleWithEARCommand();
                associateEarCmd.setEnvironment(super.getEnvironment());
                associateEarCmd.setEARProject(this.earProjectName);
                associateEarCmd.setProject(this.httpRouterProjectName);
                associateEarCmd.execute(monitor, adaptable);
            }
        }
        if (this.jmsBinding && !(jmsProject = (root = ResourcesPlugin.getWorkspace().getRoot()).getProject(this.jmsRouterProjectName)).exists()) {
            env = super.getEnvironment();
            this.createEjbProject(env, monitor, adaptable);
            if (this.earProjectName != null) {
                associateEarCmd = new AssociateModuleWithEARCommand();
                associateEarCmd.setEnvironment(super.getEnvironment());
                associateEarCmd.setEARProject(this.earProjectName);
                associateEarCmd.setProject(this.jmsRouterProjectName);
                associateEarCmd.execute(monitor, adaptable);
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus createWebProject(IEnvironment env, IProgressMonitor monitor, IAdaptable adaptable) {
        CreateFacetedProjectCommand createProjectCmd = new CreateFacetedProjectCommand();
        createProjectCmd.setEnvironment(super.getEnvironment());
        createProjectCmd.setTemplateId("template.jst.web");
        createProjectCmd.setServerFactoryId(this.serverFactoryId);
        createProjectCmd.setServerInstanceId(this.serverInstanceId);
        createProjectCmd.setRequiredFacetVersions(this.getRequiredWebExtendedFacetVersion());
        createProjectCmd.setProjectName(this.httpRouterProjectName);
        IStatus status = createProjectCmd.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
        }
        return Status.OK_STATUS;
    }

    private IStatus createEjbProject(IEnvironment env, IProgressMonitor monitor, IAdaptable adaptable) {
        CreateFacetedProjectCommand createProjectCmd = new CreateFacetedProjectCommand();
        createProjectCmd.setEnvironment(super.getEnvironment());
        createProjectCmd.setTemplateId("template.jst.ejb");
        createProjectCmd.setServerFactoryId(this.serverFactoryId);
        createProjectCmd.setServerInstanceId(this.serverInstanceId);
        createProjectCmd.setRequiredFacetVersions(this.getRequiredEjbExtendedFacetVersion());
        createProjectCmd.setProjectName(this.jmsRouterProjectName);
        IStatus status = createProjectCmd.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
        }
        return Status.OK_STATUS;
    }

    private RequiredFacetVersion[] getRequiredWebExtendedFacetVersion() {
        RequiredFacetVersion reqFacetVersion1 = this.getRequiredFacetVersion("jst.web", this.getWebProjectVersionFromEar());
        RequiredFacetVersion reqFacetVersion2 = this.getRequiredFacetVersion("com.ibm.websphere.coexistence.web", this.getWasProjectVersion());
        RequiredFacetVersion reqFacetVersion3 = this.getRequiredFacetVersion("com.ibm.websphere.extended.web", this.getWasProjectVersion());
        return new RequiredFacetVersion[]{reqFacetVersion1, reqFacetVersion2, reqFacetVersion3};
    }

    private RequiredFacetVersion[] getRequiredEjbExtendedFacetVersion() {
        RequiredFacetVersion reqFacetVersion1 = this.getRequiredFacetVersion("jst.ejb", this.getEjbProjectVersionFromEar());
        RequiredFacetVersion reqFacetVersion2 = this.getRequiredFacetVersion("com.ibm.websphere.extended.ejb", this.getWasProjectVersion());
        return new RequiredFacetVersion[]{reqFacetVersion1, reqFacetVersion2};
    }

    private RequiredFacetVersion getRequiredFacetVersion(String facetName, String facetVersion) {
        IProjectFacet projectFacetJava = ProjectFacetsManager.getProjectFacet((String)facetName);
        IProjectFacetVersion projJavaFacetVersion = projectFacetJava.getVersion(facetVersion);
        RequiredFacetVersion reqFacetVersion = new RequiredFacetVersion();
        reqFacetVersion.setAllowNewer(false);
        reqFacetVersion.setProjectFacetVersion(projJavaFacetVersion);
        return reqFacetVersion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getJavaEEVersionFromEJB() {
        try {
            IProjectFacetVersion facetVersion;
            IFacetedProject fProject = ProjectFacetsManager.create((IProject)this.project);
            Set projFacets = fProject.getProjectFacets();
            Iterator iterator = projFacets.iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while (!(facetVersion = (IProjectFacetVersion)iterator.next()).getProjectFacet().getId().equals("jst.ejb"));
            String ejbFacetVersion = facetVersion.getVersionString();
            if ("3.0".equals(ejbFacetVersion)) {
                return "5.0";
            }
            if ("2.1".equals(ejbFacetVersion)) {
                return "1.4";
            }
            if (!"2.0".equals(ejbFacetVersion)) return "2.4";
            return "1.3";
        }
        catch (Exception exception) {}
        return null;
    }

    private String getWebProjectVersionFromEar() {
        String earVersionString = this.getEarProjectVersion();
        if ("5.0".equals(earVersionString)) {
            return "2.5";
        }
        if ("1.4".equals(earVersionString)) {
            return "2.4";
        }
        if ("1.3".equals(earVersionString)) {
            return "2.3";
        }
        return "2.4";
    }

    private String getEjbProjectVersionFromEar() {
        String earVersionString = this.getEarProjectVersion();
        if ("5.0".equals(earVersionString)) {
            return "3.0";
        }
        if ("1.4".equals(earVersionString)) {
            return "2.1";
        }
        if ("1.3".equals(earVersionString)) {
            return "2.0";
        }
        return "2.1";
    }

    private String getEarProjectVersion() {
        if (this.earFacetVersion != null) {
            return this.earFacetVersion;
        }
        if (this.earProjectName == null) {
            return this.getJavaEEVersionFromEJB();
        }
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject earProject = root.getProject(this.earProjectName);
            IFacetedProject fProject = ProjectFacetsManager.create((IProject)earProject);
            Set projFacets = fProject.getProjectFacets();
            for (IProjectFacetVersion facetVersion : projFacets) {
                if (!facetVersion.getProjectFacet().getId().equals("jst.ear")) continue;
                this.earFacetVersion = facetVersion.getVersionString();
                return this.earFacetVersion;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private String getWasProjectVersion() {
        if (this.wasFacetVersion != null) {
            return this.wasFacetVersion;
        }
        try {
            if (this.earProjectName != null) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject earProject = root.getProject(this.earProjectName);
                IFacetedProject fProject = ProjectFacetsManager.create((IProject)earProject);
                Set projFacets = fProject.getProjectFacets();
                for (IProjectFacetVersion facetVersion : projFacets) {
                    if (!facetVersion.getProjectFacet().getId().equals("com.ibm.websphere.extended.ear")) continue;
                    this.wasFacetVersion = facetVersion.getVersionString();
                    return this.wasFacetVersion;
                }
            }
            IFacetedProject fEjbProject = ProjectFacetsManager.create((IProject)this.project);
            Set ejbProjFacets = fEjbProject.getProjectFacets();
            for (IProjectFacetVersion facetVersion : ejbProjFacets) {
                if (!facetVersion.getProjectFacet().getId().equals("com.ibm.websphere.extended.ejb")) continue;
                this.wasFacetVersion = facetVersion.getVersionString();
                return this.wasFacetVersion;
            }
        }
        catch (Exception exception) {}
        return "6.1";
    }

    public void setEarProjectName(String earProjectName) {
        this.earProjectName = earProjectName;
    }

    public void setProject(IProject ejbProject) {
        this.project = ejbProject;
    }

    public void setHttpRouterProjectName(String httpRouterProjectName) {
        this.httpRouterProjectName = httpRouterProjectName;
    }

    public void setJmsRouterProjectName(String jmsRouterProjectName) {
        this.jmsRouterProjectName = jmsRouterProjectName;
    }

    public void setHttpBinding(boolean httpBinding) {
        this.httpBinding = httpBinding;
    }

    public void setJmsBinding(boolean jmsBinding) {
        this.jmsBinding = jmsBinding;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId = serverFactoryId;
    }

    public String getHttpRouterProjectName() {
        return this.httpRouterProjectName;
    }

    public boolean getHttpBinding() {
        return this.httpBinding;
    }

    public boolean getJmsBinding() {
        return this.jmsBinding;
    }

    public String getJmsRouterProjectName() {
        return this.jmsRouterProjectName;
    }
}

