/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.ext.validator;

import com.ibm.ast.ws.ext.validator.WsExtBadAttribute;
import com.ibm.ast.ws.ext.validator.WsExtBadElement;
import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class WsExtParser {
    private ArrayList badElements_ = new ArrayList();

    public WsExtParser(String uri, ArrayList badElements) throws Exception {
        this.badElements_.addAll(badElements);
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        WsExtContentHandler handler = new WsExtContentHandler();
        handler.setDocumentLocator(new LocatorImpl());
        parser.parse(new File(uri), (DefaultHandler)handler);
    }

    private final class WsExtContentHandler
    extends DefaultHandler {
        private Locator locator_;

        private WsExtContentHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator_ = locator;
        }

        public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
            int i = 0;
            while (i < WsExtParser.this.badElements_.size()) {
                WsExtBadElement badElement = (WsExtBadElement)WsExtParser.this.badElements_.get(i);
                if (rawName.equals(badElement.getName())) {
                    ArrayList badAttrs = badElement.getAttributes();
                    boolean found = true;
                    for (WsExtBadAttribute badAttr : badAttrs) {
                        int k = 0;
                        while (k < attrs.getLength()) {
                            if (attrs.getQName(k).equals(badAttr.getName()) && !attrs.getValue(k).equals(badAttr.getValue())) {
                                found = false;
                                break;
                            }
                            ++k;
                        }
                        if (!found && badAttr.getValue() != null) break;
                        badAttr.getMessage().setLineNo(this.locator_.getLineNumber());
                    }
                }
                ++i;
            }
        }
    }
}

