/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.widgets.binding;

import java.io.File;
import org.eclipse.jst.ws.internal.uddiregistry.widgets.PrivateUDDISelectionCommand;
import org.eclipse.jst.ws.internal.uddiregistry.wizard.PrivateUDDIRegistryType;
import org.eclipse.jst.ws.internal.uddiregistry.wizard.PrivateUDDIRegistryTypeRegistry;
import org.eclipse.wst.command.internal.env.core.common.Condition;
import org.eclipse.wst.command.internal.env.core.common.Evaluate;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistry;
import org.eclipse.wst.command.internal.env.core.fragment.BooleanFragment;
import org.eclipse.wst.command.internal.env.core.fragment.ChoiceFragment;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragment;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragmentFactory;
import org.eclipse.wst.command.internal.env.core.fragment.SequenceFragment;
import org.eclipse.wst.command.internal.env.core.fragment.SimpleFragment;
import org.eclipse.wst.command.internal.env.ui.widgets.CanFinishRegistry;

public abstract class WASPrivateUDDIRegistryType
implements PrivateUDDIRegistryType {
    public static final String DATABASE_NAME = "UDDI30";
    public final String SERVER_BIN_DIR = "/bin/";
    public final String SERVER_WSADMIN_BAT = "wsadmin";
    public final String SERVER_WSADMIN_SH = "wsadmin.sh";
    protected String baseURL;

    protected abstract CommandFragment getDeployFragment();

    protected abstract CommandFragment getRemoveFragment();

    protected abstract CommandFragment getUpdateFragment();

    public abstract String getCategoriesDirectory(String var1);

    public abstract String getCategoriesDirectory();

    public abstract String getServerInstallationDirectory();

    public abstract String getScriptsDirectory();

    protected abstract Class getUDDIConfigWidgetClass();

    protected boolean isDirectoryEmpty(File directory) {
        if (directory.exists()) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                if (!files[i].isDirectory() || !this.isDirectoryEmpty(files[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void registerCanFinish(CanFinishRegistry canFinishRegistry) {
    }

    public CommandFragmentFactory create() {
        return new CommandFragmentFactory(){

            public CommandFragment create() {
                SequenceFragment root = new SequenceFragment();
                root.add((CommandFragment)new SimpleFragment("PrivateUDDIConfigPageWidget"));
                root.add((CommandFragment)new RegistryOperationSelectionFragment());
                return root;
            }
        };
    }

    public void registerDataMappings(DataMappingRegistry dataRegistry) {
        Class configWidgetClass = this.getUDDIConfigWidgetClass();
        dataRegistry.addMapping(PrivateUDDISelectionCommand.class, "PrivateUDDIRegistryType", RemoveExistingUDDIFragment.class);
        dataRegistry.addMapping(PrivateUDDISelectionCommand.class, "PrivateUDDIRegistryType", configWidgetClass, "RegistryType", null);
        dataRegistry.addMapping(PrivateUDDISelectionCommand.class, "OperationType", configWidgetClass);
        dataRegistry.addMapping(PrivateUDDISelectionCommand.class, "OperationType", RegistryOperationSelectionFragment.class);
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    protected class RegistryOperationSelectionFragment
    extends ChoiceFragment {
        private byte operationType;

        public RegistryOperationSelectionFragment() {
            super((Object[])new Byte[]{new Byte(0), new Byte(1), new Byte(2)}, new CommandFragment[]{WASPrivateUDDIRegistryType.this.getDeployFragment(), WASPrivateUDDIRegistryType.this.getUpdateFragment(), WASPrivateUDDIRegistryType.this.getRemoveFragment()});
        }

        public void setOperationType(byte operation) {
            this.operationType = operation;
            this.setEvaluate(new Evaluate(){

                public Object evaluate() {
                    return new Byte(RegistryOperationSelectionFragment.this.operationType);
                }
            });
        }
    }

    public class RemoveExistingUDDIFragment
    extends BooleanFragment {
        public RemoveExistingUDDIFragment() {
            this.setFalseFragment(null);
            this.setCondition(new FindExistingUDDIRegistry());
        }

        private class FindExistingUDDIRegistry
        implements Condition {
            private boolean firstTime = true;
            private boolean result = false;

            private FindExistingUDDIRegistry() {
            }

            public boolean evaluate() {
                if (this.firstTime) {
                    this.firstTime = false;
                    PrivateUDDIRegistryType[] types = PrivateUDDIRegistryTypeRegistry.getInstance().getTypes();
                    int i = 0;
                    while (i < types.length) {
                        if (types[i] instanceof WASPrivateUDDIRegistryType && types[i].isPrivateUDDIRegistryInstalled()) {
                            WASPrivateUDDIRegistryType type = (WASPrivateUDDIRegistryType)types[i];
                            RemoveExistingUDDIFragment.this.setTrueFragment(type.getRemoveFragment());
                            this.result = true;
                            break;
                        }
                        ++i;
                    }
                }
                return this.result;
            }
        }
    }
}

