/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.widgets;

import com.ibm.ast.ws.uddi.registry.datamodel.Category;
import com.ibm.ast.ws.uddi.registry.plugin.WebServiceUDDIRegistryPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class UserDefinedCategoryTable
extends SimpleWidgetDataContributor {
    private Hashtable categoryObjects_;
    private Table catTable_;
    private Button addCategoryButton_;
    private Button editCategoryButton_;
    private Button removeCategoriesButton_;
    private final String categoryTableEditDialogEditTitle_ = this.getMessage("%DIALOG_TITLE_CATEGORY_EDITOR_EDIT");
    private final String categoryTableEditDialogAddTitle_ = this.getMessage("%DIALOG_TITLE_CATEGORY_EDITOR_ADD");
    private final int COLUMN_NAME = 0;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        Group parent2 = this.getUIUtils().createGroup(parent, this.getMessage("%LABEL_USER_DEFINED_CATEGORIES"), this.getMessage("%TOOLTIP_PUPR_CATEGORY_TABLE"), null, 2, -1, -1);
        this.categoryObjects_ = new Hashtable();
        parent2.setLayoutData((Object)this.getUIUtils().createFillAll());
        this.catTable_ = this.getUIUtils().createTable((Composite)parent2, this.getMessage("%TOOLTIP_PUPR_CATEGORY_TABLE"), null, 67586);
        this.catTable_.setLayoutData((Object)this.getUIUtils().createFillAll());
        this.catTable_.setHeaderVisible(true);
        this.catTable_.setLinesVisible(true);
        TableLayout tl = new TableLayout();
        TableColumn nameColumn = new TableColumn(this.catTable_, 0);
        nameColumn.setText(this.getMessage("%CATEGORY_TABLE_HEADER_NAME"));
        nameColumn.pack();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, nameColumn.getWidth(), true));
        TableColumn fileColumn = new TableColumn(this.catTable_, 0);
        fileColumn.setText(this.getMessage("%CATEGORY_TABLE_HEADER_FILE"));
        fileColumn.pack();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, fileColumn.getWidth(), true));
        this.catTable_.setLayout((Layout)tl);
        Composite tableControls = this.getUIUtils().createComposite((Composite)parent2, 1);
        tableControls.setLayoutData((Object)new GridData(128));
        tableControls.setLayout((Layout)new FillLayout(512));
        this.addCategoryButton_ = this.getUIUtils().createPushButton(tableControls, this.getMessage("%BUTTON_ADD_USER_DEFINED_CATEGORY"), this.getMessage("%TOOLTIP_PUPR_CATEGORY_ADD"), null);
        this.addCategoryButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserDefinedCategoryTable.this.addNewCategoryToTable();
            }
        });
        this.editCategoryButton_ = this.getUIUtils().createPushButton(tableControls, this.getMessage("%BUTTON_EDIT_USER_DEFINED_CATEGORY"), this.getMessage("%TOOLTIP_PUPR_CATEGORY_EDIT"), null);
        this.editCategoryButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserDefinedCategoryTable.this.editSelectedCategory();
            }
        });
        this.removeCategoriesButton_ = this.getUIUtils().createPushButton(tableControls, this.getMessage("%BUTTON_DELETE_USER_DEFINED_CATEGORIES"), this.getMessage("%TOOLTIP_PUPR_CATEGORY_REMOVE"), null);
        this.removeCategoriesButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserDefinedCategoryTable.this.catTable_.remove(UserDefinedCategoryTable.this.catTable_.getSelectionIndices());
            }
        });
        return this;
    }

    public void setEnabled(boolean enable) {
        this.catTable_.setEnabled(enable);
        this.addCategoryButton_.setEnabled(enable);
        this.editCategoryButton_.setEnabled(enable);
        this.removeCategoriesButton_.setEnabled(enable);
    }

    private final void addCategoryToTable(Category category) {
        TableItem item = new TableItem(this.catTable_, 0);
        String name = category.getName();
        String dataFile = category.getDataFile();
        String[] itemData = new String[]{name, dataFile};
        item.setText(itemData);
        this.categoryObjects_.put(name, category);
    }

    private final void addNewCategoryToTable() {
        this.catTable_.deselectAll();
        TableItem tableItem = new TableItem(this.catTable_, 0);
        String[] tableItemData = new String[]{this.getMessage("%CATEGORY_NEW_NAME"), ""};
        tableItem.setText(tableItemData);
        this.catTable_.setSelection(this.catTable_.getItemCount() - 1);
        this.openCategoryTableEditDialog(tableItem, this.categoryTableEditDialogAddTitle_);
    }

    private final void changeCategoryInTable(TableItem tableItem, Category category) {
        String name = category.getName();
        String dataFile = category.getDataFile();
        String key = category.getKey();
        String[] values = new String[]{name, dataFile};
        tableItem.setText(values);
        this.categoryObjects_.put(key, category);
    }

    private final void editSelectedCategory() {
        int[] selectionIndices = this.catTable_.getSelectionIndices();
        if (selectionIndices != null && selectionIndices.length > 0) {
            TableItem firstSelectedTableItem = this.catTable_.getItem(selectionIndices[0]);
            this.catTable_.deselectAll();
            this.catTable_.setSelection(selectionIndices[0]);
            this.openCategoryTableEditDialog(firstSelectedTableItem, this.categoryTableEditDialogEditTitle_);
        }
    }

    private final void openCategoryTableEditDialog(TableItem tableItem, String dialogTitle) {
        CategoryTableEditDialog dialog = new CategoryTableEditDialog(new Shell(), tableItem, dialogTitle);
        dialog.open();
    }

    private final Category getSavedCategoryInfo(File categoryPropertiesFile) {
        try {
            Properties categoryProperties = new Properties();
            FileInputStream fin = new FileInputStream(categoryPropertiesFile);
            categoryProperties.load(fin);
            fin.close();
            String name = categoryProperties.getProperty("wsad.name");
            String categoryDataFileName = categoryProperties.getProperty("wsad.dataFile");
            String categoryKey = categoryProperties.getProperty("wsad.categoryKey");
            Category newCategory = new Category(name, categoryDataFileName, categoryKey);
            newCategory.setKey(categoryKey);
            return newCategory;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(new Shell(), 33);
            mb.setText(this.getMessage("%MSGBOX_TITLE_INVALID_CATEGORY"));
            mb.setMessage(e.getMessage());
            mb.open();
            return null;
        }
    }

    public final void populateWithSavedCategories(String categoryDirectory) {
        try {
            File categoryDirectoryFile = new File(categoryDirectory);
            this.catTable_.removeAll();
            if (categoryDirectoryFile.exists() && categoryDirectoryFile.isDirectory()) {
                File[] categoryPropertiesFiles = categoryDirectoryFile.listFiles();
                int i = 0;
                while (i < categoryPropertiesFiles.length) {
                    Category category;
                    String categoryPropertiesFileName = categoryPropertiesFiles[i].getName();
                    if (categoryPropertiesFileName.endsWith(".properties") && (category = this.getSavedCategoryInfo(categoryPropertiesFiles[i])) != null) {
                        this.addCategoryToTable(category);
                    }
                    ++i;
                }
            }
        }
        catch (SecurityException securityException) {
        }
        catch (Exception exception) {}
    }

    public final Category[] getCategories() {
        TableItem[] categoryItems = this.catTable_.getItems();
        if (categoryItems == null || categoryItems.length < 1) {
            return null;
        }
        Category[] categories = new Category[categoryItems.length];
        int i = 0;
        while (i < categoryItems.length) {
            String key = categoryItems[i].getText(0);
            categories[i] = (Category)this.categoryObjects_.get(key);
            ++i;
        }
        return categories;
    }

    public final void setCategories(Category[] categories) {
        this.catTable_.removeAll();
        int i = 0;
        while (i < categories.length) {
            this.addCategoryToTable(categories[i]);
            ++i;
        }
    }

    protected String getMessage(String key) {
        return WebServiceUDDIRegistryPlugin.getMessage(key);
    }

    protected UIUtils getUIUtils() {
        return WebServiceUDDIRegistryPlugin.getUiUtils();
    }

    private final class CategoryTableEditDialog
    extends Dialog {
        private String title_;
        private Text nameText_;
        private Text fileText_;

        public CategoryTableEditDialog(Shell parent, TableItem tableItem, String title) {
            super(parent);
            this.setShellStyle(0x10870 | CategoryTableEditDialog.getDefaultOrientation());
            this.title_ = title;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(this.title_);
        }

        protected Control createDialogArea(Composite parent) {
            GridData gd = new GridData(768);
            gd.heightHint = 100;
            gd.widthHint = 400;
            parent.setLayoutData((Object)gd);
            Composite parent2 = UserDefinedCategoryTable.this.getUIUtils().createComposite(parent, 3);
            this.nameText_ = UserDefinedCategoryTable.this.getUIUtils().createText(parent2, UserDefinedCategoryTable.this.getMessage("%DIALOG_LABEL_CATEGORY_EDITOR_NAME"), UserDefinedCategoryTable.this.getMessage("%TOOLTIP_PUPR_CATEGORY_NAME"), null, 2048);
            gd = new GridData(256);
            gd.horizontalSpan = 2;
            this.nameText_.setLayoutData((Object)gd);
            this.fileText_ = UserDefinedCategoryTable.this.getUIUtils().createText(parent2, UserDefinedCategoryTable.this.getMessage("%DIALOG_LABEL_CATEGORY_EDITOR_FILE"), UserDefinedCategoryTable.this.getMessage("%TOOLTIP_PUPR_CATEGORY_FILE"), null, 2048);
            Button fileBrowse = UserDefinedCategoryTable.this.getUIUtils().createPushButton(parent2, UserDefinedCategoryTable.this.getMessage("%DIALOG_BUTTON_CATEGORY_EDITOR_BROWSE"), UserDefinedCategoryTable.this.getMessage("%TOOLTIP_PUPR_CATEGORY_FILE_BROWSE"), null);
            fileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String fileName = new FileDialog(CategoryTableEditDialog.this.getShell()).open();
                    if (fileName != null) {
                        CategoryTableEditDialog.this.fileText_.setText(fileName);
                    }
                }
            });
            return parent;
        }

        protected void okPressed() {
            String name = this.nameText_.getText().trim();
            String fileName = this.fileText_.getText().trim();
            try {
                if (name.length() < 1) {
                    throw new Exception(UserDefinedCategoryTable.this.getMessage("%MSG_ERROR_CATEGORY_NAME_BLANK"));
                }
                if (fileName.length() < 1) {
                    throw new Exception(UserDefinedCategoryTable.this.getMessage("%MSG_ERROR_CHECKED_FILE_REQUIRED"));
                }
                TableItem[] currentItems = UserDefinedCategoryTable.this.catTable_.getItems();
                int selectionIndex = UserDefinedCategoryTable.this.catTable_.getSelectionIndex();
                int i = 0;
                while (i < currentItems.length) {
                    if (i != selectionIndex && currentItems[i].getText(0).equals(name)) {
                        Object[] args = new String[]{name};
                        throw new Exception(WebServiceUDDIRegistryPlugin.getMessage("%MSG_ERROR_DUPLICATE_DISPLAY_NAME", args));
                    }
                    ++i;
                }
                UserDefinedCategoryTable.this.changeCategoryInTable(currentItems[selectionIndex], new Category(name, fileName, name));
                super.okPressed();
            }
            catch (Exception e) {
                MessageBox mb = new MessageBox(this.getShell(), 33);
                mb.setText(UserDefinedCategoryTable.this.getMessage("%MSGBOX_TITLE_INVALID_CATEGORY"));
                mb.setMessage(e.getMessage());
                mb.open();
            }
        }

        protected void cancelPressed() {
            if (this.title_.equals(UserDefinedCategoryTable.this.categoryTableEditDialogAddTitle_)) {
                UserDefinedCategoryTable.this.catTable_.remove(UserDefinedCategoryTable.this.catTable_.getSelectionIndex());
            }
            super.cancelPressed();
        }
    }
}

