/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.widgets;

import com.ibm.ast.ws.uddi.registry.widgets.PrivateUDDIConfigWidgetForCloudscape;
import com.ibm.datatools.externalservices.ClientUtil;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class PrivateUDDIConfigWidgetForDB2
extends PrivateUDDIConfigWidgetForCloudscape {
    private Text dbUserIDText_;
    private Text dbPasswordText_;
    private Text db2DriverLocationText_;
    private Listener statusListener;
    private static final String INFOPOP_PUPR_PRIVATE_UDDI_DB2_PAGE = "PUPR0002";
    private static final String INFOPOP_PUPR_DB2_USER_NAME = "PUPR0007";
    private static final String INFOPOP_PUPR_DB2_PASSWORD = "PUPR0008";
    private static final String INFOPOP_PUPR_DB2_DRIVER_LOCATION = "PUPR0009";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener = statusListener;
        parent.setToolTipText(this.getMessage("TOOLTIP_PUPR_PRIVATE_UDDI_DB2_PAGE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, INFOPOP_PUPR_PRIVATE_UDDI_DB2_PAGE);
        TextModifyListener modifyListener = new TextModifyListener();
        Composite db2Composite = this.getUIUtils().createComposite(parent, 2);
        this.dbUserIDText_ = this.getUIUtils().createText(db2Composite, this.getMessage("%LABEL_DB_USER_ID"), this.getMessage("TOOLTIP_PUPR_DB2_USER_NAME"), INFOPOP_PUPR_DB2_USER_NAME, 2048);
        this.dbUserIDText_.addModifyListener((ModifyListener)modifyListener);
        this.dbPasswordText_ = this.getUIUtils().createText(db2Composite, this.getMessage("%LABEL_DB_PASSWORD"), this.getMessage("TOOLTIP_PUPR_DB2_PASSWORD"), INFOPOP_PUPR_DB2_PASSWORD, 0x400800);
        this.dbPasswordText_.addModifyListener((ModifyListener)modifyListener);
        this.db2DriverLocationText_ = this.getUIUtils().createText(db2Composite, this.getMessage("%LABEL_DB2_DRIVER_LOCATION"), this.getMessage("TOOLTIP_PUPR_DB2_DRIVER_LOCATION"), INFOPOP_PUPR_DB2_DRIVER_LOCATION, 2048);
        String db2DriverLocation = ClientUtil.getDB2AppDriverClientZipPath();
        if (db2DriverLocation != null) {
            this.db2DriverLocationText_.setText(db2DriverLocation);
        }
        this.db2DriverLocationText_.addModifyListener((ModifyListener)modifyListener);
        super.addControls(parent, statusListener);
        return this;
    }

    protected void enableAllControls(boolean enable) {
        boolean isLinux = System.getProperty("os.name").toLowerCase().indexOf("win") < 0;
        this.dbUserIDText_.setEnabled(enable || isLinux);
        this.dbPasswordText_.setEnabled(enable || isLinux);
        this.db2DriverLocationText_.setEnabled(enable);
        this.catTable_.setEnabled(enable);
        this.serverComposite.setEnabled(enable);
        this.serverComposite2.setEnabled(enable);
        this.launchWSECheck_.setEnabled(enable);
        this.launchWSECheck_.setSelection(enable);
    }

    public IStatus getStatus() {
        String message = null;
        if (this.dbUserIDText_.isEnabled() && (this.dbUserIDText_.getText() == null || this.dbUserIDText_.getText().length() <= 0)) {
            message = this.getMessage("%PAGE_MSG_INVALID_DB_USER_ID");
        } else if (this.dbPasswordText_.isEnabled() && (this.dbPasswordText_.getText() == null || this.dbPasswordText_.getText().length() <= 0)) {
            message = this.getMessage("%PAGE_MSG_INVALID_DB_PASSWORD");
        } else if (this.db2DriverLocationText_.isEnabled() && (this.db2DriverLocationText_.getText() == null || this.db2DriverLocationText_.getText().length() <= 0 || !new File(this.db2DriverLocationText_.getText()).isFile())) {
            message = this.getMessage("%PAGE_MSG_INVALID_DB2_DRIVER_LOCATION");
        }
        if (message != null) {
            return new Status(4, "com.ibm.ast.ws.uddi.registry", 0, message, null);
        }
        return Status.OK_STATUS;
    }

    public String getUserID() {
        return this.dbUserIDText_.getText();
    }

    public String getPassword() {
        return this.dbPasswordText_.getText();
    }

    public String getClasspath() {
        return this.db2DriverLocationText_.getText();
    }

    public String getServerID() {
        return this.serverCombo_.getText();
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            PrivateUDDIConfigWidgetForDB2.this.statusListener.handleEvent(null);
        }
    }
}

