/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.command;

import com.ibm.ast.ws.uddi.registry.command.ExecuteCommandLine;
import com.ibm.ast.ws.uddi.registry.context.PersistentInstalledUDDIRegistryContext;
import com.ibm.ast.ws.uddi.registry.plugin.WebServiceUDDIRegistryPlugin;
import com.ibm.ast.ws.uddi.registry.widgets.binding.WASPrivateUDDIRegistryType;
import java.io.File;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class RemoveUDDIRegistryCommand
extends AbstractDataModelOperation {
    protected final String UDDI_SCRIPT_REMOVE = "uddiRemove.jacl";
    protected final String UDDI_LOG_REMOVE = "uddiRemove.log";
    protected String serverName;
    protected String nodeName;
    protected WASPrivateUDDIRegistryType registryType;
    protected boolean secureServer;
    protected String serverUserName;
    protected String serverPassword;
    protected String soapPort;
    protected String profileLocation;
    protected String profileName;

    public RemoveUDDIRegistryCommand(WASPrivateUDDIRegistryType type) {
        this.registryType = type;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        monitor.beginTask(WebServiceUDDIRegistryPlugin.getMessage("PROG_MSG_UNINSTALLING_UDDI_REGISTRY"), -1);
        String[] command = null;
        command = System.getProperty("os.name").toLowerCase().indexOf("win") < 0 ? this.getLinuxCommand() : this.getWinCommand();
        ExecuteCommandLine remove = new ExecuteCommandLine(command, String.valueOf(this.registryType.getServerInstallationDirectory()) + this.registryType.SERVER_BIN_DIR);
        IStatus status = remove.execute(monitor, adaptable);
        if (status.getSeverity() != 0) {
            status = new Status(4, "com.ibm.ast.ws.uddi.registry", 0, WebServiceUDDIRegistryPlugin.getMessage("%MSG_ERROR_UNINSTALLING_UDDI_REGISTRY"), status.getException());
            this.getEnvironment().getStatusHandler().reportError(status);
        } else {
            PersistentInstalledUDDIRegistryContext context = WebServiceUDDIRegistryPlugin.getInstance().getInstalledRegistryContext();
            context.setServerID("");
            if (!this.removeDirectoryFiles(new File(this.registryType.getCategoriesDirectory(this.profileLocation)))) {
                status = new Status(4, "com.ibm.ast.ws.uddi.registry", 0, WebServiceUDDIRegistryPlugin.getMessage("%MSG_ERROR_UNINSTALLING_UDDI_REGISTRY"), status.getException());
                this.getEnvironment().getStatusHandler().reportError(status);
            }
        }
        return status;
    }

    protected String[] getLinuxCommand() {
        if (this.secureServer) {
            String[] commandLinux = new String[]{"/bin/sh", this.registryType.SERVER_WSADMIN_SH, "-profileName", this.profileName, "-user", this.serverUserName, "-password", this.serverPassword, "-f", "uddiRemove.jacl", this.nodeName, this.serverName, "-port", this.soapPort};
            return commandLinux;
        }
        String[] commandLinux = new String[]{"/bin/sh", this.registryType.SERVER_WSADMIN_SH, "-profileName", this.profileName, "-f", "uddiRemove.jacl", this.nodeName, this.serverName, "-port", this.soapPort};
        return commandLinux;
    }

    protected String[] getWinCommand() {
        if (this.secureServer) {
            String[] commandWindows = new String[]{"cmd", "/c", this.registryType.SERVER_WSADMIN_BAT, "-profileName", this.profileName, "-user", this.serverUserName, "-password", this.serverPassword, "-f", "uddiRemove.jacl", this.nodeName, this.serverName, "-port", this.soapPort, ">", "uddiRemove.log"};
            return commandWindows;
        }
        String[] commandWindows = new String[]{"cmd", "/c", this.registryType.SERVER_WSADMIN_BAT, "-profileName", this.profileName, "-f", "uddiRemove.jacl", this.nodeName, this.serverName, "-port", this.soapPort, ">", "uddiRemove.log"};
        return commandWindows;
    }

    private boolean removeDirectoryFiles(File directory) {
        boolean result = true;
        if (!directory.exists()) {
            return result;
        }
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            result = files[i].isDirectory() ? result && this.removeDirectoryFiles(files[i]) : result && files[i].delete();
            ++i;
        }
        result = result && directory.delete();
        return result;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setSecureServer(boolean secureServer) {
        this.secureServer = secureServer;
    }

    public void setServerPassword(String serverPassword) {
        this.serverPassword = serverPassword;
    }

    public void setServerUserName(String serverUserName) {
        this.serverUserName = serverUserName;
    }

    public void setSoapPort(String soapPort) {
        this.soapPort = soapPort;
    }

    public void setProfileLocation(String profileLocation) {
        this.profileLocation = profileLocation;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }
}

