/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.command;

import com.ibm.ast.ws.uddi.registry.widgets.binding.WASPrivateUDDIRegistryType;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.model.v10.taxonomy.Taxonomy;
import org.eclipse.wst.ws.internal.model.v10.uddiregistry.Taxonomies;
import org.eclipse.wst.ws.internal.model.v10.uddiregistry.UDDIRegistry;
import org.eclipse.wst.ws.internal.registry.IRegistryManager;
import org.eclipse.wst.ws.internal.registry.RegistryService;

public class RemoveRegistrySchemaCommand
extends AbstractDataModelOperation {
    private WASPrivateUDDIRegistryType registryType;

    public RemoveRegistrySchemaCommand(WASPrivateUDDIRegistryType type) {
        this.registryType = type;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        try {
            RegistryService registryService = RegistryService.instance();
            IRegistryManager regManager = registryService.getDefaultRegistryManager();
            UDDIRegistry registry = (UDDIRegistry)regManager.loadRegistry(this.registryType.getID());
            if (registry == null) {
                return Status.OK_STATUS;
            }
            Taxonomies taxonomies = registry.getTaxonomies();
            if (taxonomies != null) {
                EList taxonomyList = taxonomies.getTaxonomy();
                int i = 0;
                while (i < taxonomyList.size()) {
                    Taxonomy taxonomy = (Taxonomy)taxonomyList.get(i);
                    regManager.removeTaxonomy(taxonomy.getRef(), true);
                    ++i;
                }
            }
            regManager.removeRegistry(this.registryType.getID(), true);
            return Status.OK_STATUS;
        }
        catch (Exception exc) {
            Status status = new Status(4, "com.ibm.ast.ws.uddi.registry", 0, "Error while removing xml files", (Throwable)exc);
            this.getEnvironment().getStatusHandler().reportError((IStatus)status);
            return status;
        }
    }
}

