/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public final class ExecuteCommandLine
extends AbstractDataModelOperation {
    private String[] command;
    private String path;

    public ExecuteCommandLine(String[] command) {
        this.command = command;
    }

    public ExecuteCommandLine(String[] command, String path) {
        this.command = command;
        this.path = path;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        try {
            Runtime rt = Runtime.getRuntime();
            Process p = this.path == null ? rt.exec(this.command) : rt.exec(this.command, null, new File(this.path));
            new ProcessExecThread(p.getInputStream()).start();
            new ProcessExecThread(p.getErrorStream()).start();
            int curExitValue = -1;
            while (curExitValue < 0 && !monitor.isCanceled()) {
                try {
                    curExitValue = p.exitValue();
                }
                catch (Throwable throwable) {}
                Thread.sleep(100L);
            }
            return this.checkReturnCode(p);
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.ast.ws.uddi.registry", 0, "Failed to execute Command " + this.command, (Throwable)e);
        }
    }

    protected IStatus checkReturnCode(Process p) {
        if (p.exitValue() != 0) {
            String msg = null;
            try {
                InputStream is = p.getInputStream();
                byte[] b = new byte[is.available()];
                is.read(b, 0, b.length);
                is.close();
                msg = new String(b);
            }
            catch (Exception exception) {}
            if (msg != null) {
                return new Status(4, "com.ibm.ast.ws.uddi.registry", 0, msg, (Throwable)new Exception(msg));
            }
            return new Status(4, "com.ibm.ast.ws.uddi.registry", 0, "", (Throwable)new Exception());
        }
        return Status.OK_STATUS;
    }

    private final class ProcessExecThread
    extends Thread {
        private BufferedReader br_;

        public ProcessExecThread(InputStream stream) {
            this.br_ = new BufferedReader(new InputStreamReader(stream));
        }

        public final void run() {
            try {
                String s;
                while ((s = this.br_.readLine()) != null) {
                    System.out.println(s);
                }
                this.br_.close();
            }
            catch (IOException iOException) {}
        }
    }
}

