/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.command;

import com.ibm.ast.ws.uddi.registry.command.ExecuteCommandLine;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class ConnectToDB2DatabaseCommand
extends AbstractDataModelOperation {
    private String id;
    private String password;

    public ConnectToDB2DatabaseCommand(String id, String password) {
        this.id = id;
        this.password = password;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        String[] command = System.getProperty("os.name").toLowerCase().indexOf("win") < 0 ? this.getLinuxCommand() : this.getWinCommand();
        ExecuteCommandLine commandExec = new ExecuteCommandLine(command);
        IStatus status = commandExec.execute(monitor, adaptable);
        if (System.getProperty("os.name").toLowerCase().indexOf("win") < 0) {
            ExecuteCommandLine releaseConnection = new ExecuteCommandLine(new String[]{"db2", "connect", "reset"});
            releaseConnection.execute(monitor, adaptable);
        }
        return status;
    }

    private String[] getLinuxCommand() {
        if (this.id != null && this.id.length() > 0 && this.password != null && this.password.length() > 0) {
            return new String[]{"db2", "connect", "to", "UDDI30", "user", this.id, "using", this.password};
        }
        return new String[]{"db2", "connect", "to", "UDDI30"};
    }

    private String[] getWinCommand() {
        if (this.id != null && this.id.length() > 0 && this.password != null && this.password.length() > 0) {
            return new String[]{"db2cmd", "/i", "/w", "/c", "db2", "connect", "to", "UDDI30", "user", this.id, "using", this.password};
        }
        return new String[]{"db2cmd", "/i", "/w", "/c", "db2", "connect", "to", "UDDI30"};
    }
}

