/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.command;

import com.ibm.ast.ws.uddi.registry.datamodel.Category;
import com.ibm.ast.ws.uddi.registry.widgets.binding.WASPrivateUDDIRegistryType;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.ws.internal.context.UDDIPreferenceContext;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.model.v10.registry.Name;
import org.eclipse.wst.ws.internal.model.v10.registry.Registry;
import org.eclipse.wst.ws.internal.model.v10.registry.RegistryFactory;
import org.eclipse.wst.ws.internal.model.v10.taxonomy.Taxonomy;
import org.eclipse.wst.ws.internal.model.v10.taxonomy.TaxonomyFactory;
import org.eclipse.wst.ws.internal.model.v10.uddiregistry.Taxonomies;
import org.eclipse.wst.ws.internal.model.v10.uddiregistry.UDDIRegistry;
import org.eclipse.wst.ws.internal.model.v10.uddiregistry.UDDIRegistryFactory;
import org.eclipse.wst.ws.internal.registry.IRegistryManager;
import org.eclipse.wst.ws.internal.registry.RegistryService;
import org.eclipse.wst.ws.internal.registry.UDDIRegistryService;

public class BuildCategorySchemaCommand
extends AbstractDataModelOperation {
    private WASPrivateUDDIRegistryType registryType;
    private char columnDelimiter;
    private char stringDelimiter;
    private Category[] taxonomies;
    private String inquiryAPI;
    private String publishAPI;
    private EList categoryList;
    private Taxonomy currentTaxonomy;

    public BuildCategorySchemaCommand(WASPrivateUDDIRegistryType type) {
        this.registryType = type;
        UDDIPreferenceContext sc = WebServicePlugin.getInstance().getUDDIPreferenceContext();
        this.columnDelimiter = sc.getUddiCatDataColumnDelimiter().charAt(0);
        this.stringDelimiter = sc.getUddiCatDataStringDelimiter().charAt(0);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        try {
            UDDIRegistryService uddiRegistryService = UDDIRegistryService.instance();
            UDDIRegistry uddiRegistry = uddiRegistryService.newUDDIRegistry();
            uddiRegistry.setId(this.registryType.getID());
            uddiRegistry.setPublicationURL(this.publishAPI);
            uddiRegistry.setDiscoveryURL(this.inquiryAPI);
            Name name = RegistryFactory.eINSTANCE.createName();
            name.setValue(this.registryType.getName());
            uddiRegistry.getName().add((Object)name);
            RegistryService registryService = RegistryService.instance();
            IRegistryManager regManager = registryService.getDefaultRegistryManager();
            if (this.taxonomies != null && this.taxonomies.length > 0) {
                Taxonomies registryTaxonomies = uddiRegistry.getTaxonomies();
                if (registryTaxonomies == null) {
                    registryTaxonomies = UDDIRegistryFactory.eINSTANCE.createTaxonomies();
                    uddiRegistry.setTaxonomies(registryTaxonomies);
                }
                EList taxonomyReferences = registryTaxonomies.getTaxonomy();
                int i = 0;
                while (i < this.taxonomies.length) {
                    this.currentTaxonomy = registryService.newTaxonomy();
                    this.currentTaxonomy.setName(this.taxonomies[i].getName());
                    this.currentTaxonomy.setId(this.taxonomies[i].getName());
                    this.currentTaxonomy.setTmodelKey(this.taxonomies[i].getV2StyleKey());
                    this.categoryList = this.currentTaxonomy.getCategory();
                    status = this.readCategoryFile(this.taxonomies[i].getDataFile());
                    if (status.getSeverity() != 0) {
                        this.getEnvironment().getStatusHandler().report(status);
                        return status;
                    }
                    taxonomyReferences.add((Object)this.currentTaxonomy);
                    Taxonomy currTaxonomyRef = regManager.saveTaxonomy(this.currentTaxonomy);
                    uddiRegistryService.addTaxonomy(uddiRegistry, currTaxonomyRef);
                    ++i;
                }
            }
            regManager.saveRegistry((Registry)uddiRegistry);
            return Status.OK_STATUS;
        }
        catch (Exception exc) {
            status = new Status(4, "com.ibm.ast.ws.uddi.registry", 0, "Error while writing xml files", (Throwable)exc);
            this.getEnvironment().getStatusHandler().reportError(status);
            return status;
        }
    }

    private IStatus readCategoryFile(String fileName) {
        IStatus status = OK_STATUS;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            return this.loadData(br);
        }
        catch (FileNotFoundException e) {
            status = new Status(4, "com.ibm.ast.ws.uddi.registry", 0, "File not found" + fileName, (Throwable)e);
            this.getEnvironment().getStatusHandler().reportError(status);
            return status;
        }
        catch (UnsupportedEncodingException e) {
            status = new Status(4, "com.ibm.ast.ws.uddi.registry", 0, "Unsupported EncodingUTF-8", (Throwable)e);
            this.getEnvironment().getStatusHandler().reportError(status);
            return status;
        }
        catch (IOException e) {
            status = new Status(4, "com.ibm.ast.ws.uddi.registry", 0, "Error while reading the file " + fileName, (Throwable)e);
            this.getEnvironment().getStatusHandler().reportError(status);
            return status;
        }
        catch (ParseException e) {
            status = new Status(4, "com.ibm.ast.ws.uddi.registry", 0, String.valueOf(e.getMessage()) + " " + e.getErrorOffset(), (Throwable)e);
            this.getEnvironment().getStatusHandler().reportError(status);
            return status;
        }
    }

    private final IStatus loadData(BufferedReader br) throws IOException, ParseException {
        IStatus status = Status.OK_STATUS;
        Hashtable<String, org.eclipse.wst.ws.internal.model.v10.taxonomy.Category> elements = new Hashtable<String, org.eclipse.wst.ws.internal.model.v10.taxonomy.Category>();
        String line = null;
        int lineNumber = 0;
        Vector<String> values = new Vector<String>();
        while ((line = br.readLine()) != null) {
            ++lineNumber;
            if (line.trim().length() == 0) continue;
            int index = 0;
            int length = line.length();
            boolean inStringDelimiters = false;
            values.removeAllElements();
            StringBuffer currentToken = new StringBuffer();
            while (index < length) {
                char currentChar = line.charAt(index);
                if (inStringDelimiters) {
                    if (currentChar == this.stringDelimiter) {
                        if (index < length - 1) {
                            char followingChar = line.charAt(index + 1);
                            if (followingChar == this.stringDelimiter) {
                                currentToken.append(this.stringDelimiter);
                                index += 2;
                                continue;
                            }
                            inStringDelimiters = false;
                            int nextDelimiter = line.indexOf(this.columnDelimiter, index);
                            if (nextDelimiter == -1) break;
                            values.addElement(currentToken.toString());
                            currentToken.setLength(0);
                            inStringDelimiters = false;
                            index = nextDelimiter + 1;
                            continue;
                        }
                        ++index;
                        inStringDelimiters = false;
                        continue;
                    }
                    currentToken.append(currentChar);
                    ++index;
                    continue;
                }
                if (currentChar == this.columnDelimiter) {
                    values.addElement(currentToken.toString());
                    currentToken.setLength(0);
                    ++index;
                    continue;
                }
                if (currentChar == this.stringDelimiter) {
                    inStringDelimiters = true;
                    ++index;
                    continue;
                }
                currentToken.append(currentChar);
                ++index;
            }
            if (inStringDelimiters) {
                br.close();
                throw new ParseException(line, lineNumber);
            }
            values.addElement(currentToken.toString());
            String keyValue = (String)values.elementAt(0);
            String keyName = (String)values.elementAt(1);
            String parentKeyValue = (String)values.elementAt(2);
            org.eclipse.wst.ws.internal.model.v10.taxonomy.Category category = TaxonomyFactory.eINSTANCE.createCategory();
            category.setName(keyName);
            category.setCode(keyValue);
            org.eclipse.wst.ws.internal.model.v10.taxonomy.Category parent = (org.eclipse.wst.ws.internal.model.v10.taxonomy.Category)elements.get(parentKeyValue);
            if (parent != null) {
                parent.getCategory().add((Object)category);
            } else {
                this.categoryList.add((Object)category);
            }
            elements.put(keyValue, category);
        }
        br.close();
        return status;
    }

    public void setCategories(Category[] taxonomies) {
        this.taxonomies = taxonomies;
    }

    public void setBaseURL(String baseURL) {
        this.inquiryAPI = String.valueOf(baseURL) + "/uddisoap/inquiryapi";
        this.publishAPI = String.valueOf(baseURL) + "/uddisoap/publishapi";
    }
}

