@echo off
rem parameters are: 1=database name, 2=db2 userid, 3=db2 password
setlocal

if "%3"=="" goto LABEL_BadParameters
if "%2"=="" goto LABEL_BadParameters
if "%1"=="" goto LABEL_BadParameters

rem is a default database required?
if "%4"=="" goto LABEL_SkipDefaultDatabaseCheck

if "%4"=="default" goto LABEL_SetDefaultDatabaseIndicator
echo.
echo ERROR!
echo.An invalid value for "default" specified of "%4".
echo.
goto LABEL_BadParameters

rem set default indicator
:LABEL_SetDefaultDatabaseIndicator
echo.
echo Default database requested
echo.db
set DEFAULT_DATABASE=1
goto LABEL_SetMainVariables


rem default not specified
:LABEL_SkipDefaultDatabaseCheck
set DEFAULT_DATABASE=0

:LABEL_SetMainVariables
set DIR_WITH_SCRIPTS=%WAS_INSTALL_DIR%
set DATABASE_NAME=%1
set DB2_USERID=%2
set DB2_PWD=%3

db2start

rem first test if there is DB2CODEPAGE set already
db2set DB2CODEPAGE >NUL 2>&1
@if %ERRORLEVEL% == 0 (
  @for /f "tokens=1" %%o in ('db2set DB2CODEPAGE') do (
    @echo "DB2 Codepage is already set to : %%o"
    @if %%o. == 1208. goto LABEL_PostCodePageCheck
    @if %%o. == UTF-8. goto LABEL_PostCodePageCheck
    @echo "Incompatible DB2 Codepage %%o already set"
    @echo "DB2CODEPAGE must be 1208 or UTF-8, ie DB2SET DB2CODEPAGE 1208"
    @goto LABEL_BadExit
  )
)
:LABEL_PostCodePageCheck

rem Evaluate if we need to set the db2set vars
for /F "delims== tokens=1" %%v in ('db2set') do (
    if "%%v" == "DB2_INDEX_2BYTEVARLEN" (
        set INDEX_VAR_ALREADY_SET=true
    ) else if "%%v" == "DB2CODEPAGE" (
        set CODEPAGE_VAR_ALREADY_SET=true
    )
)

set CODEPAGE_VAR_ALREADY_SET=false
for /F "delims== tokens=1" %%v in ('db2set') do (
    if "%%v" == "DB2CODEPAGE" (
        set CODEPAGE_VAR_ALREADY_SET=true
    )
)

if not "%INDEX_VAR_ALREADY_SET%" == "true" (
    call .\setDB2ProfileVariables
) else if not "%CODEPAGE_VAR_ALREADY_SET%" == "true" (
    call .\setDB2ProfileVariables
)


rem CREATE NEW DATABASE

echo db2 create database %DATABASE_NAME% using codeset UTF-8 territory en
db2 create database %DATABASE_NAME% using codeset UTF-8 territory en
set RC=%ERRORLEVEL%
echo "Create database returned rc: %RC%"
if %RC% GTR 0 ( goto LABEL_BadExit )

@echo db2 connect to %DATABASE_NAME% user %DB2_USERID% using #########
@db2 connect to %DATABASE_NAME% user %DB2_USERID% using %DB2_PWD%
set RC=%ERRORLEVEL%
echo "Authorised connect returned rc: %RC%"
if %RC% GTR 0 ( goto LABEL_BadExit )


rem CONFIGURE NEW DATABASE

rem Call the db2 update cmd, and accept rc=0 or SQL1363W as ok.
db2 update db cfg for %DATABASE_NAME% using applheapsz 2048 > %DIR_WITH_SCRIPTS%\udcahs.log 2>&1
set RC=%ERRORLEVEL%
@echo "Update applheapsz rc: %RC%"

@echo "--Inserted udcahs.log--"
type %DIR_WITH_SCRIPTS%\udcahs.log
@echo "--End Inserted udcahs.log--"

rem check for mustrestart warning
@echo "Using %SYSTEMROOT%\system32\find.exe to find SQL1363W in udcahs.log"
%SYSTEMROOT%\system32\find.exe "SQL1363W" %DIR_WITH_SCRIPTS%\udcahs.log
set FINDRC=%ERRORLEVEL%
@echo "FINDRC was %FINDRC%"

@echo "Removing udcahs.log"
del %DIR_WITH_SCRIPTS%\udcahs.log

rem rc of 0 is good, rc of non zero is bad if we DONT find SQL1363W
if %RC% GTR 0 if %FINDRC% NEQ 0 goto LABEL_BadExit


rem Call the db2 update cmd, and accept rc=0 or SQL1363W as ok.
db2 update db cfg for %DATABASE_NAME% using logfilsiz 8192 > %DIR_WITH_SCRIPTS%\udclfs.log 2>&1
set RC=%ERRORLEVEL%
@echo "Update logfilesz returned rc: %RC%"

@echo "--Inserted udclfs.log--"
type %DIR_WITH_SCRIPTS%\udclfs.log
@echo "--End Inserted udclfs.log--"

rem check for mustrestart warning
@echo "Using %SYSTEMROOT%\system32\find.exe to find SQL1363W in udclfs.log"
%SYSTEMROOT%\system32\find.exe "SQL1363W" %DIR_WITH_SCRIPTS%\udclfs.log
set FINDRC=%ERRORLEVEL%
@echo "FINDRC was %FINDRC%"

@echo "Removing udclfs.log"
del %DIR_WITH_SCRIPTS%\udclfs.log

rem rc of 0 is good, rc of non zero is bad if we DONT find SQL1363W
if %RC% GTR 0 if %FINDRC% NEQ 0 goto LABEL_BadExit


rem ACTIVATE NEW CONFIGURATION

db2 connect reset
set RC=%ERRORLEVEL%
echo "Connect reset returned rc: %RC%"
if %RC% GTR 0 ( goto LABEL_BadExit )

db2 terminate
set RC=%ERRORLEVEL%
echo "Terminate returned rc: %RC%"
if %RC% GTR 0 ( goto LABEL_BadExit )

@echo db2 connect to %DATABASE_NAME% user %DB2_USERID% using ******
@db2 connect to %DATABASE_NAME% user %DB2_USERID% using %DB2_PWD%
set RC=%ERRORLEVEL%
echo "Authorised connect returned rc: %RC%"
if %RC% GTR 0 ( goto LABEL_BadExit )

rem CREATE BUFFERPOOL

db2 CREATE BUFFERPOOL uddibp size 250 PAGESIZE 32K
set RC=%ERRORLEVEL%
echo "Create bufferpool uddibp returned rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )

rem ACTIVATE BUFFERPOOL

db2 connect reset
set RC=%ERRORLEVEL%
echo "Connect reset returned rc: %RC%"
if %RC% GTR 0 ( goto LABEL_BadExit )

db2 terminate
set RC=%ERRORLEVEL%
echo "Terminate returned rc: %RC%"
if %RC% GTR 0 ( goto LABEL_BadExit )

db2 force application all
set RC=%ERRORLEVEL%
echo "Force application all rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )

db2 terminate
set RC=%ERRORLEVEL%
echo "Terminate returned rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )

db2stop
set RC=%ERRORLEVEL%
echo "db2stop returned rc: %RC%"
if %RC% GTR 0 ( goto LABEL_BadExit )

echo delaying before dbstart
ping localhost -n 32

db2start
set RC=%ERRORLEVEL%
echo "db2start returned rc: %RC%"
if %RC% GTR 0 (
  db2start
  if %ERRORLEVEL% GTR 0 db2start
  if %ERRORLEVEL% GTR 0 db2start
  if %ERRORLEVEL% GTR 0 db2start
  if %ERRORLEVEL% GTR 0 echo "ERROR: db2 failed to restart" && goto LABEL_BadExit
  echo "dbstart extended processing complete"
)

@echo db2 connect to %DATABASE_NAME% user %DB2_USERID% using ******
@db2 connect to %DATABASE_NAME% user %DB2_USERID% using %DB2_PWD%

set RC=%ERRORLEVEL%
echo "Authorised connect returned rc: %RC%"
if %RC% GTR 0 ( goto LABEL_BadExit )

rem CREATE TABLESPACES

db2 create regular tablespace uddits pagesize 32k managed by system using ('uddidb') extentsize 64 prefetchsize 32 bufferpool uddibp
set RC=%ERRORLEVEL%
echo "create tablespace returned rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )

db2 CREATE SYSTEM TEMPORARY TABLESPACE UDDIBP_SYS_TEMP PAGESIZE 32 K  MANAGED BY SYSTEM  USING ('uddibp_sys_temp') EXTENTSIZE 32 OVERHEAD 14.06 PREFETCHSIZE 32 TRANSFERRATE 0.33 BUFFERPOOL UDDIBP
set RC=%ERRORLEVEL%
echo "create tablespace bufferpool returned rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )

rem CREATE THE DATABASE STUCTURES

rem Execute any DB SPECIFIC prerequisites
set FILE_TO_PROCESS=uddi30crt_10_prereq_db2.sql
db2 -tvf %DIR_WITH_SCRIPTS%\%FILE_TO_PROCESS%
set RC=%ERRORLEVEL%
echo "Import of %FILE_TO_PROCESS% returned rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )


rem Create the tables which use GENERIC SQL
set FILE_TO_PROCESS=uddi30crt_20_tables_generic.sql
db2 -tvf %DIR_WITH_SCRIPTS%\%FILE_TO_PROCESS%
set RC=%ERRORLEVEL%
echo "Import of %FILE_TO_PROCESS% returned rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )


rem Create the tables which use DB SPECIFIC SQL
set FILE_TO_PROCESS=uddi30crt_25_tables_db2udb.sql
db2 -tvf %DIR_WITH_SCRIPTS%\%FILE_TO_PROCESS%
set RC=%ERRORLEVEL%
echo "Import of %FILE_TO_PROCESS% returned rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )


rem Add the constraints which use GENERIC SQL
set FILE_TO_PROCESS=uddi30crt_30_constraints_generic.sql
db2 -tvf %DIR_WITH_SCRIPTS%\%FILE_TO_PROCESS%
set RC=%ERRORLEVEL%
echo "Import of %FILE_TO_PROCESS% returned rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )


rem Add the constraints which use DB SPECIFIC SQL
set FILE_TO_PROCESS=uddi30crt_35_constraints_db2udb.sql
db2 -tvf %DIR_WITH_SCRIPTS%\%FILE_TO_PROCESS%
set RC=%ERRORLEVEL%
echo "Import of %FILE_TO_PROCESS% returned rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )


rem Add the view which use GENERIC SQL
set FILE_TO_PROCESS=uddi30crt_40_views_generic.sql
db2 -tvf %DIR_WITH_SCRIPTS%\%FILE_TO_PROCESS%
set RC=%ERRORLEVEL%
echo "Import of %FILE_TO_PROCESS% returned rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )


rem Add the views which use DB SPECIFIC SQL
set FILE_TO_PROCESS=uddi30crt_45_views_db2udb.sql
db2 -tvf %DIR_WITH_SCRIPTS%\%FILE_TO_PROCESS%
set RC=%ERRORLEVEL%
echo "Import of %FILE_TO_PROCESS% returned rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )


rem Add the triggers which use DB SPECIFIC SQL!
rem NB. NOTE THAT the command is *NOT* "db2 -tvf ..." IT IS "db2 -vf ..." this is to avoid problems with the ";" character.
set FILE_TO_PROCESS=uddi30crt_50_triggers_db2udb.sql
db2 -vf %DIR_WITH_SCRIPTS%\%FILE_TO_PROCESS%
set RC=%ERRORLEVEL%
echo "Import of %FILE_TO_PROCESS% returned rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )


rem Insert any initial static data
set FILE_TO_PROCESS=uddi30crt_60_insert_initial_static_data.sql
db2 -tvf %DIR_WITH_SCRIPTS%\%FILE_TO_PROCESS%
set RC=%ERRORLEVEL%
echo "Import of %FILE_TO_PROCESS% returned rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )



rem Optionally set the database as default
if %DEFAULT_DATABASE%==1 goto LABEL_MakeDefaultDatabase
goto LABEL_SKIP_DEFAULT

:LABEL_MakeDefaultDatabase
echo .
echo Creating a default profile
echo.

rem Insert Default Profile indicator
set FILE_TO_PROCESS=uddi30crt_70_insert_default_database_indicator.sql
db2 -tvf %DIR_WITH_SCRIPTS%\%FILE_TO_PROCESS%
set RC=%ERRORLEVEL%
echo "Import of %FILE_TO_PROCESS% returned rc: %RC%"
rem if %RC% GTR 0 ( goto LABEL_BadExit )
:LABEL_SKIP_DEFAULT

rem CLOSE CONNECTIONS TO DATABASE

db2 connect reset
set RC=%ERRORLEVEL%
echo "Connect reset returned rc: %RC%"
if %RC% GTR 0 ( goto LABEL_BadExit )

db2 terminate
set RC=%ERRORLEVEL%
echo "Terminate returned rc: %RC%"
if %RC% GTR 0 ( goto LABEL_BadExit )

rem If we got this far, we now jump to the good exit point
goto LABEL_GoodExit


:LABEL_BadParameters
echo.
echo ERROR in uddi30crt_0_db_db2udb.bat
echo.
echo Parameters missing/incorrect:
echo.
echo parameters are: 1=dir holding scripts
echo                 2=database name
echo                 3=db2 userid
echo                 4=db2 password
echo     (optional)  5="default"
echo.
goto LABEL_AllDone


:LABEL_GoodExit
echo "Exiting script with good ret code"
endlocal
goto LABEL_AllDone

:LABEL_BadExit
echo "Exiting script with error ret code"
endlocal



rem use exit if OS supports it
VER | find "2000" > nul
IF not errorlevel 1 exit 1
VER | find "XP" > nul
IF not errorlevel 1 exit 1
rem default if OS/shell not recognised
verify other 2 > NUL 2>&1

:LABEL_AllDone
