#!/bin/sh
echo "If you are using DB2 v8, errors from the next statement can be ignored"
db2set | grep DB2_INDEX_2BYTEVARLEN || db2set DB2_INDEX_2BYTEVARLEN=YES
db2set | grep DB2CODEPAGE || db2set DB2CODEPAGE=1208

#Note: Changes to settings take effect after the instance has been restarted.               
echo "Calling db2 connect reset"
db2 connect reset
RESULT=$?
if [ ${RESULT} != 0 ]; then
  echo ERROR: DB2 Failed to reset connection. RC:${RESULT}
  exit 1
fi

echo "Terminating db2."
db2 terminate
RESULT=$?
if [ ${RESULT} != 0 ]; then
  echo ERROR: DB2 Failed to terminate on request. RC:${RESULT}
  exit 1
fi

echo "Force application all."
db2 force application all
RESULT=$?
if [ ${RESULT} != 0 ]; then
  echo DB2 Force application all RC:${RESULT}
#  exit 1
fi

echo "Sleeping 5 seconds to allow force to exec"
sleep 5

echo "Calling db2 terminate, fail ok"
db2 terminate
RESULT=$?
echo DB2 terminate RC:${RESULT}

echo "db2stop"
db2stop
RESULT=$?
if [ ${RESULT} != 0 ]; then
  echo ERROR: DB2STOP RC:${RESULT}
  exit 1
fi

echo "Sleeping 5 seconds to allow db2stop to take effect"
sleep 5

echo "db2start"
db2start
RESULT=$?
if [ ${RESULT} != 0 ]; then  
  echo DB2START RC:${RESULT}
  sleep 5
  db2start
  if [ $? != 0 ]; then 
    db2start
  fi
  sleep 5
  if [ $? != 0 ]; then 
    db2start
  fi
  sleep 5
  if [ $? != 0 ]; then 
    db2start
  fi
  sleep 5
  if [ $? != 0 ]; then 
    echo DB2START FAILED RC:${RESULT}
    exit 1
  fi  
  echo DB2START extended processing complete
fi
