# parameters are: 1=dir holding scripts 2=database name, 3=db2 userid, 4=db2 password, 5="default" (optional)
# $6=<RAD_install>/rwd/eclipse/plugins/com.ibm.etools.webservice.uddi.registry.v6_6.0.0/UDDIReg/scripts/

echo $1
echo $2
echo $3
echo $4
echo $5
if [ "$4" = "" -o "$3" = "" -o "$2" = "" -o "$1" = "" ] ; then
    echo
    echo "ERROR in uddi30crt_0_db_db2udb.sh"
    echo
    echo "Parameters missing:"
    echo
    echo "parameters are: 1=dir holding scripts"
    echo "                2=database name"
    echo "                3=db2 userid"
    echo "                4=db2 password"
    echo "    (optional)  5=\"default\""
    echo
    exit 1
fi

if [ "$5" == "default" ] ; then
    export DEFAULT_DATABASE=1
elif [ "$5" == "" ] ; then
    export DEFAULT_DATABASE=0
else
    echo "5th paramter must be specified as \"default\" or not at all"
    sh $0
    exit 1
fi

export DIR_WITH_SCRIPTS=$1
export DATABASE_NAME=$2
export DB2_USERID=$3
export DB2_PWD=$4
export PLUGIN_SCRIPT_DIR=$6

export DB2_USER_TMP=/tmp/$$
mkdir $DB2_USER_TMP

# make sure all scripts are in unix format
cd $DIR_WITH_SCRIPTS
#dos2unix *.sql *.sh
#chmod 755 *.sh

# first test if there is DB2CODEPAGE set already
db2set DB2CODEPAGE >/dev/null 2>&1
if [ $? = 0 ] ; then
  #for /f "tokens=1" %%o in ('db2set DB2CODEPAGE') do (
    o=`db2set DB2CODEPAGE`
    echo "DB2 Codepage is already set to : $o"
    if [ "$o" != "1208" -a "$o" != "UTF-8" ] ; then
   echo "Incompatible DB2 Codepage $o already set"
   echo "DB2CODEPAGE must be 1208 or UTF-8, ie db2set DB2CODEPAGE 1208"
   exit 1
    fi
fi

# Evaluate if we need to set the db2set vars
#for /F "delims== tokens=1" %%v in ('db2set') do (
#    if "%%v" == "DB2_INDEX_2BYTEVARLEN" (
#        export INDEX_VAR_ALREADY_SET=true
#    ) else if "%%v" == "DB2CODEPAGE" (
#        export CODEPAGE_VAR_ALREADY_SET=true
#    )
#)
#
#export CODEPAGE_VAR_ALREADY_EXPORT=false
#for /F "delims== tokens=1" %%v in ('db2set') do (
#    if "%%v" == "DB2CODEPAGE" (
#        export CODEPAGE_VAR_ALREADY_EXPORT=true
#    )
#)
#
#if not "%INDEX_VAR_ALREADY_EXPORT%" == "true" (
#    call %DIR_WITH_SCRIPTS%\exportDB2ProfileVariables
#) else if not "%CODEPAGE_VAR_ALREADY_EXPORT%" == "true" (
#    call %DIR_WITH_SCRIPTS%\exportDB2ProfileVariables
#)
db2set | grep DB2_INDEX_2BYTEVARLEN || ${PLUGIN_SCRIPT_DIR}setDB2ProfileVariables.sh
db2set | grep DB2CODEPAGE || ${PLUGIN_SCRIPT_DIR}setDB2ProfileVariables.sh


# CREATE NEW DATABASE

echo db2 create database $DATABASE_NAME using codeset UTF-8 territory en
db2 create database $DATABASE_NAME using codeset UTF-8 territory en
export rc=$?
echo "Create database returned rc: $rc"
if [ $rc -gt 0 ] ; then exit 1 ; fi

echo db2 connect to $DATABASE_NAME user $DB2_USERID using '********'
db2 connect to $DATABASE_NAME user $DB2_USERID using $DB2_PWD
export rc=$?
echo "Authorised connect returned rc: $rc"
if [ $rc -gt 0 ] ; then exit 1 ; fi


# CONFIGURE NEW DATABASE

# Call the db2 update cmd, and accept rc=0 or SQL1363W as ok.
db2 update db cfg for $DATABASE_NAME using applheapsz 2048 > $DB2_USER_TMP/udcahs.log 2>&1
export rc=$?
echo "Update applheapsz rc: $rc"

echo "--Inserted udcahs.log--"
cat $DB2_USER_TMP/udcahs.log
echo "--End Inserted udcahs.log--"

# check for mustrestart warning
echo "Using grep to find SQL1363W in udcahs.log"
grep "SQL1363W" $DB2_USER_TMP/udcahs.log
export FINDrc=$?
echo "FINDrc was $FINDrc"

echo "Removing udcahs.log"
rm $DB2_USER_TMP/udcahs.log

# rc of 0 is good, rc of non zero is bad if we DONT find SQL1363W
if [ $rc -gt 0 ] ; then
    if [ $FINDrc -ne 0 ] ; then
   exit 1
    fi
fi


# Call the db2 update cmd, and accept rc=0 or SQL1363W as ok.
db2 update db cfg for $DATABASE_NAME using logfilsiz 8192 > $DB2_USER_TMP/udclfs.log 2>&1
export rc=$?
echo "Update logfilesz returned rc: $rc"

echo "--Inserted udclfs.log--"
cat $DB2_USER_TMP/udclfs.log
echo "--End Inserted udclfs.log--"

# check for mustrestart warning
echo "Using grep to find SQL1363W in udclfs.log"
grep "SQL1363W" $DB2_USER_TMP/udclfs.log
export FINDrc=$?
echo "FINDrc was $FINDrc"

echo "Removing udclfs.log"
rm $DB2_USER_TMP/udclfs.log

rm $DB2_USER_TMP -Rf

# rc of 0 is good, rc of non zero is bad if we DONT find SQL1363W
if [ $rc -gt 0 ] ; then
    if [ $FINDrc -ne 0 ] ; then
   exit 1
    fi
fi


# ACTIVATE NEW CONFIGURATION

db2 connect reset
export rc=$?
echo "Connect reset returned rc: $rc"
if [ $rc -gt 0 ] ; then exit 1 ; fi

db2 terminate
export rc=$?
echo "Terminate returned rc: $rc"
if [ $rc -gt 0 ] ; then exit 1 ; fi

echo db2 connect to $DATABASE_NAME user $DB2_USERID using '******'
db2 connect to $DATABASE_NAME user $DB2_USERID using $DB2_PWD
export rc=$?
echo "Authorised connect returned rc: $rc"
if [ $rc -gt 0 ] ; then exit 1 ; fi

# CREATE BUFFERPOOL

db2 CREATE BUFFERPOOL uddibp size 250 PAGESIZE 32K
export rc=$?
echo "Create bufferpool uddibp returned rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi

# ACTIVATE BUFFERPOOL

db2 connect reset
export rc=$?
echo "Connect reset returned rc: $rc"
if [ $rc -gt 0 ] ; then exit 1 ; fi

db2 terminate
export rc=$?
echo "Terminate returned rc: $rc"
if [ $rc -gt 0 ] ; then exit 1 ; fi

db2 force application all
export rc=$?
echo "Force application all rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi

db2 terminate
export rc=$?
echo "Terminate returned rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi

db2stop
export rc=$?
echo "db2stop returned rc: $rc"
if [ $rc -gt 0 ] ; then exit 1 ; fi

echo delaying before dbstart
sleep 32

db2start
export rc=$?
echo "db2start returned rc: $rc"
if [ $rc -gt 0 ] ; then
  db2start
  if [ $? -gt 0 ] ; then db2start ; fi
  if [ $? -gt 0 ] ; then db2start ; fi
  if [ $? -gt 0 ] ; then db2start ; fi
  if [ $? -gt 0 ] ; then
    echo "ERROR: db2 failed to restart"
    exit 1
  fi
  echo "dbstart extended processing complete"
fi

echo db2 connect to $DATABASE_NAME user $DB2_USERID using '******'
db2 connect to $DATABASE_NAME user $DB2_USERID using $DB2_PWD

export rc=$?
echo "Authorised connect returned rc: $rc"
if [ $rc -gt 0 ] ; then exit 1 ; fi

# CREATE TABLESPACES

db2 create regular tablespace uddits pagesize 32k managed by system using \(\'uddidb\'\) extentsize 64 prefetchsize 32 bufferpool uddibp
export rc=$?
echo "create tablespace returned rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi

db2 CREATE SYSTEM TEMPORARY TABLESPACE UDDIBP_SYS_TEMP PAGESIZE 32 K  MANAGED BY SYSTEM  USING \(\'uddibp_sys_temp\'\) EXTENTSIZE 32 OVERHEAD 14.06 PREFETCHSIZE 32 TRANSFERRATE 0.33 BUFFERPOOL UDDIBP
export rc=$?
echo "create tablespace bufferpool returned rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi

# CREATE THE DATABASE STUCTURES

export FILE_TO_PROCESS=uddi30crt_10_prereq_db2.sql
db2 -tvf $DIR_WITH_SCRIPTS/$FILE_TO_PROCESS
export rc=$?
echo "Import of $FILE_TO_PROCESS returned rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi


export FILE_TO_PROCESS=uddi30crt_20_tables_generic.sql
db2 -tvf $DIR_WITH_SCRIPTS/$FILE_TO_PROCESS
export rc=$?
echo "Import of $FILE_TO_PROCESS returned rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi


export FILE_TO_PROCESS=uddi30crt_25_tables_db2udb.sql
db2 -tvf $DIR_WITH_SCRIPTS/$FILE_TO_PROCESS
export rc=$?
echo "Import of $FILE_TO_PROCESS returned rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi


export FILE_TO_PROCESS=uddi30crt_30_constraints_generic.sql
db2 -tvf $DIR_WITH_SCRIPTS/$FILE_TO_PROCESS
export rc=$?
echo "Import of $FILE_TO_PROCESS returned rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi


export FILE_TO_PROCESS=uddi30crt_35_constraints_db2udb.sql
db2 -tvf $DIR_WITH_SCRIPTS/$FILE_TO_PROCESS
export rc=$?
echo "Import of $FILE_TO_PROCESS returned rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi


export FILE_TO_PROCESS=uddi30crt_40_views_generic.sql
db2 -tvf $DIR_WITH_SCRIPTS/$FILE_TO_PROCESS
export rc=$?
echo "Import of $FILE_TO_PROCESS returned rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi


export FILE_TO_PROCESS=uddi30crt_45_views_db2udb.sql
db2 -tvf $DIR_WITH_SCRIPTS/$FILE_TO_PROCESS
export rc=$?
echo "Import of $FILE_TO_PROCESS returned rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi



# NB. NOTE THAT the command is *NOT* "db2 -tvf ..." IT IS "db2 -vf ..." this is to avoid problems with the ";" character.
export FILE_TO_PROCESS=uddi30crt_50_triggers_db2udb.sql
db2 -vf $DIR_WITH_SCRIPTS/$FILE_TO_PROCESS
export rc=$?
echo "Import of $FILE_TO_PROCESS returned rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi


export FILE_TO_PROCESS=uddi30crt_60_insert_initial_static_data.sql
db2 -tvf $DIR_WITH_SCRIPTS/$FILE_TO_PROCESS
export rc=$?
echo "Import of $FILE_TO_PROCESS returned rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi


# Optionally set the database as default
if [ $DEFAULT_DATABASE == 1 ] ; then
    echo
    echo "Creating a default profile"
    echo
export FILE_TO_PROCESS=uddi30crt_70_insert_default_database_indicator.sql
db2 -tvf $DIR_WITH_SCRIPTS/$FILE_TO_PROCESS
export rc=$?
echo "Import of $FILE_TO_PROCESS returned rc: $rc"
# if [ $rc -gt 0 ] ; then exit 1 ; fi
fi

# CLOSE CONNECTIONS TO DATABASE

db2 connect reset
export rc=$?
echo "Connect reset returned rc: $rc"
if [ $rc -gt 0 ] ; then exit 1 ; fi

db2 terminate
export rc=$?
echo "Terminate returned rc: $rc"
if [ $rc -gt 0 ] ; then exit 1 ; fi

echo "Exiting script with good ret code"
