/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.ui.internal.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyPlatformLoadListener;

public class MigrateWSIBSPpreferencesLoadListener
implements IPolicyPlatformLoadListener {
    private static final String[] ENUM_ID_VALUES = new String[]{"org.eclipse.wst.sug.require", "org.eclipse.wst.sug.suggest", "org.eclipse.wst.sug.ignore"};
    private static final String[] CONTEXT_IDS = new String[]{"0", "1", "2"};

    public void load() {
        IEclipsePreferences preferences = new InstanceScope().getNode("org.eclipse.wst.ws.service.policy");
        String bspValue = preferences.get("org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsibsp.value", null);
        Preferences oldPrefs = WSPlugin.getInstance().getPluginPreferences();
        String[] oldPropNames = oldPrefs.propertyNames();
        if (bspValue == null) {
            ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
            IServicePolicy bspPolicy = platform.getServicePolicy("org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsibsp");
            IPolicyState bspState = bspPolicy.getPolicyState();
            if (this.indexOfString("nonWSIBSPCompliance", oldPropNames) != -1) {
                String oldBSPValue = oldPrefs.getString("nonWSIBSPCompliance");
                int oldBSPIndex = this.indexOfString(oldBSPValue, CONTEXT_IDS);
                String newBSPValue = null;
                if (oldBSPIndex < ENUM_ID_VALUES.length) {
                    newBSPValue = ENUM_ID_VALUES[oldBSPIndex];
                }
                if (newBSPValue != null) {
                    bspState.putValue("default.value.key", newBSPValue);
                }
            }
            QualifiedName name = new QualifiedName("com.ibm.ast.ws.ui", "nonWSIBSPCompliance");
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                try {
                    IProject project = projects[i];
                    String oldProperty = null;
                    oldProperty = project.getPersistentProperty(name);
                    if (oldProperty != null && !oldProperty.equals("")) {
                        int oldBSPIndex = this.indexOfString(oldProperty, CONTEXT_IDS);
                        String newBSPValue = null;
                        if (oldBSPIndex != -1 && oldBSPIndex < ENUM_ID_VALUES.length) {
                            newBSPValue = ENUM_ID_VALUES[oldBSPIndex];
                        }
                        if (newBSPValue != null) {
                            bspState = bspPolicy.getPolicyState(project);
                            platform.setProjectPreferencesEnabled(project, true);
                            bspState.putValue("default.value.key", newBSPValue);
                        }
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
    }

    private int indexOfString(String target, String[] values) {
        int result = -1;
        int index = 0;
        while (index < values.length) {
            String value = values[index];
            if (value.equals(target)) {
                result = index;
                break;
            }
            ++index;
        }
        return result;
    }
}

