/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.service.policy.ui;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IPolicyStateEnum;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;
import org.osgi.framework.Bundle;

public class PolicySetUtils {
    public static final String LOCAL = "local:";
    public static final String POLICY_SET_CATEGORY_V61 = "com.ibm.ast.ws.service.policy.ui.policyset.category";
    public static final String POLICY_SET_CATEGORY_V7 = "com.ibm.ast.ws.service.policy.ui.policyset.category70";
    public static final String POLICY_SET_CATEGORY_SYS = "com.ibm.ast.ws.service.policy.ui.policyset.category70.sys";

    public static List<IServicePolicy> getPolicySets(String kindFilter) {
        return PolicySetUtils.getCategoryPolicies(kindFilter);
    }

    public static List<IServicePolicy> getCategoryPolicies(String category) {
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        IServicePolicy wasServiceCategory = platform.getServicePolicy(category);
        Vector<Object> policySets = null;
        policySets = wasServiceCategory == null ? new Vector<IServicePolicy>() : new Vector(wasServiceCategory.getChildren());
        return policySets;
    }

    public static List<IServicePolicy> getPolicies(IServicePolicy policySet) {
        return policySet.getChildren();
    }

    public static String getLocalRootPath() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.ast.ws.service.policy.ui");
        IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
        return stateLocation.toString();
    }

    public static String getPolicyPath(IServicePolicy policy) {
        IPolicyState state = policy.getPolicyState();
        String policyPath = state.getValue("policyPath");
        return policyPath;
    }

    public static IServicePolicy getDefaultPolicySet(IProject project, String kind) {
        return PolicySetUtils.getDefaultCategoryPolicy(kind, project);
    }

    public static IServicePolicy getDefaultCategoryPolicy(String category, IProject project) {
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        IServicePolicy wasServiceCategory = platform.getServicePolicy(category);
        List policySets = wasServiceCategory.getChildren();
        IServicePolicy defaultPolicySet = null;
        for (IServicePolicy policySet : policySets) {
            IPolicyStateEnum state;
            IPolicyStateEnum iPolicyStateEnum = state = project == null ? policySet.getPolicyStateEnum() : policySet.getPolicyStateEnum(project);
            if (!state.getCurrentItem().getId().equals("org.eclipse.wst.true")) continue;
            defaultPolicySet = policySet;
            break;
        }
        return defaultPolicySet;
    }
}

