/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.service.policy.ui;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IPolicyStateEnum;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyChildChangeListener;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyPlatformProjectLoadListener;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyStateChangeListener;

public class DefaultServicePoliciesUtils
implements IPolicyPlatformProjectLoadListener {
    private String[] categoriesToManage;
    private boolean enabled = true;
    private List<IProject> projectList = new Vector<IProject>();

    public DefaultServicePoliciesUtils(String[] categoriesToManage) {
        this.categoriesToManage = categoriesToManage;
    }

    public void load() {
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        this.checkForNoDefault(platform, null);
        platform.addProjectLoadListener((IPolicyPlatformProjectLoadListener)this);
        this.addPolicyListeners(platform, null);
        this.addChildChangeListener(platform);
    }

    public void load(IProject project) {
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        this.addPolicyListeners(platform, project);
        this.removeProjectDuplicates(project);
        this.projectList.add(project);
    }

    private boolean isIdManaged(String id) {
        String[] stringArray = this.categoriesToManage;
        int n = this.categoriesToManage.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            if (id.equals(category)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addListenersForNewChild(IServicePolicy policy) {
        IPolicyState state = policy.getPolicyState();
        state.addPolicyStateChangeListener((IPolicyStateChangeListener)new StateChangeListener(null), false);
        for (IProject project : this.projectList) {
            if (!project.exists() || !project.isOpen()) continue;
            IPolicyState projectState = policy.getPolicyState(project);
            projectState.addPolicyStateChangeListener((IPolicyStateChangeListener)new StateChangeListener(project), false);
        }
    }

    private void addPolicyListeners(ServicePolicyPlatform platform, IProject project) {
        String[] stringArray = this.categoriesToManage;
        int n = this.categoriesToManage.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            IServicePolicy policyCategory = platform.getServicePolicy(category);
            List children = policyCategory.getChildren();
            for (IServicePolicy policy : children) {
                IPolicyState state = project == null ? policy.getPolicyState() : policy.getPolicyState(project);
                state.addPolicyStateChangeListener((IPolicyStateChangeListener)new StateChangeListener(project), false);
                if (project != null) continue;
                state.addPolicyStateChangeListener((IPolicyStateChangeListener)new UpdateProjectsCommitListener(), true);
            }
            ++n2;
        }
    }

    private void checkForNoDefault(ServicePolicyPlatform platform, IProject project) {
        String[] stringArray = this.categoriesToManage;
        int n = this.categoriesToManage.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            IServicePolicy policyCategory = platform.getServicePolicy(category);
            this.checkForNoDefault(platform, project, policyCategory);
            ++n2;
        }
    }

    private void checkForNoDefault(ServicePolicyPlatform platform, IProject project, IServicePolicy policyCategory) {
        boolean foundDefault;
        boolean bl = foundDefault = this.getDefaultServicePolicy(policyCategory, project, null) != null;
        if (!foundDefault) {
            IPolicyState categoryState = policyCategory.getPolicyState();
            String defaultPolicy = categoryState.getValue("defaultPolicy");
            IServicePolicy servicePolicy = platform.getServicePolicy(defaultPolicy);
            IPolicyStateEnum policyState = project == null ? servicePolicy.getPolicyStateEnum() : servicePolicy.getPolicyStateEnum(project);
            policyState.setCurrentItem("org.eclipse.wst.true");
        }
    }

    private IServicePolicy getDefaultServicePolicy(IServicePolicy category, IProject project, IServicePolicy excludePolicy) {
        IServicePolicy result = null;
        List children = category.getChildren();
        for (IServicePolicy policy : children) {
            IPolicyStateEnum state;
            IPolicyStateEnum iPolicyStateEnum = state = project == null ? policy.getPolicyStateEnum() : policy.getPolicyStateEnum(project);
            if (!state.getCurrentItem().getId().equals("org.eclipse.wst.true") || policy == excludePolicy) continue;
            result = policy;
            break;
        }
        return result;
    }

    private void removeProjectDuplicates(IProject project) {
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        boolean changeFound = false;
        String[] stringArray = this.categoriesToManage;
        int n = this.categoriesToManage.length;
        int n2 = 0;
        while (n2 < n) {
            IPolicyStateEnum projectState;
            String category = stringArray[n2];
            IServicePolicy categoryPolicy = platform.getServicePolicy(category);
            List children = categoryPolicy.getChildren();
            Vector<IServicePolicy> dups = new Vector<IServicePolicy>();
            IServicePolicy workspacePolicy = this.getDefaultServicePolicy(categoryPolicy, null, null);
            IServicePolicy firstPolicy = null;
            for (IServicePolicy policy : children) {
                projectState = policy.getPolicyStateEnum(project);
                if (!projectState.getCurrentItem().getId().equals("org.eclipse.wst.true")) continue;
                dups.add(policy);
            }
            if (dups.size() > 1) {
                for (IServicePolicy policy : dups) {
                    if (firstPolicy == null && policy != workspacePolicy) {
                        firstPolicy = policy;
                    }
                    if (policy == firstPolicy) continue;
                    projectState = policy.getPolicyStateEnum(project);
                    projectState.setCurrentItem("org.eclipse.wst.false");
                    changeFound = true;
                }
            }
            ++n2;
        }
        if (changeFound) {
            platform.commitChanges(project);
        }
    }

    private void addChildChangeListener(ServicePolicyPlatform platform) {
        platform.addChildChangeListener((IPolicyChildChangeListener)new ImmediateChildChangeListener(), false);
        platform.addChildChangeListener((IPolicyChildChangeListener)new CommitChildChangeListener(), true);
    }

    private class CommitChildChangeListener
    implements IPolicyChildChangeListener {
        private CommitChildChangeListener() {
        }

        public void childChange(List<IServicePolicy> childList, List<Boolean> addedList) {
            ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
            int index = 0;
            while (index < childList.size()) {
                IServicePolicy child = childList.get(index);
                boolean added = addedList.get(index);
                IServicePolicy parent = child.getParentPolicy();
                if (parent != null && DefaultServicePoliciesUtils.this.isIdManaged(parent.getId())) {
                    if (added) {
                        DefaultServicePoliciesUtils.this.addListenersForNewChild(child);
                        for (IProject project : DefaultServicePoliciesUtils.this.projectList) {
                            if (!project.exists() || !project.isOpen()) continue;
                            DefaultServicePoliciesUtils.this.removeProjectDuplicates(project);
                            platform.commitChanges(project);
                        }
                    } else {
                        for (IProject project : DefaultServicePoliciesUtils.this.projectList) {
                            if (!project.exists() || !project.isOpen()) continue;
                            DefaultServicePoliciesUtils.this.checkForNoDefault(platform, project, parent);
                            platform.commitChanges(project);
                        }
                    }
                }
                ++index;
            }
        }
    }

    private class ImmediateChildChangeListener
    implements IPolicyChildChangeListener {
        private ImmediateChildChangeListener() {
        }

        public void childChange(List<IServicePolicy> childList, List<Boolean> addedList) {
            ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
            int index = 0;
            while (index < childList.size()) {
                IServicePolicy child = childList.get(index);
                boolean added = addedList.get(index);
                IServicePolicy parent = child.getParentPolicy();
                if (parent != null && DefaultServicePoliciesUtils.this.isIdManaged(parent.getId()) && !added) {
                    DefaultServicePoliciesUtils.this.checkForNoDefault(platform, null, parent);
                }
                ++index;
            }
        }
    }

    private class StateChangeListener
    implements IPolicyStateChangeListener {
        private IProject project;

        public StateChangeListener(IProject project) {
            this.project = project;
        }

        public void policyStateChange(IServicePolicy policy, String key, String oldValue, String newValue) {
            if (key.equals("default.value.key") && DefaultServicePoliciesUtils.this.enabled) {
                DefaultServicePoliciesUtils.this.enabled = false;
                IServicePolicy category = policy.getParentPolicy();
                IServicePolicy previousDefault = DefaultServicePoliciesUtils.this.getDefaultServicePolicy(category, this.project, policy);
                if (previousDefault == null) {
                    IPolicyStateEnum state = this.project == null ? policy.getPolicyStateEnum() : policy.getPolicyStateEnum(this.project);
                    state.setCurrentItem("org.eclipse.wst.true");
                } else {
                    IPolicyStateEnum state = this.project == null ? previousDefault.getPolicyStateEnum() : previousDefault.getPolicyStateEnum(this.project);
                    state.setCurrentItem("org.eclipse.wst.false");
                }
                DefaultServicePoliciesUtils.this.enabled = true;
            }
        }
    }

    private class UpdateProjectsCommitListener
    implements IPolicyStateChangeListener {
        private UpdateProjectsCommitListener() {
        }

        public void policyStateChange(IServicePolicy policy, String key, String oldValue, String newValue) {
            if (key.equals("default.value.key") && DefaultServicePoliciesUtils.this.enabled) {
                DefaultServicePoliciesUtils.this.enabled = false;
                for (IProject project : DefaultServicePoliciesUtils.this.projectList) {
                    if (!project.exists() || !project.isOpen()) continue;
                    DefaultServicePoliciesUtils.this.removeProjectDuplicates(project);
                }
                DefaultServicePoliciesUtils.this.enabled = true;
            }
        }
    }
}

