/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.internal.service.policy.ui;

import com.ibm.ast.ws.internal.service.policy.ui.AbstractQOSWizardPage;
import com.ibm.ast.ws.internal.service.policy.ui.Messages;
import com.ibm.ast.ws.internal.service.policy.ui.utils.ImportEntry;
import com.ibm.ast.ws.internal.service.policy.ui.utils.ZipUtils;
import com.ibm.ast.ws.service.policy.ui.ASTServicePolicyActivator;
import com.ibm.ast.ws.service.policy.ui.ServiceUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.ws.service.policy.IDescriptor;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;
import org.osgi.framework.Bundle;

public class QOSImportWizard
extends Wizard
implements IImportWizard {
    private ZipFile zipFile;
    private Map<String, ImportEntry> policySetsTable;
    private AbstractQOSWizardPage wizardPage = this.createPage();
    private static final String APP_TYPE = "application";
    private static final String SYS_TYPE = "system";
    private static final String TRUST_TYPE = "system/trust";
    private static final String V6_VERSION = "6.1.0.0";
    private static final String V7_VERSION = "7.0.0";

    public QOSImportWizard() {
        this.addPage((IWizardPage)this.wizardPage);
        try {
            Bundle bundle = Platform.getBundle((String)"com.ibm.ast.ws.service.policy.ui");
            URL installURL = bundle.getEntry("/");
            URL imageURL = new URL(installURL, "icons/wizban/ImportPolicySet.gif");
            ImageDescriptor image = ImageDescriptor.createFromURL((URL)imageURL);
            if (image != null) {
                this.setDefaultPageImageDescriptor(image);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        this.setWindowTitle(Messages.QOSImportWizard_0);
    }

    public boolean performFinish() {
        return this.importPolicySets();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private AbstractQOSWizardPage createPage() {
        return new AbstractQOSWizardPage(Messages.QOSImportWizard_1, true){

            @Override
            public IStatus textChanged(String fileName) {
                Status errorMessage = null;
                try {
                    QOSImportWizard.this.zipFile = new ZipFile(fileName);
                    QOSImportWizard.this.policySetsTable = new HashMap();
                    ZipUtils.getPolicyEntries(QOSImportWizard.this.zipFile, QOSImportWizard.this.policySetsTable);
                    this.setErrorMessage(null);
                    QOSImportWizard.this.wizardPage.setPolicySetViewerInput(QOSImportWizard.this.policySetsTable.values());
                }
                catch (ZipException exc) {
                    errorMessage = new Status(4, "com.ibm.ast.ws.service.policy.ui", exc.getMessage());
                    QOSImportWizard.this.wizardPage.setPolicySetViewerInput(new Vector());
                }
                catch (IOException exc) {
                    errorMessage = new Status(4, "com.ibm.ast.ws.service.policy.ui", exc.getMessage());
                    QOSImportWizard.this.wizardPage.setPolicySetViewerInput(new Vector());
                }
                return errorMessage;
            }

            @Override
            public IStatus selectionChanged(CheckStateChangedEvent event) {
                String statusMessage;
                Iterator iterator;
                IStatus toReturn = Status.OK_STATUS;
                List lOverwrite = QOSImportWizard.this.policiesThatMustBeOverwritten();
                List lCannotOverwrite = QOSImportWizard.this.policiesThatCannotBeImported();
                String warningPolicies = "";
                String cannotOverwritePolicies = "";
                if (!lOverwrite.isEmpty()) {
                    warningPolicies = "";
                    iterator = lOverwrite.iterator();
                    while (iterator.hasNext()) {
                        warningPolicies = String.valueOf(warningPolicies) + ((IServicePolicy)iterator.next()).getDescriptor().getLongName();
                        if (!iterator.hasNext()) continue;
                        warningPolicies = String.valueOf(warningPolicies) + ", ";
                    }
                }
                if (!lCannotOverwrite.isEmpty()) {
                    cannotOverwritePolicies = "";
                    iterator = lCannotOverwrite.iterator();
                    while (iterator.hasNext()) {
                        cannotOverwritePolicies = String.valueOf(cannotOverwritePolicies) + ((IServicePolicy)iterator.next()).getDescriptor().getLongName();
                        if (!iterator.hasNext()) continue;
                        cannotOverwritePolicies = String.valueOf(cannotOverwritePolicies) + ", ";
                    }
                }
                if (!lOverwrite.isEmpty() & lCannotOverwrite.isEmpty()) {
                    statusMessage = Messages.bind((String)Messages.QOSImportWizard_4, (Object[])new String[]{warningPolicies});
                    ASTServicePolicyActivator.getDefault();
                    toReturn = new Status(2, "com.ibm.ast.ws.service.policy.ui", statusMessage);
                } else if (!lCannotOverwrite.isEmpty() && lOverwrite.isEmpty()) {
                    statusMessage = Messages.bind((String)Messages.QOSImportWizard_10, (Object[])new String[]{cannotOverwritePolicies});
                    ASTServicePolicyActivator.getDefault();
                    toReturn = new Status(2, "com.ibm.ast.ws.service.policy.ui", statusMessage);
                } else if (!lOverwrite.isEmpty() && !lCannotOverwrite.isEmpty()) {
                    statusMessage = Messages.bind((String)Messages.QOSImportWizard_11, (Object[])new String[]{warningPolicies, cannotOverwritePolicies});
                    ASTServicePolicyActivator.getDefault();
                    toReturn = new Status(2, "com.ibm.ast.ws.service.policy.ui", statusMessage);
                }
                return toReturn;
            }
        };
    }

    private boolean importPolicySets() {
        boolean result = true;
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        Bundle bundle = Platform.getBundle((String)"com.ibm.ast.ws.service.policy.ui");
        IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
        File rootFile = new File(stateLocation.toString());
        for (ImportEntry policySet : this.policySetsTable.values()) {
            if (!policySet.isSelected()) continue;
            try {
                String[] policyInfo = ZipUtils.getPolicySetInfo(this.zipFile, policySet);
                String[] errorMessage = new String[1];
                IServicePolicy wasServiceCategory = this.getCategory(policyInfo, errorMessage, policySet, platform);
                String description = policyInfo[2];
                if (wasServiceCategory == null) {
                    Status status = new Status(4, "id", errorMessage[0]);
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.QOSImportWizard_3, (String)errorMessage[0], (IStatus)status);
                    result = false;
                    break;
                }
                List policySets = wasServiceCategory.getChildren();
                String uniqueName = policySet.getName();
                ZipEntry zipEntry = policySet.getPolicySetEntry();
                Path currentPath = new Path(this.getZipName(zipEntry));
                IPath newPathPath = new Path(wasServiceCategory.getId()).append(ServiceUtils.getNewPath((IPath)currentPath, uniqueName));
                String newPathString = newPathPath.toString();
                File newFile = new File(rootFile, newPathString);
                boolean immutableAlreadyExists = false;
                for (IServicePolicy policy : policySets) {
                    if (policy.isPredefined() && policy.getDescriptor().getLongName().equals(uniqueName)) {
                        immutableAlreadyExists = true;
                        break;
                    }
                    if (!policy.getDescriptor().getLongName().equals(uniqueName)) continue;
                    ServicePolicyPlatform.getInstance().removeServicePolicy(policy);
                    break;
                }
                if (immutableAlreadyExists) continue;
                IServicePolicy policySetPolicy = this.createModelPolicy(platform, wasServiceCategory, uniqueName, newPathString, true, description);
                ZipUtils.writeEntry(this.zipFile, policySet.getPolicySetEntry(), newFile);
                for (ZipEntry policyType : policySet.getPolicyTypes()) {
                    Path policyPath = new Path(this.getZipName(policyType));
                    IPath newPolicyPathPath = new Path(wasServiceCategory.getId()).append(ServiceUtils.getNewPath((IPath)policyPath, uniqueName));
                    String newPolicyPath = newPolicyPathPath.toString();
                    File newPolicyFile = new File(rootFile, newPolicyPath);
                    String policyName = policyPath.segment(3);
                    ZipUtils.writeEntry(this.zipFile, policyType, newPolicyFile);
                    this.createModelPolicy(platform, policySetPolicy, policyName, newPolicyPath, false, "");
                }
            }
            catch (IOException exc) {
                result = false;
                Status status = new Status(4, "id", exc.getMessage());
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.QOSImportWizard_2, (String)exc.getMessage(), (IStatus)status);
            }
        }
        if (result) {
            platform.commitChanges();
        }
        return result;
    }

    private List<IServicePolicy> policiesThatCannotBeImported() {
        Vector<IServicePolicy> vCannotImport = new Vector<IServicePolicy>();
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        for (ImportEntry policySet : this.policySetsTable.values()) {
            if (!policySet.isSelected()) continue;
            try {
                String[] policyInfo = ZipUtils.getPolicySetInfo(this.zipFile, policySet);
                String[] errorMessage = new String[1];
                IServicePolicy wasServiceCategory = this.getCategory(policyInfo, errorMessage, policySet, platform);
                List policySets = wasServiceCategory.getChildren();
                for (IServicePolicy policy : policySets) {
                    String name = policySet.getName();
                    if (!policy.isPredefined() || !policy.getDescriptor().getLongName().equals(name)) continue;
                    vCannotImport.add(policy);
                }
            }
            catch (IOException iOException) {}
        }
        return vCannotImport;
    }

    private List<IServicePolicy> policiesThatMustBeOverwritten() {
        Vector<IServicePolicy> vOverwrite = new Vector<IServicePolicy>();
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        for (ImportEntry policySet : this.policySetsTable.values()) {
            if (!policySet.isSelected()) continue;
            try {
                String[] policyInfo = ZipUtils.getPolicySetInfo(this.zipFile, policySet);
                String[] errorMessage = new String[1];
                IServicePolicy wasServiceCategory = this.getCategory(policyInfo, errorMessage, policySet, platform);
                List policySets = wasServiceCategory.getChildren();
                for (IServicePolicy policy : policySets) {
                    String name = policySet.getName();
                    if (policy.isPredefined() || !policy.getDescriptor().getLongName().equals(name)) continue;
                    vOverwrite.add(policy);
                }
            }
            catch (IOException iOException) {}
        }
        return vOverwrite;
    }

    private IServicePolicy getCategory(String[] policyInfo, String[] errorMessage, ImportEntry entry, ServicePolicyPlatform platform) {
        IServicePolicy category = null;
        String catId = null;
        String type = policyInfo[0];
        String version = policyInfo[1];
        String entryName = entry.getName();
        if (type.equals(APP_TYPE)) {
            if (version.equals(V6_VERSION) || version.equals("")) {
                catId = "com.ibm.ast.ws.service.policy.ui.policyset.category";
            } else if (version.startsWith(V7_VERSION)) {
                catId = "com.ibm.ast.ws.service.policy.ui.policyset.category70";
            } else {
                errorMessage[0] = Messages.bind((String)Messages.QOSImportWizard_5, (Object[])new String[]{version, entryName});
            }
        } else if (type.equals(SYS_TYPE)) {
            catId = "com.ibm.ast.ws.service.policy.ui.policyset.category70.sys";
        } else {
            errorMessage[0] = type.equals(TRUST_TYPE) ? Messages.bind((String)Messages.QOSImportWizard_6, (Object[])new String[]{entryName}) : Messages.bind((String)Messages.QOSImportWizard_7, (Object[])new String[]{type, entryName});
        }
        category = platform.getServicePolicy(catId);
        if (category == null && errorMessage[0] == null) {
            errorMessage[0] = catId == "com.ibm.ast.ws.service.policy.ui.policyset.category" ? Messages.bind((String)Messages.QOSImportWizard_8, (Object)entryName) : Messages.bind((String)Messages.QOSImportWizard_9, (Object)entryName);
        }
        return category;
    }

    private String getZipName(ZipEntry zipentry) {
        String name = zipentry.getName();
        if (name.indexOf(92) != -1) {
            name = name.replaceAll("\\\\", "/");
        }
        return name;
    }

    private IServicePolicy createModelPolicy(ServicePolicyPlatform platform, IServicePolicy parent, String name, String path, boolean isPolicySet, String description) {
        String idName = isPolicySet ? "qos.policyset" : "policytype";
        String id = "com.ibm.ast.ws.local." + idName + ".id1";
        IServicePolicy newPolicy = platform.createServicePolicy(parent, id, "org.eclipse.wst.service.policy.booleanEnum", "org.eclipse.wst.false");
        IDescriptor descriptor = newPolicy.getDescriptor();
        IPolicyState policyState = newPolicy.getPolicyState();
        descriptor.setShortName(name);
        descriptor.setIconBundleId("com.ibm.ast.ws.service.policy.ui");
        descriptor.setIconPath(isPolicySet ? "icons/obj16/localPolicySet.gif" : "icons/obj16/policytype_obj.gif");
        descriptor.setDescription(description);
        policyState.putValue("policyPath", "local:/" + path);
        return newPolicy;
    }
}

