/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.internal.service.policy.ui;

import com.ibm.ast.ws.internal.service.policy.ui.AbstractQOSWizardPage;
import com.ibm.ast.ws.internal.service.policy.ui.Messages;
import com.ibm.ast.ws.internal.service.policy.ui.utils.ImportEntry;
import com.ibm.ast.ws.internal.service.policy.ui.utils.ZipUtils;
import com.ibm.ast.ws.service.policy.ui.ASTServicePolicyActivator;
import com.ibm.ast.ws.service.policy.ui.ServiceUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.ws.service.policy.IDescriptor;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;
import org.osgi.framework.Bundle;

public class NamedBindingImportWizard
extends Wizard
implements IImportWizard {
    private ZipFile zipFile;
    private Map<String, ImportEntry> namedBindingsTable;
    private AbstractQOSWizardPage wizardPage = this.createPage();

    public NamedBindingImportWizard() {
        this.addPage((IWizardPage)this.wizardPage);
        try {
            Bundle bundle = Platform.getBundle((String)"com.ibm.ast.ws.service.policy.ui");
            URL installURL = bundle.getEntry("/");
            URL imageURL = new URL(installURL, "icons/wizban/ImportNamedBindings.gif");
            ImageDescriptor image = ImageDescriptor.createFromURL((URL)imageURL);
            if (image != null) {
                this.setDefaultPageImageDescriptor(image);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        this.setWindowTitle(Messages.NamedBindingImportWizard_0);
    }

    public boolean performFinish() {
        return this.importNamedBindings();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private AbstractQOSWizardPage createPage() {
        return new AbstractQOSWizardPage(Messages.NamedBindingImportWizard_1, true){

            @Override
            public IStatus textChanged(String fileName) {
                Status errorMessage = null;
                try {
                    NamedBindingImportWizard.this.zipFile = new ZipFile(fileName);
                    NamedBindingImportWizard.this.namedBindingsTable = new HashMap();
                    ZipUtils.getBindingsEntries(NamedBindingImportWizard.this.zipFile, NamedBindingImportWizard.this.namedBindingsTable);
                    this.setErrorMessage(null);
                    NamedBindingImportWizard.this.wizardPage.setPolicySetViewerInput(NamedBindingImportWizard.this.namedBindingsTable.values());
                }
                catch (ZipException exc) {
                    errorMessage = new Status(4, "com.ibm.ast.ws.service.policy.ui", exc.getMessage());
                    NamedBindingImportWizard.this.wizardPage.setPolicySetViewerInput(new Vector());
                }
                catch (IOException exc) {
                    errorMessage = new Status(4, "com.ibm.ast.ws.service.policy.ui", exc.getMessage());
                    NamedBindingImportWizard.this.wizardPage.setPolicySetViewerInput(new Vector());
                }
                return errorMessage;
            }

            @Override
            public IStatus selectionChanged(CheckStateChangedEvent event) {
                String statusMessage;
                Iterator iterator;
                IStatus toReturn = Status.OK_STATUS;
                List lOverwrite = NamedBindingImportWizard.this.policiesThatMustBeOverwritten();
                List lCannotOverwrite = NamedBindingImportWizard.this.policiesThatCannotBeImported();
                String warningPolicies = "";
                String cannotOverwritePolicies = "";
                if (!lOverwrite.isEmpty()) {
                    warningPolicies = "";
                    iterator = lOverwrite.iterator();
                    while (iterator.hasNext()) {
                        warningPolicies = String.valueOf(warningPolicies) + ((IServicePolicy)iterator.next()).getDescriptor().getLongName();
                        if (!iterator.hasNext()) continue;
                        warningPolicies = String.valueOf(warningPolicies) + ", ";
                    }
                }
                if (!lCannotOverwrite.isEmpty()) {
                    cannotOverwritePolicies = "";
                    iterator = lCannotOverwrite.iterator();
                    while (iterator.hasNext()) {
                        cannotOverwritePolicies = String.valueOf(cannotOverwritePolicies) + ((IServicePolicy)iterator.next()).getDescriptor().getLongName();
                        if (!iterator.hasNext()) continue;
                        cannotOverwritePolicies = String.valueOf(cannotOverwritePolicies) + ", ";
                    }
                }
                if (!lOverwrite.isEmpty() & lCannotOverwrite.isEmpty()) {
                    statusMessage = Messages.bind((String)Messages.NamedBindingImportWizard_2, (Object[])new String[]{warningPolicies});
                    ASTServicePolicyActivator.getDefault();
                    toReturn = new Status(2, "com.ibm.ast.ws.service.policy.ui", statusMessage);
                } else if (!lCannotOverwrite.isEmpty() && lOverwrite.isEmpty()) {
                    statusMessage = Messages.bind((String)Messages.NamedBindingImportWizard_3, (Object[])new String[]{cannotOverwritePolicies});
                    ASTServicePolicyActivator.getDefault();
                    toReturn = new Status(2, "com.ibm.ast.ws.service.policy.ui", statusMessage);
                } else if (!lOverwrite.isEmpty() && !lCannotOverwrite.isEmpty()) {
                    statusMessage = Messages.bind((String)Messages.NamedBindingImportWizard_4, (Object[])new String[]{warningPolicies, cannotOverwritePolicies});
                    ASTServicePolicyActivator.getDefault();
                    toReturn = new Status(2, "com.ibm.ast.ws.service.policy.ui", statusMessage);
                }
                return toReturn;
            }
        };
    }

    private boolean importNamedBindings() {
        boolean result = true;
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        IServicePolicy clientCategory = platform.getServicePolicy("com.ibm.ast.ws.service.policy.ui.client.named.binding.category");
        IServicePolicy serverCategory = platform.getServicePolicy("com.ibm.ast.ws.service.policy.ui.server.named.binding.category");
        Bundle bundle = Platform.getBundle((String)"com.ibm.ast.ws.service.policy.ui");
        IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
        File rootFile = new File(stateLocation.toString());
        for (ImportEntry namedBinding : this.namedBindingsTable.values()) {
            IServicePolicy category = null;
            try {
                List bindings;
                boolean isProvider = ZipUtils.isProviderNamedBinding(this.zipFile, namedBinding);
                if (isProvider) {
                    category = serverCategory;
                    bindings = category.getChildren();
                } else {
                    category = clientCategory;
                    bindings = category.getChildren();
                }
                if (!namedBinding.isSelected()) continue;
                String uniqueName = namedBinding.getName();
                ZipEntry zipEntry = namedBinding.getPolicySetEntry();
                Path currentPath = new Path(this.getZipName(zipEntry));
                String newPathString = ServiceUtils.getNewPath((IPath)currentPath, uniqueName);
                File newFile = new File(rootFile, newPathString);
                boolean immutableAlreadyExists = false;
                for (IServicePolicy policy : bindings) {
                    if (policy.isPredefined() && policy.getDescriptor().getLongName().equals(uniqueName)) {
                        immutableAlreadyExists = true;
                        break;
                    }
                    if (!policy.getDescriptor().getLongName().equals(uniqueName)) continue;
                    ServicePolicyPlatform.getInstance().removeServicePolicy(policy);
                    break;
                }
                if (immutableAlreadyExists) continue;
                IServicePolicy policySetPolicy = this.createModelPolicy(platform, category, uniqueName, newPathString, true, isProvider);
                ZipUtils.writeEntry(this.zipFile, namedBinding.getPolicySetEntry(), newFile);
                for (ZipEntry policyType : namedBinding.getPolicyTypes()) {
                    Path policyPath = new Path(this.getZipName(policyType));
                    String newPolicyPath = ServiceUtils.getNewPath((IPath)policyPath, uniqueName);
                    File newPolicyFile = new File(rootFile, newPolicyPath);
                    String policyName = policyPath.segment(3);
                    ZipUtils.writeEntry(this.zipFile, policyType, newPolicyFile);
                    this.createModelPolicy(platform, policySetPolicy, policyName, newPolicyPath, false, isProvider);
                }
            }
            catch (IOException exc) {
                result = false;
                Status status = new Status(4, "id", exc.getMessage());
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.QOSImportWizard_2, (String)exc.getMessage(), (IStatus)status);
            }
        }
        if (result) {
            platform.commitChanges();
        }
        return result;
    }

    private IServicePolicy createModelPolicy(ServicePolicyPlatform platform, IServicePolicy parent, String name, String path, boolean isBinding, boolean isProvider) {
        String idName = isBinding ? "qos.namedbinding" : "bindingpolicytype";
        String id = "com.ibm.ast.ws.local." + idName + ".id1";
        IServicePolicy newPolicy = platform.createServicePolicy(parent, id, "org.eclipse.wst.service.policy.booleanEnum", "org.eclipse.wst.false");
        IDescriptor descriptor = newPolicy.getDescriptor();
        IPolicyState policyState = newPolicy.getPolicyState();
        String iconPath = null;
        iconPath = isBinding ? (isProvider ? "icons/obj16/localServerNamedBinding.gif" : "icons/obj16/localClientNamedBinding.gif") : "icons/obj16/policytype_obj.gif";
        descriptor.setShortName(name);
        descriptor.setIconBundleId("com.ibm.ast.ws.service.policy.ui");
        descriptor.setIconPath(iconPath);
        policyState.putValue("policyPath", "local:/" + path);
        return newPolicy;
    }

    private String getZipName(ZipEntry zipentry) {
        String name = zipentry.getName();
        if (name.indexOf(92) != -1) {
            name = name.replaceAll("\\\\", "/");
        }
        return name;
    }

    private List<IServicePolicy> policiesThatCannotBeImported() {
        Vector<IServicePolicy> vCannotImport = new Vector<IServicePolicy>();
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        IServicePolicy clientCategory = platform.getServicePolicy("com.ibm.ast.ws.service.policy.ui.client.named.binding.category");
        IServicePolicy serverCategory = platform.getServicePolicy("com.ibm.ast.ws.service.policy.ui.server.named.binding.category");
        for (ImportEntry namedBinding : this.namedBindingsTable.values()) {
            if (!namedBinding.isSelected()) continue;
            try {
                boolean isProvider = ZipUtils.isProviderNamedBinding(this.zipFile, namedBinding);
                IServicePolicy category = null;
                category = isProvider ? serverCategory : clientCategory;
                List policySets = category.getChildren();
                for (IServicePolicy policy : policySets) {
                    String name = namedBinding.getName();
                    if (!policy.isPredefined() || !policy.getDescriptor().getLongName().equals(name)) continue;
                    vCannotImport.add(policy);
                }
            }
            catch (IOException iOException) {}
        }
        return vCannotImport;
    }

    private List<IServicePolicy> policiesThatMustBeOverwritten() {
        Vector<IServicePolicy> vOverwrite = new Vector<IServicePolicy>();
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        IServicePolicy clientCategory = platform.getServicePolicy("com.ibm.ast.ws.service.policy.ui.client.named.binding.category");
        IServicePolicy serverCategory = platform.getServicePolicy("com.ibm.ast.ws.service.policy.ui.server.named.binding.category");
        for (ImportEntry namedBinding : this.namedBindingsTable.values()) {
            if (!namedBinding.isSelected()) continue;
            try {
                boolean isProvider = ZipUtils.isProviderNamedBinding(this.zipFile, namedBinding);
                IServicePolicy category = null;
                category = isProvider ? serverCategory : clientCategory;
                List policySets = category.getChildren();
                for (IServicePolicy policy : policySets) {
                    String name = namedBinding.getName();
                    if (policy.isPredefined() || !policy.getDescriptor().getLongName().equals(name)) continue;
                    vOverwrite.add(policy);
                }
            }
            catch (IOException iOException) {}
        }
        return vOverwrite;
    }
}

