/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.internal.service.policy.ui;

import com.ibm.ast.ws.internal.service.policy.ui.AbstractQOSWizardPage;
import com.ibm.ast.ws.internal.service.policy.ui.Messages;
import com.ibm.ast.ws.internal.service.policy.ui.utils.ExportEntry;
import com.ibm.ast.ws.internal.service.policy.ui.utils.ZipUtils;
import com.ibm.ast.ws.service.policy.ui.NamedBindingstUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.osgi.framework.Bundle;

public class NamedBindingExportWizard
extends Wizard
implements IExportWizard {
    private String zipFileName;
    private Collection<ExportEntry> namedBindingTable = this.createPolicySetTable();
    private AbstractQOSWizardPage wizardPage = this.createPage(this.namedBindingTable.size() == 0);

    public NamedBindingExportWizard() {
        this.wizardPage.setPolicySetViewerInput(this.namedBindingTable);
        this.addPage((IWizardPage)this.wizardPage);
        try {
            Bundle bundle = Platform.getBundle((String)"com.ibm.ast.ws.service.policy.ui");
            URL installURL = bundle.getEntry("/");
            URL imageURL = new URL(installURL, "icons/wizban/ExportNamedBindings.gif");
            ImageDescriptor image = ImageDescriptor.createFromURL((URL)imageURL);
            if (image != null) {
                this.setDefaultPageImageDescriptor(image);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        this.setWindowTitle(Messages.NamedBindingExportWizard_0);
    }

    public boolean performFinish() {
        return ZipUtils.createZipFile(this.getShell(), "bindings", this.zipFileName, this.namedBindingTable);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private AbstractQOSWizardPage createPage(boolean noPolicySets) {
        String title = noPolicySets ? Messages.NamedBindingExportWizard_1 : Messages.NamedBindingExportWizard_2;
        return new AbstractQOSWizardPage(title, false){

            @Override
            public IStatus textChanged(String fileName) {
                NamedBindingExportWizard.this.zipFileName = fileName;
                return null;
            }

            @Override
            public IStatus selectionChanged(CheckStateChangedEvent event) {
                return Status.OK_STATUS;
            }
        };
    }

    private Collection<ExportEntry> createPolicySetTable() {
        Vector<ExportEntry> result = new Vector<ExportEntry>();
        List<IServicePolicy> policies = NamedBindingstUtils.getClientNamedBindings(null);
        policies.addAll(NamedBindingstUtils.getProviderNamedBindings(null));
        for (IServicePolicy policy : policies) {
            IPolicyState state = policy.getPolicyState();
            String location = state.getValue("policyPath");
            Path path = new Path(location);
            if (!path.toString().startsWith("local:")) continue;
            ExportEntry entry = new ExportEntry();
            entry.setName(policy.getDescriptor().getShortName());
            entry.setSelected(true);
            entry.setPolicySetPath((IPath)path);
            result.add(entry);
        }
        return result;
    }
}

