/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.internal.service.policy.ui;

import com.ibm.ast.ws.internal.service.policy.ui.Messages;
import com.ibm.ast.ws.internal.service.policy.ui.utils.IEntry;
import com.ibm.ast.ws.internal.service.policy.ui.utils.Timer;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractQOSWizardPage
extends WizardPage
implements ICheckStateListener {
    private Text fileNameField;
    private Button browseButton;
    private ModifyListener textModifyListener;
    private Timer timer;
    private FileDialog fileDialog;
    private CheckboxTableViewer policySetsViewer;
    private Button selectAllButton;
    private Button deselectAllButton;
    private Collection<? extends IEntry> entryTable;
    private boolean displayErrorMessages;
    private boolean isImport;

    protected AbstractQOSWizardPage(String pageMessage, boolean isImport) {
        super("");
        this.isImport = isImport;
        this.timer = new Timer(){

            @Override
            public void handleTimerEvent() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractQOSWizardPage.this.handleTextChanged();
                    }
                });
            }
        };
        this.timer.start();
        this.setMessage(pageMessage);
        this.displayErrorMessages = false;
    }

    public void dispose() {
        super.dispose();
        this.timer.killTimer();
    }

    public abstract IStatus textChanged(String var1);

    public abstract IStatus selectionChanged(CheckStateChangedEvent var1);

    private void handleTextChanged() {
        IStatus errorStatus = this.textChanged(this.fileNameField.getText());
        if (errorStatus == null) {
            this.setErrorMessage(null);
            IStatus selectionChangedStatus = this.selectionChanged(null);
            int severity = selectionChangedStatus.getSeverity();
            String message = selectionChangedStatus.getMessage();
            if (severity == 4) {
                this.setErrorMessage(message);
            } else if (severity == 2) {
                this.setMessage(message, severity);
            } else {
                this.setMessage(null);
            }
        } else if (errorStatus.getSeverity() == 4 && this.displayErrorMessages) {
            this.setErrorMessage(errorStatus.getMessage());
        }
        this.checkForPageComplete();
    }

    public void setPolicySetViewerInput(Collection<? extends IEntry> entryTable) {
        this.entryTable = entryTable;
        if (this.selectAllButton != null) {
            this.selectAllButton.setEnabled(entryTable != null);
            this.deselectAllButton.setEnabled(entryTable != null);
            this.policySetsViewer.setInput(entryTable);
            this.policySetsViewer.setAllChecked(true);
            this.checkForPageComplete();
        }
    }

    public void createControl(Composite parent) {
        this.fileDialog = new FileDialog(parent.getShell());
        this.fileDialog.setFilterExtensions(new String[]{"*.zip"});
        Composite mainComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        mainComp.setLayout((Layout)layout);
        if (this.isImport) {
            this.createFileNameField(mainComp);
            this.createViewer(mainComp);
        } else {
            this.createViewer(mainComp);
            this.createFileNameField(mainComp);
        }
        if (this.entryTable != null) {
            this.setPolicySetViewerInput(this.entryTable);
        } else {
            this.checkForPageComplete();
        }
        this.setControl((Control)mainComp);
    }

    private void createViewer(Composite parent) {
        GridData griddata = new GridData(1808);
        griddata.horizontalSpan = 2;
        this.policySetsViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        this.policySetsViewer.getTable().setLayoutData((Object)griddata);
        this.policySetsViewer.getTable().setFont(parent.getFont());
        this.policySetsViewer.setContentProvider((IContentProvider)new PolicySetContentProvider());
        this.policySetsViewer.setLabelProvider((IBaseLabelProvider)new PolicySetLabelProvider());
        this.policySetsViewer.addCheckStateListener((ICheckStateListener)this);
        new Label(parent, 0);
        Composite buttonComp = new Composite(parent, 0);
        this.selectAllButton = new Button(buttonComp, 8);
        this.deselectAllButton = new Button(buttonComp, 8);
        griddata = new GridData();
        griddata.horizontalSpan = 3;
        buttonComp.setLayout((Layout)new RowLayout());
        buttonComp.setLayoutData((Object)griddata);
        this.selectAllButton.setText(Messages.AbstractQOSWizardPage_1);
        this.selectAllButton.setEnabled(false);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractQOSWizardPage.this.setAllChecked(true);
            }
        });
        this.deselectAllButton.setText(Messages.AbstractQOSWizardPage_2);
        this.deselectAllButton.setEnabled(false);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractQOSWizardPage.this.setAllChecked(false);
            }
        });
    }

    private void createFileNameField(Composite parent) {
        this.textModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractQOSWizardPage.this.timer.startTimer();
            }
        };
        new Label(parent, 0).setText(Messages.AbstractQOSWizardPage_3);
        this.fileNameField = new Text(parent, 2048);
        this.fileNameField.addModifyListener(this.textModifyListener);
        this.fileNameField.setLayoutData((Object)new GridData(768));
        this.browseButton = new Button(parent, 8);
        this.browseButton.setText(Messages.AbstractQOSWizardPage_4);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String zipFileLocation = AbstractQOSWizardPage.this.fileDialog.open();
                if (zipFileLocation != null) {
                    AbstractQOSWizardPage.this.fileNameField.removeModifyListener(AbstractQOSWizardPage.this.textModifyListener);
                    AbstractQOSWizardPage.this.fileNameField.setText(zipFileLocation);
                    AbstractQOSWizardPage.this.displayErrorMessages = true;
                    AbstractQOSWizardPage.this.handleTextChanged();
                    AbstractQOSWizardPage.this.fileNameField.addModifyListener(AbstractQOSWizardPage.this.textModifyListener);
                    AbstractQOSWizardPage.this.displayErrorMessages = false;
                }
            }
        });
    }

    private void setAllChecked(boolean checked) {
        this.policySetsViewer.setAllChecked(checked);
        for (IEntry iEntry : this.entryTable) {
            iEntry.setSelected(checked);
        }
        IStatus iStatus = this.selectionChanged(null);
        int severity = iStatus.getSeverity();
        String message = iStatus.getMessage();
        if (severity == 4) {
            this.setErrorMessage(message);
        } else if (severity == 2) {
            this.setMessage(message, severity);
        } else {
            this.setMessage(null);
        }
        this.checkForPageComplete();
    }

    private void checkForPageComplete() {
        String string;
        boolean result = false;
        if (this.entryTable != null) {
            for (IEntry iEntry : this.entryTable) {
                if (!iEntry.isSelected()) continue;
                result = true;
                break;
            }
        }
        if (result && ((string = this.fileNameField.getText()) == null || string.equals(""))) {
            result = false;
        }
        this.setPageComplete(result);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        IEntry entry = (IEntry)event.getElement();
        entry.setSelected(event.getChecked());
        IStatus selectionChangedStatus = this.selectionChanged(event);
        int severity = selectionChangedStatus.getSeverity();
        String message = selectionChangedStatus.getMessage();
        if (severity == 4 && this.displayErrorMessages) {
            this.setMessage(message, 4);
        } else if (severity == 2) {
            this.setMessage(message, severity);
        } else {
            this.setMessage(null);
        }
        this.checkForPageComplete();
    }

    private class PolicySetContentProvider
    implements ITreeContentProvider {
        private PolicySetContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                Collection entries = (Collection)inputElement;
                return entries.toArray(new IEntry[0]);
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class PolicySetLabelProvider
    extends LabelProvider {
        private PolicySetLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IEntry) {
                IEntry entry = (IEntry)element;
                return entry.getName();
            }
            return null;
        }
    }
}

