/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.widgets.binding;

import com.ibm.ast.ws.security.ui.command.ClientProjectCommand;
import com.ibm.ast.ws.security.ui.command.FindWebServicesCommand;
import com.ibm.ast.ws.security.ui.command.SecureClientBindingCommand;
import com.ibm.ast.ws.security.ui.command.SecureClientExtensionCommand;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.ast.ws.security.ui.widgets.EncryptionMatchingClientKeyStoreWidget;
import com.ibm.ast.ws.security.ui.widgets.KeyStoreInformationWidget;
import com.ibm.ast.ws.security.ui.widgets.OptionalSigningCertificateWidget;
import com.ibm.ast.ws.security.ui.widgets.WebServicesSelectionWidget;
import com.ibm.etools.webservice.was.consumption.command.VerifyIBMJRECommand;
import org.eclipse.wst.command.internal.env.core.common.Condition;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistry;
import org.eclipse.wst.command.internal.env.core.fragment.BooleanFragment;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragment;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragmentFactory;
import org.eclipse.wst.command.internal.env.core.fragment.SequenceFragment;
import org.eclipse.wst.command.internal.env.core.fragment.SimpleFragment;
import org.eclipse.wst.command.internal.env.ui.widgets.CanFinishRegistry;
import org.eclipse.wst.command.internal.env.ui.widgets.CommandWidgetBinding;
import org.eclipse.wst.command.internal.env.ui.widgets.SelectionCommand;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetContributorFactory;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetRegistry;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class SecureClientFromServiceWidgetBinding
implements CommandWidgetBinding {
    private DataMappingRegistry dataMappingRegistry_;

    public void registerWidgetMappings(WidgetRegistry widgetRegistry) {
        widgetRegistry.add("WebServicesSelectionWidget", this.getMessage("PAGE_TITLE_WEBSERVICE_SELECTION"), this.getMessage("PAGE_DESC_WEBSERVICE_SELECTION_MATCHING"), new WidgetContributorFactory(){

            public WidgetContributor create() {
                return new WebServicesSelectionWidget();
            }
        });
        widgetRegistry.add("KeyStoreInformationWidget", this.getMessage("PAGE_TITLE_TOKEN_GENERATOR"), this.getMessage("PAGE_DESC_CLIENT_SIDE_GENERATOR_SIGN"), new WidgetContributorFactory(){

            public WidgetContributor create() {
                return new KeyStoreInformationWidget();
            }
        });
        widgetRegistry.add("OptionalSigningCertificateWidget", this.getMessage("PAGE_TITLE_TOKEN_CONSUMER"), this.getMessage("PAGE_DESC_CLIENT_SIDE_CONSUMER_SIGN"), new WidgetContributorFactory(){

            public WidgetContributor create() {
                return new OptionalSigningCertificateWidget();
            }
        });
        widgetRegistry.add("EncryptionMatchingClientKeyStoreWidget", this.getMessage("PAGE_TITLE_KEY_STORE"), this.getMessage("PAGE_DESC_KEY_STORE"), new WidgetContributorFactory(){

            public WidgetContributor create() {
                return new EncryptionMatchingClientKeyStoreWidget();
            }
        });
    }

    private String getMessage(String key) {
        return WSSecurityUIPlugin.getMessage(key);
    }

    public void registerDataMappings(DataMappingRegistry dataRegistry) {
        this.dataMappingRegistry_ = dataRegistry;
        this.dataMappingRegistry_.addMapping(FindWebServicesCommand.class, "Services", WebServicesSelectionWidget.class);
        this.dataMappingRegistry_.addMapping(WebServicesSelectionWidget.class, "ConsumerSignatureKeyStore", OptionalSigningCertificateWidget.class, "KeyStore", null);
        this.dataMappingRegistry_.addMapping(WebServicesSelectionWidget.class, "Certificate", OptionalSigningCertificateWidget.class);
        this.dataMappingRegistry_.addMapping(WebServicesSelectionWidget.class, "GeneratorSignatureKeyStore", KeyStoreInformationWidget.class, "KeyStore", null);
        this.dataMappingRegistry_.addMapping(KeyStoreInformationWidget.class, "KeyStore", SecureClientBindingCommand.class, "CallbackKeyStore", null);
        this.dataMappingRegistry_.addMapping(OptionalSigningCertificateWidget.class, "KeyStore", SecureClientBindingCommand.class, "TrustAnchorKeyStore", null);
        this.dataMappingRegistry_.addMapping(OptionalSigningCertificateWidget.class, "Certificate", SecureClientBindingCommand.class);
        this.dataMappingRegistry_.addMapping(WebServicesSelectionWidget.class, "ServiceProject", SecureClientExtensionCommand.class);
        this.dataMappingRegistry_.addMapping(WebServicesSelectionWidget.class, "ServiceProject", SecureClientBindingCommand.class);
        this.dataMappingRegistry_.addMapping(WebServicesSelectionWidget.class, "ServiceName", SecureClientExtensionCommand.class);
        this.dataMappingRegistry_.addMapping(WebServicesSelectionWidget.class, "ServiceName", SecureClientBindingCommand.class);
    }

    public void registerCanFinish(CanFinishRegistry canFinishRegistry) {
    }

    public CommandFragmentFactory create() {
        return new CommandFragmentFactory(){

            public CommandFragment create() {
                return new SecureClientFromServiceCommandFragment();
            }
        };
    }

    private class EncryptionKeyInfoFragment
    extends BooleanFragment {
        public EncryptionKeyInfoFragment() {
            this.setTrueFragment((CommandFragment)new SimpleFragment("EncryptionMatchingClientKeyStoreWidget"));
        }

        public void setEncryptionKeyStoreRequired(boolean tokenGeneratorRequired) {
            if (tokenGeneratorRequired) {
                this.setCondition(new Condition(){

                    public boolean evaluate() {
                        return true;
                    }
                });
            } else {
                this.setCondition(new Condition(){

                    public boolean evaluate() {
                        return false;
                    }
                });
            }
        }
    }

    private class SecureClientFromServiceCommandFragment
    extends SequenceFragment {
        public SecureClientFromServiceCommandFragment() {
            this.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new VerifyIBMJRECommand("com.ibm.ast.ws.security.ui"), ""));
            this.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new ClientProjectCommand(), ""));
            this.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new FindWebServicesCommand(), ""));
            this.add((CommandFragment)new SimpleFragment("WebServicesSelectionWidget"));
            this.add((CommandFragment)new TokenGeneratorFragment());
            this.add((CommandFragment)new TokenConsumerFragment());
            this.add((CommandFragment)new EncryptionKeyInfoFragment());
            this.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new SecureClientExtensionCommand(), ""));
            this.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new SecureClientBindingCommand(), ""));
        }

        public void registerDataMappings(DataMappingRegistry dataRegistry) {
            dataRegistry.addMapping(SelectionCommand.class, "InitialSelection", ClientProjectCommand.class);
            dataRegistry.addMapping(WebServicesSelectionWidget.class, "TokenGeneratorRequired", TokenGeneratorFragment.class);
            dataRegistry.addMapping(WebServicesSelectionWidget.class, "TokenConsumerRequired", TokenConsumerFragment.class);
            dataRegistry.addMapping(WebServicesSelectionWidget.class, "EncryptionKeyStoreRequired", EncryptionKeyInfoFragment.class);
            dataRegistry.addMapping(WebServicesSelectionWidget.class, "GeneratorEncryptionKeyStore", EncryptionMatchingClientKeyStoreWidget.class);
            dataRegistry.addMapping(WebServicesSelectionWidget.class, "ConsumerEncryptionKeyStore", EncryptionMatchingClientKeyStoreWidget.class);
            SecureClientFromServiceWidgetBinding.this.dataMappingRegistry_.addMapping(EncryptionMatchingClientKeyStoreWidget.class, "GeneratorKeyStore", SecureClientBindingCommand.class);
            SecureClientFromServiceWidgetBinding.this.dataMappingRegistry_.addMapping(EncryptionMatchingClientKeyStoreWidget.class, "ConsumerKeyStore", SecureClientBindingCommand.class);
            dataRegistry.addMapping(ClientProjectCommand.class, "ServiceReference", SecureClientExtensionCommand.class);
            dataRegistry.addMapping(ClientProjectCommand.class, "ServiceReference", SecureClientBindingCommand.class);
            dataRegistry.addMapping(SecureClientExtensionCommand.class, "SecurityTokenList", SecureClientBindingCommand.class);
            dataRegistry.addMapping(SecureClientExtensionCommand.class, "RequiredSecurityTokenList", SecureClientBindingCommand.class);
        }
    }

    private class TokenConsumerFragment
    extends BooleanFragment {
        public TokenConsumerFragment() {
            this.setTrueFragment((CommandFragment)new SimpleFragment("OptionalSigningCertificateWidget"));
        }

        public void setTokenConsumerRequired(boolean tokenConsumerRequired) {
            if (tokenConsumerRequired) {
                this.setCondition(new Condition(){

                    public boolean evaluate() {
                        return true;
                    }
                });
            } else {
                this.setCondition(new Condition(){

                    public boolean evaluate() {
                        return false;
                    }
                });
            }
        }
    }

    private class TokenGeneratorFragment
    extends BooleanFragment {
        public TokenGeneratorFragment() {
            this.setTrueFragment((CommandFragment)new SimpleFragment("KeyStoreInformationWidget"));
        }

        public void setTokenGeneratorRequired(boolean tokenGeneratorRequired) {
            if (tokenGeneratorRequired) {
                this.setCondition(new Condition(){

                    public boolean evaluate() {
                        return true;
                    }
                });
            } else {
                this.setCondition(new Condition(){

                    public boolean evaluate() {
                        return false;
                    }
                });
            }
        }
    }
}

