/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.widgets;

import com.ibm.ast.ws.security.ui.common.KeyStoreInformation;
import com.ibm.ast.ws.security.ui.common.ServiceObject;
import com.ibm.ast.ws.security.ui.common.TokenCertificate;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class WebServicesSelectionWidget
extends SimpleWidgetDataContributor {
    protected Listener statusListener_;
    private Composite parent_;
    private Combo service;
    private Vector services;
    private ServiceObject selectedService;
    private boolean tokenGeneratorRequired;
    private boolean tokenConsumerRequired;
    private boolean keyStoreGeneratorRequired;
    private boolean keyStoreConsumerRequired;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.parent_ = parent;
        this.statusListener_ = statusListener;
        Composite composite = WSSecurityUIPlugin.getUiUtils().createComposite(this.parent_, 2);
        composite.setLayoutData((Object)WSSecurityUIPlugin.getUiUtils().createFillAll());
        this.service = WSSecurityUIPlugin.getUiUtils().createCombo(composite, WSSecurityUIPlugin.getMessage("LABEL_WEBSERVICES"), null, null, 2060);
        this.service.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                WebServicesSelectionWidget.this.selectionChanged();
            }

            public void widgetSelected(SelectionEvent e) {
                WebServicesSelectionWidget.this.selectionChanged();
            }
        });
        return this;
    }

    private void selectionChanged() {
        this.selectedService = (ServiceObject)this.services.get(this.service.getSelectionIndex());
        this.tokenGeneratorRequired = this.getServerConsumerSigningKeyInfo();
        this.tokenConsumerRequired = this.getServerGeneratorSigningKeyInfo();
        this.keyStoreGeneratorRequired = this.getServerGeneratorEncryptionKeyInfo();
        this.keyStoreConsumerRequired = this.getServerConsumerEncryptionKeyInfo();
        this.statusListener_.handleEvent(null);
    }

    public IStatus getStatus() {
        if (this.selectedService != null) {
            return Status.OK_STATUS;
        }
        return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage(""), null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getServerConsumerSigningKeyInfo() {
        WsbndArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForRead((IProject)this.selectedService.getServiceProject());
            WSBinding wsbnd = artifactEdit.getWSBinding();
            EList wscbindings = wsbnd.getWsdescBindings();
            int i = 0;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getServerConsumerEncryptionKeyInfo() {
        WsbndArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForRead((IProject)this.selectedService.getServiceProject());
            WSBinding wsbnd = artifactEdit.getWSBinding();
            EList wscbindings = wsbnd.getWsdescBindings();
            int i = 0;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getServerGeneratorSigningKeyInfo() {
        WsbndArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForRead((IProject)this.selectedService.getServiceProject());
            WSBinding wsbnd = artifactEdit.getWSBinding();
            EList wscbindings = wsbnd.getWsdescBindings();
            int i = 0;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getServerGeneratorEncryptionKeyInfo() {
        WsbndArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForRead((IProject)this.selectedService.getServiceProject());
            WSBinding wsbnd = artifactEdit.getWSBinding();
            EList wscbindings = wsbnd.getWsdescBindings();
            int i = 0;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    public IProject getServiceProject() {
        return this.selectedService.getServiceProject();
    }

    public void setServices(Vector services) {
        this.services = services;
        int i = 0;
        while (i < services.size()) {
            ServiceObject newService = (ServiceObject)services.get(i);
            this.service.add(newService.getDisplayName());
            ++i;
        }
        if (this.service.getItemCount() > 0) {
            this.service.select(0);
            this.selectionChanged();
        }
    }

    public String getServiceName() {
        return this.selectedService.getServiceName();
    }

    public boolean getTokenConsumerRequired() {
        return this.tokenConsumerRequired;
    }

    public boolean getTokenGeneratorRequired() {
        return this.tokenGeneratorRequired;
    }

    public boolean getEncryptionKeyStoreRequired() {
        return this.keyStoreConsumerRequired || this.keyStoreGeneratorRequired;
    }

    public TokenCertificate getCertificate() {
        if (this.tokenConsumerRequired) {
            return new TokenCertificate();
        }
        return null;
    }

    public KeyStoreInformation getConsumerSignatureKeyStore() {
        if (this.tokenConsumerRequired) {
            return new KeyStoreInformation();
        }
        return null;
    }

    public KeyStoreInformation getGeneratorSignatureKeyStore() {
        if (this.tokenGeneratorRequired) {
            return new KeyStoreInformation();
        }
        return null;
    }

    public KeyStoreInformation getConsumerEncryptionKeyStore() {
        if (this.keyStoreConsumerRequired) {
            return new KeyStoreInformation();
        }
        return null;
    }

    public KeyStoreInformation getGeneratorEncryptionKeyStore() {
        if (this.keyStoreGeneratorRequired) {
            return new KeyStoreInformation();
        }
        return null;
    }
}

