/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.widgets;

import com.ibm.ast.ws.security.ui.common.SignedCertificateToken;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.ast.ws.security.ui.tokens.AuthenticationToken;
import com.ibm.ast.ws.security.ui.widgets.ClientSideAuthenticationWidget;
import com.ibm.ast.ws.security.ui.widgets.KeyStoreInformationWidget;
import com.ibm.ast.ws.security.ui.widgets.SigningCertificateWidget;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class TokenGeneratorWidget
extends SimpleWidgetDataContributor {
    private SigningCertificateWidget signingCertWidget;
    private ClientSideAuthenticationWidget tokenGeneratorWidget;
    private KeyStoreInformationWidget keyStoreWidget;
    private SignedCertificateToken tokenGenerator;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        Group tokenGroup = WSSecurityUIPlugin.getUiUtils().createGroup(parent, WSSecurityUIPlugin.getMessage("%LABEL_TOKEN_GENERATOR"), null, null);
        this.tokenGeneratorWidget = new ClientSideAuthenticationWidget();
        this.tokenGeneratorWidget.addControls((Composite)tokenGroup, statusListener);
        this.keyStoreWidget = new KeyStoreInformationWidget();
        this.keyStoreWidget.addControls(parent, statusListener);
        this.signingCertWidget = new SigningCertificateWidget();
        this.signingCertWidget.addControls(parent, statusListener);
        return this;
    }

    public IStatus getStatus() {
        IStatus status = this.keyStoreWidget.getStatus();
        if (status.getSeverity() != 0) {
            return status;
        }
        return this.signingCertWidget.getStatus();
    }

    public boolean canFinish() {
        return true;
    }

    public SignedCertificateToken getTokenGenerator() {
        this.tokenGenerator.setCertificate(this.signingCertWidget.getCertificate());
        this.tokenGenerator.setToken(this.tokenGeneratorWidget.getToken());
        this.tokenGenerator.setKeyStore(this.keyStoreWidget.getKeyStore());
        return this.tokenGenerator;
    }

    public void setTokenGenerator(SignedCertificateToken tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
        this.signingCertWidget.setCertificate(tokenGenerator.getCertificate());
        this.keyStoreWidget.setKeyStore(tokenGenerator.getKeyStore());
    }

    public void setDigitalSignatureSecurityTokens(AuthenticationToken[] tokens) {
        this.tokenGeneratorWidget.setSecurityTokens(tokens);
        this.tokenGeneratorWidget.setToken(this.tokenGenerator.getToken());
    }
}

