/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.widgets;

import com.ibm.ast.ws.security.ui.common.SignedCertificateToken;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.ast.ws.security.ui.tokens.AuthenticationToken;
import com.ibm.ast.ws.security.ui.widgets.OptionalSigningCertificateWidget;
import com.ibm.ast.ws.security.ui.widgets.ServerSideAuthenticationWidget;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class TokenConsumerWidget
extends SimpleWidgetDataContributor {
    private OptionalSigningCertificateWidget signingCertWidget;
    private ServerSideAuthenticationWidget tokenConsumerWidget;
    private SignedCertificateToken tokenConsumer;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        Group tokenGroup = WSSecurityUIPlugin.getUiUtils().createGroup(parent, WSSecurityUIPlugin.getMessage("%LABEL_TOKEN_CONSUMER"), null, null);
        this.tokenConsumerWidget = new ServerSideAuthenticationWidget();
        this.tokenConsumerWidget.addControls((Composite)tokenGroup, statusListener);
        Composite certComposite = WSSecurityUIPlugin.getUiUtils().createComposite(parent, 1);
        this.signingCertWidget = new OptionalSigningCertificateWidget();
        this.signingCertWidget.addControls(certComposite, statusListener);
        return this;
    }

    public IStatus getStatus() {
        return this.signingCertWidget.getStatus();
    }

    public SignedCertificateToken getTokenConsumer() {
        this.tokenConsumer.setCertificate(this.signingCertWidget.getCertificate());
        this.tokenConsumer.setToken(this.tokenConsumerWidget.getToken());
        this.tokenConsumer.setKeyStore(this.signingCertWidget.getKeyStore());
        return this.tokenConsumer;
    }

    public void setTokenConsumer(SignedCertificateToken tokenConsumer) {
        this.tokenConsumer = tokenConsumer;
        this.signingCertWidget.setCertificate(tokenConsumer.getCertificate());
        this.signingCertWidget.setKeyStore(tokenConsumer.getKeyStore());
    }

    public void setDigitalSignatureSecurityTokens(AuthenticationToken[] tokens) {
        this.tokenConsumerWidget.setSecurityTokens(tokens);
        this.tokenConsumerWidget.setToken(this.tokenConsumer.getToken());
    }
}

